/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.mediumcore.event;

import com.github.alexmodguy.mediumcore.GameRuleRegistry;
import com.github.alexmodguy.mediumcore.Mediumcore;
import com.github.alexmodguy.mediumcore.misc.DedicatedServerPropertiesAccessor;
import com.github.alexmodguy.mediumcore.misc.MediumCoreData;
import com.github.alexmodguy.mediumcore.packet.SyncMediumcoreGameRuleMessage;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_3176;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import toni.lib.VersionUtils;
import toni.lib.modifiers.ModifierDefinition;

public class CommonEvents {
    private static final ModifierDefinition INITIAL_HEALTH_MODIFIER = new ModifierDefinition("mediumcore", "mediumcoreinitialhealthmod");
    private static final ModifierDefinition HEALTH_MODIFIER = new ModifierDefinition("mediumcore", "mediumcorehealthmod");

    public static void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            class_3176 dedicatedServer;
            boolean propertiesSayMediumcore;
            if (server.method_3816() && server instanceof class_3176 && (propertiesSayMediumcore = ((DedicatedServerPropertiesAccessor)(dedicatedServer = (class_3176)server).method_16705()).isServerMediumcore())) {
                Mediumcore.LOGGER.info("set server game rule for mediumcore because it is set to true in server.properties");
                GameRuleRegistry.setMediumcoreMode(server.method_3767(), true, server);
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!alive && !VersionUtils.level((class_1297)newPlayer).field_9236 && GameRuleRegistry.isMediumCoreMode(VersionUtils.level((class_1297)newPlayer).method_8450())) {
                double healthModifiedBy = MediumCoreData.getPlayerData((class_1309)newPlayer).healthModifiedBy;
                CommonEvents.updateHealth((class_1657)newPlayer, healthModifiedBy);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            boolean mediumcore = GameRuleRegistry.isMediumCoreMode(server.method_30002().method_8450());
            new SyncMediumcoreGameRuleMessage(mediumcore).send(handler.field_14140);
            if (!mediumcore) {
                return;
            }
            double healthModifiedBy = MediumCoreData.getPlayerData((class_1309)handler.field_14140).healthModifiedBy;
            CommonEvents.updateHealth((class_1657)handler.field_14140, healthModifiedBy);
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!(entity instanceof class_1657)) {
                return;
            }
            class_1657 player = (class_1657)entity;
            if (!GameRuleRegistry.isMediumCoreMode(VersionUtils.level((class_1297)player).method_8450())) {
                return;
            }
            MediumCoreData.PlayerData data = MediumCoreData.getPlayerData((class_1309)player);
            double clampedHealth = class_3532.method_15350((double)((double)player.method_6063() - (Double)Mediumcore.CONFIG.healthDecreasePerDeath.get()), (double)((Double)Mediumcore.CONFIG.minimumPlayerHealth.get()), (double)((Double)Mediumcore.CONFIG.maxPlayerHealth.get()));
            data.healthModifiedBy += clampedHealth - (double)player.method_6063();
            CommonEvents.updateHealth(player, data.healthModifiedBy);
        });
    }

    public static void updateHealth(class_1657 player, double healthModifiedBy) {
        class_1324 attribute = player.method_5996(class_5134.field_23716);
        INITIAL_HEALTH_MODIFIER.removeModifier(attribute);
        INITIAL_HEALTH_MODIFIER.addPermanentModifier(attribute, (Double)Mediumcore.CONFIG.startingPlayerHealth.get() - 20.0);
        HEALTH_MODIFIER.removeModifier(attribute);
        HEALTH_MODIFIER.addPermanentModifier(attribute, healthModifiedBy);
        player.method_6033(class_3532.method_15363((float)player.method_6032(), (float)0.0f, (float)player.method_6063()));
    }
}

