/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.data;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import io.wispforest.accessories.AccessoriesInternals;
import io.wispforest.accessories.api.slot.ExtraSlotTypeProperties;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.ReplaceableJsonResourceReloadListener;
import io.wispforest.accessories.data.SlotTypeLoader;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntitySlotLoader
extends ReplaceableJsonResourceReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().create();
    public static final EntitySlotLoader INSTANCE = new EntitySlotLoader();
    private Map<class_1299<?>, Map<String, SlotType>> server = new HashMap();
    private Map<class_1299<?>, Map<String, SlotType>> client = new HashMap();

    protected EntitySlotLoader() {
        super(GSON, LOGGER, "accessories/entity");
    }

    public static Map<String, SlotType> getEntitySlots(class_1309 livingEntity) {
        return EntitySlotLoader.getEntitySlots(livingEntity.method_37908(), livingEntity.method_5864());
    }

    public static Map<String, SlotType> getEntitySlots(class_1937 level, class_1299<?> entityType) {
        Map<String, SlotType> map = INSTANCE.getSlotTypes(level.field_9236, entityType);
        return map != null ? map : Map.of();
    }

    @Nullable
    public final Map<String, SlotType> getSlotTypes(boolean isClientSide, class_1299<?> entityType) {
        return this.getEntitySlotData(isClientSide).get(entityType);
    }

    @ApiStatus.Internal
    public final Map<class_1299<?>, Map<String, SlotType>> getEntitySlotData(boolean isClientSide) {
        return isClientSide ? this.client : this.server;
    }

    @ApiStatus.Internal
    public final void setEntitySlotData(Map<class_1299<?>, Map<String, SlotType>> data) {
        this.client = ImmutableMap.copyOf(data);
    }

    protected void apply(Map<class_2960, JsonObject> data, class_3300 resourceManager, class_3695 profiler) {
        Map<String, SlotType> allSlotTypes = SlotTypeLoader.INSTANCE.getSlotTypes(false);
        HashMap<class_1299, Map> tempMap = new HashMap<class_1299, Map>();
        for (Map.Entry<class_2960, JsonObject> entry : data.entrySet()) {
            class_2960 location = entry.getKey();
            JsonObject jsonObject = entry.getValue();
            if (!AccessoriesInternals.isValidOnConditions(jsonObject, this.directory, location, null)) continue;
            HashMap slots = new HashMap();
            JsonArray slotElements = this.safeHelper(class_3518::method_15261, jsonObject, "slots", new JsonArray(), location);
            this.decodeJsonArray(slotElements, "slot", location, element -> {
                String slotName = element.getAsString();
                return Pair.of((Object)slotName, (Object)((SlotType)allSlotTypes.get(slotName)));
            }, slotInfo -> {
                SlotType slotType = (SlotType)slotInfo.right();
                if (slotType != null) {
                    if (!ExtraSlotTypeProperties.getProperty((String)slotInfo.left(), false).strictMode()) {
                        slots.put(slotType.name(), slotType);
                    } else {
                        LOGGER.warn("Unable to add the given slot to the given group due to it being in strict mode! [Slot: {}]", slotInfo.left());
                    }
                } else if (slotType == null) {
                    LOGGER.warn("Unable to locate a given slot to add to a given entity('s) as it was not registered: [Slot: {}]", slotInfo.first());
                }
            });
            ArrayList entities = new ArrayList();
            JsonArray entityElements = this.safeHelper(class_3518::method_15261, jsonObject, "entities", new JsonArray(), location);
            this.decodeJsonArray(entityElements, "entity", location, element -> {
                String string = element.getAsString();
                if (string.contains("#")) {
                    class_2960 entityTypeTagLocation = class_2960.method_12829((String)string.replace("#", ""));
                    class_6862 entityTypeTag = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)entityTypeTagLocation);
                    return AccessoriesInternals.getHolder(entityTypeTag).map(holders -> holders.stream().map(class_6880::comp_349).collect(Collectors.toSet())).orElseGet(() -> {
                        LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType Tag used within a slot entry: [Location: {}]", (Object)string);
                        return Set.of();
                    });
                }
                return Optional.ofNullable(class_2960.method_12829((String)string)).map(location1 -> class_7923.field_41177.method_17966(location1).map(Set::of).orElse(Set.of())).orElseGet(() -> {
                    LOGGER.warn("[EntitySlotLoader]: Unable to locate the given EntityType within the registries for a slot entry: [Location: {}]", (Object)string);
                    return Set.of();
                });
            }, entities::addAll);
            for (class_1299 entityType : entities) {
                tempMap.computeIfAbsent(entityType, entityType1 -> new HashMap()).putAll(slots);
            }
        }
        for (Map.Entry<Object, Object> entry : UniqueSlotHandling.getSlotToEntities().entrySet()) {
            SlotType slotType = SlotTypeLoader.INSTANCE.getSlotTypes(false).get(entry.getKey());
            for (class_1299 entityType : (Set)entry.getValue()) {
                tempMap.computeIfAbsent(entityType, entityType1 -> new HashMap()).put(slotType.name(), slotType);
            }
        }
        this.server = ImmutableMap.copyOf(tempMap);
    }
}

