/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.graves.other;

import com.google.gson.JsonElement;
import eu.pb4.graves.config.BaseGson;
import eu.pb4.graves.other.GraveUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2748;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public record GenericCost<T>(Type<T> type, T object, int count) {
    public boolean takeCost(class_3222 player) {
        return player.method_7337() || this.type.checkCost(player, this.object, this.count, true);
    }

    public boolean checkCost(class_3222 player) {
        return player.method_7337() || this.type.checkCost(player, this.object, this.count, false);
    }

    public void returnCost(class_3222 player) {
        if (!player.method_7337()) {
            this.type.returnCost(player, this.object, this.count);
        }
    }

    public Map<String, class_2561> getPlaceholders() {
        return Map.of("cost", this.type.toText(this.object, this.count), "item", this.type.toName(this.object), "count", class_2561.method_43470((String)("" + this.count)));
    }

    public boolean isFree() {
        return this.type == Type.FREE;
    }

    @Override
    public String toString() {
        return "GenericCost{type=" + Type.TYPE_NAME.get(this.type) + ", object=" + this.object + ", count=" + this.count + "}";
    }

    public class_2561 toText() {
        return this.type.toText(this.object, this.count);
    }

    public static interface Type<T>
    extends CostFunc<T> {
        public static final Map<String, Type<?>> BY_TYPE = new HashMap();
        public static final Map<Type<?>, String> TYPE_NAME = new HashMap();
        public static final Type<Object> CREATIVE = Type.reg("creative", Type.of(class_1802.field_8866, true, (p, c, x) -> p.method_7337(), (p, c) -> {}));
        public static final Type<Object> FREE = Type.reg("free", Type.of(class_1802.field_8866, true, (p, c, x) -> true, (p, c) -> {}));
        public static final Type<Object> LEVEL = Type.reg("level", Type.of(class_1802.field_8287, false, (p, c, x) -> {
            if (p.field_7520 >= c) {
                if (x) {
                    p.field_7520 -= c;
                    p.field_13987.method_14364((class_2596)new class_2748(p.field_7510, p.field_7495, p.field_7520));
                }
                return true;
            }
            return false;
        }, (p, c) -> {
            p.field_7520 += c;
            p.field_13987.method_14364((class_2596)new class_2748(p.field_7510, p.field_7495, p.field_7520));
        }));
        public static final Type<class_1799> ITEM = Type.reg("item", new Type<class_1799>(){

            @Override
            public boolean checkCost(class_3222 player, class_1799 object, int count, boolean take) {
                int c = 0;
                for (int i2 = 0; i2 < player.method_31548().method_5439(); ++i2) {
                    class_1799 stack = player.method_31548().method_5438(i2);
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)object)) continue;
                    c += stack.method_7947();
                }
                if (c >= count) {
                    if (take) {
                        player.method_31548().method_29280(i -> !i.method_7960() && class_1799.method_31577((class_1799)i, (class_1799)object), count, GraveUtils.EMPTY_INVENTORY);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public class_1799 decodeConfig(JsonElement object) {
                class_1799 x;
                if (object != null && (x = (class_1799)BaseGson.GSON.fromJson(object, class_1799.class)) != null) {
                    return x;
                }
                return class_1799.field_8037;
            }

            @Override
            public JsonElement encodeConfig(class_1799 object) {
                return BaseGson.GSON.toJsonTree((Object)object);
            }

            @Override
            public class_1799 getIcon(class_1799 object, int count) {
                return object.method_7972();
            }

            @Override
            public class_2561 toName(class_1799 object) {
                return object.method_7964();
            }

            @Override
            public void returnCost(class_3222 player, class_1799 object, int count) {
                class_1799 copy = object.method_7972();
                copy.method_7939(count);
                player.method_7270(copy);
            }
        });

        public static <T> Type<T> reg(String id, Type<T> type) {
            BY_TYPE.put(id, type);
            TYPE_NAME.put(type, id);
            return type;
        }

        public static Type<Object> of(final class_1792 icon, final boolean singular, final ContextlessCost takeCost, final ReturnCostFunc returnCostFunc) {
            return new Type<Object>(){

                @Override
                public Object decodeConfig(JsonElement object) {
                    return null;
                }

                @Override
                public JsonElement encodeConfig(Object object) {
                    return null;
                }

                @Override
                public class_1799 getIcon(Object object, int count) {
                    return icon.method_7854();
                }

                @Override
                public class_2561 toName(Object object) {
                    return class_2561.method_43471((String)("text.graves.cost." + (String)TYPE_NAME.get(this)));
                }

                @Override
                public class_2561 toText(Object object, int i) {
                    return singular ? this.toName(object) : Type.super.toText(object, i);
                }

                @Override
                public boolean checkCost(class_3222 player, Object object, int count, boolean take) {
                    return takeCost.checkCost(player, count, take);
                }

                @Override
                public void returnCost(class_3222 player, Object object, int count) {
                    returnCostFunc.returnCost(player, count);
                }
            };
        }

        public T decodeConfig(@Nullable JsonElement var1);

        public JsonElement encodeConfig(T var1);

        public class_1799 getIcon(T var1, int var2);

        default public class_2561 toText(T object, int i) {
            return class_2561.method_43473().method_10852(this.toName(object)).method_27693(" \u00d7 ").method_27693("" + i);
        }

        public class_2561 toName(T var1);

        public void returnCost(class_3222 var1, T var2, int var3);

        public static interface ContextlessCost {
            public boolean checkCost(class_3222 var1, int var2, boolean var3);
        }

        public static interface ReturnCostFunc {
            public void returnCost(class_3222 var1, int var2);
        }
    }

    public static interface CostFunc<T> {
        public boolean checkCost(class_3222 var1, T var2, int var3, boolean var4);
    }
}

