/*
 * Decompiled with CFR 0.152.
 */
package com.finndog.moogs_structures.world.structures.pieces;

import com.finndog.moogs_structures.MoogsStructuresCommon;
import com.finndog.moogs_structures.modinit.MoogsStructuresStructurePieces;
import com.finndog.moogs_structures.utils.DebugFlags;
import com.finndog.moogs_structures.utils.VersionResolver;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3781;
import net.minecraft.class_3785;
import net.minecraft.class_3816;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionAwareSinglePoolElement
extends class_3781 {
    private static final Codec<List<VersionResolver.VersionEntry>> VERSION_ENTRIES_CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_2960.field_25139).flatXmap(VersionResolver::parseVersionMap, VersionResolver::encodeVersionEntries);
    public static final MapCodec<VersionAwareSinglePoolElement> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("location").forGetter(VersionAwareSinglePoolElement::singleLocation), (App)VERSION_ENTRIES_CODEC.optionalFieldOf("locations").forGetter(VersionAwareSinglePoolElement::versionEntriesOptional), (App)VersionAwareSinglePoolElement.method_28880(), (App)VersionAwareSinglePoolElement.method_28883()).apply((Applicative)instance, (singleLocation, versionEntries, processors, projection) -> new VersionAwareSinglePoolElement(singleLocation.orElse(null), versionEntries.map(List::copyOf).orElse(List.of()), (class_6880<class_5497>)processors, (class_3785.class_3786)projection)));
    public static final Codec<VersionAwareSinglePoolElement> CODEC = MAP_CODEC.codec();
    @Nullable
    private final class_2960 singleLocation;
    private final List<VersionResolver.VersionEntry> versionEntries;
    private final class_2960 defaultLocation;
    private final String versionEntriesDescription;

    private VersionAwareSinglePoolElement(@Nullable class_2960 singleLocation, List<VersionResolver.VersionEntry> versionEntries, class_6880<class_5497> processors, class_3785.class_3786 projection) {
        super(Either.left((Object)VersionAwareSinglePoolElement.resolveTargetLocation(singleLocation, versionEntries)), processors, projection);
        this.singleLocation = singleLocation;
        this.versionEntries = List.copyOf(versionEntries);
        class_2960 fallback = VersionAwareSinglePoolElement.computeDefaultLocation(singleLocation, this.versionEntries);
        if (fallback == null) {
            throw new IllegalArgumentException("Version-aware single pool element requires at least one template location");
        }
        this.defaultLocation = fallback;
        this.versionEntriesDescription = VersionAwareSinglePoolElement.describeVersionEntries(this.versionEntries);
        this.logFallbackIfNeeded();
    }

    @Nullable
    private static class_2960 computeDefaultLocation(@Nullable class_2960 singleLocation, List<VersionResolver.VersionEntry> entries) {
        if (singleLocation != null) {
            return singleLocation;
        }
        return entries.stream().findFirst().map(VersionResolver.VersionEntry::location).orElse(null);
    }

    private static class_2960 resolveTargetLocation(@Nullable class_2960 singleLocation, List<VersionResolver.VersionEntry> entries) {
        class_2960 fallback = VersionAwareSinglePoolElement.computeDefaultLocation(singleLocation, entries);
        if (fallback == null) {
            throw new IllegalArgumentException("Version-aware single pool element requires at least one template location");
        }
        VersionResolver.VersionNumber current = VersionResolver.getCurrentVersion();
        class_2960 target = VersionResolver.resolve(entries, current).map(VersionResolver.VersionEntry::location).orElse(fallback);
        if (DebugFlags.isEnabled()) {
            MoogsStructuresCommon.LOGGER.info("Moog's Structure Lib: Version-aware pool element selected template {} (fallback: {}, mappings: [{}])", (Object)target, (Object)fallback, (Object)entries.stream().map(entry -> entry.rawRange() + "->" + String.valueOf(entry.location())).collect(Collectors.joining(", ")));
        }
        return target;
    }

    private static String describeVersionEntries(List<VersionResolver.VersionEntry> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        return entries.stream().map(entry -> entry.rawRange() + "->" + String.valueOf(entry.location())).collect(Collectors.joining(", "));
    }

    private void logFallbackIfNeeded() {
        if (this.versionEntries.isEmpty()) {
            return;
        }
        VersionResolver.VersionNumber current = VersionResolver.getCurrentVersion();
        if (VersionResolver.resolve(this.versionEntries, current).isPresent()) {
            return;
        }
        class_2960 fallback = this.field_24015.left().orElse(this.defaultLocation);
        MoogsStructuresCommon.LOGGER.warn("Moog's Structure Lib: No version mapping matched runtime version {}. Falling back to template {}. Defined mappings: [{}]", (Object)VersionResolver.getCurrentVersionString(), (Object)fallback, (Object)this.versionEntriesDescription);
    }

    private Optional<List<VersionResolver.VersionEntry>> versionEntriesOptional() {
        return this.versionEntries.isEmpty() ? Optional.empty() : Optional.of(this.versionEntries);
    }

    private Optional<class_2960> singleLocation() {
        return Optional.ofNullable(this.singleLocation);
    }

    @NotNull
    public class_3816<?> method_16757() {
        return MoogsStructuresStructurePieces.VERSIONED_SINGLE.get();
    }

    @NotNull
    public String toString() {
        class_2960 resolved = this.field_24015.left().orElse(this.defaultLocation);
        if (this.versionEntriesDescription.isEmpty()) {
            return "VersionAwareSingle[" + String.valueOf(resolved) + "]";
        }
        return "VersionAwareSingle[" + String.valueOf(resolved) + " | " + this.versionEntriesDescription + "]";
    }
}

