/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.konkrete.config;

import de.keksuccino.konkrete.config.ConfigEntry;
import de.keksuccino.konkrete.config.exceptions.InvalidValueException;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Config {
    private String path;
    private File config;
    private Map<String, ConfigEntry> values = new HashMap<String, ConfigEntry>();
    private List<String> registeredValues = new ArrayList<String>();
    private String name = null;
    private List<String> categorys = new ArrayList<String>();

    public Config(String path) {
        File f;
        this.path = path;
        this.config = new File(path);
        if (this.config.isFile() && (f = this.config.getParentFile()) != null && !f.exists()) {
            f.mkdirs();
        }
        this.init();
    }

    private void init() {
        List<String> l = this.getTextFileData();
        if (l.isEmpty()) {
            return;
        }
        String category = null;
        String desc = null;
        String valueName = null;
        ConfigEntry.EntryType type = null;
        Object value = null;
        Boolean b = false;
        for (String s : l) {
            if (b.booleanValue()) {
                if (new StringBuilder(s).reverse().toString().replace(" ", "").startsWith(";'")) {
                    value = (String)value + "\n" + new StringBuilder(new StringBuilder(s).reverse().toString().split(";", 2)[1].substring(1)).reverse().toString();
                    if (category != null && valueName != null && type != null && !this.valueExists(valueName)) {
                        this.values.put(valueName, new ConfigEntry(valueName, (String)value, type, category, desc));
                        if (!this.categorys.contains(category)) {
                            this.categorys.add(category);
                        }
                    }
                    desc = null;
                    valueName = null;
                    type = null;
                    value = null;
                    b = false;
                } else {
                    value = value + "\n" + s;
                }
            }
            if (s.startsWith("##[")) {
                if (!s.contains("]")) continue;
                category = new StringBuilder(new StringBuilder(s.split("[\\[]", 2)[1]).reverse().toString().split("[\\]]")[1]).reverse().toString();
                continue;
            }
            if (s.startsWith("[")) {
                if (!s.contains("]")) continue;
                desc = new StringBuilder(new StringBuilder(s.split("[\\[]", 2)[1]).reverse().toString().split("[\\]]")[1]).reverse().toString();
                continue;
            }
            if (s.length() <= 0 || !s.substring(1).startsWith(":") || !s.contains("=") || !s.contains("'")) continue;
            valueName = s.split("[:]", 2)[1].replace(" ", "").split("=")[0];
            if (s.startsWith("I:")) {
                type = ConfigEntry.EntryType.INTEGER;
            }
            if (s.startsWith("S:")) {
                type = ConfigEntry.EntryType.STRING;
            }
            if (s.startsWith("B:")) {
                type = ConfigEntry.EntryType.BOOLEAN;
            }
            if (s.startsWith("L:")) {
                type = ConfigEntry.EntryType.LONG;
            }
            if (s.startsWith("D:")) {
                type = ConfigEntry.EntryType.DOUBLE;
            }
            if (s.startsWith("F:")) {
                type = ConfigEntry.EntryType.FLOAT;
            }
            if (new StringBuilder(s).reverse().toString().replace(" ", "").startsWith(";'")) {
                value = new StringBuilder(new StringBuilder(s.split("'", 2)[1]).reverse().toString().split(";", 2)[1].substring(1)).reverse().toString();
                if (category != null && valueName != null && type != null && !this.valueExists(valueName)) {
                    this.values.put(valueName, new ConfigEntry(valueName, (String)value, type, category, desc));
                    if (!this.categorys.contains(category)) {
                        this.categorys.add(category);
                    }
                }
                desc = null;
                valueName = null;
                type = null;
                value = null;
                continue;
            }
            value = s.split("'", 2)[1];
            b = true;
        }
    }

    public List<String> getCategorys() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.categorys);
        return l;
    }

    public String getConfigName() {
        return this.name;
    }

    public void setConfigName(String name) {
        this.name = name;
    }

    public void syncConfig() {
        Object data = "";
        Boolean b = false;
        if (this.name != null) {
            data = (String)data + "//" + this.name + "\n";
            b = true;
        }
        for (String s : this.getCategorys()) {
            List<ConfigEntry> l = this.getEntrysForCategory(s);
            if (l.isEmpty()) {
                this.categorys.remove(s);
                continue;
            }
            if (!b.booleanValue()) {
                b = true;
            } else {
                data = (String)data + "\n\n\n";
            }
            data = (String)data + "##[" + s + "]\n";
            for (ConfigEntry e : l) {
                String value = e.getValue();
                String valueName = e.getName();
                String desc = e.getDescription();
                ConfigEntry.EntryType type = e.getType();
                if (value == null || valueName == null || type == null) continue;
                if (desc != null) {
                    data = (String)data + "\n[" + desc + "]";
                }
                if (type == ConfigEntry.EntryType.STRING) {
                    data = (String)data + "\nS:" + valueName + " = '";
                }
                if (type == ConfigEntry.EntryType.INTEGER) {
                    data = (String)data + "\nI:" + valueName + " = '";
                }
                if (type == ConfigEntry.EntryType.BOOLEAN) {
                    data = (String)data + "\nB:" + valueName + " = '";
                }
                if (type == ConfigEntry.EntryType.LONG) {
                    data = (String)data + "\nL:" + valueName + " = '";
                }
                if (type == ConfigEntry.EntryType.DOUBLE) {
                    data = (String)data + "\nD:" + valueName + " = '";
                }
                if (type == ConfigEntry.EntryType.FLOAT) {
                    data = (String)data + "\nF:" + valueName + " = '";
                }
                data = (String)data + value + "';";
            }
        }
        File oldConfig = this.backupConfig();
        if (oldConfig == null) {
            System.out.println("############################################");
            System.out.println("WARNING: CONFIG BACKUP NOT SUCCESSFULL! (" + this.path + ")");
            System.out.println("############################################");
        }
        if (!this.config.exists()) {
            try {
                this.config.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.config), StandardCharsets.UTF_8));
            writer.write((String)data);
            writer.flush();
            oldConfig.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private File backupConfig() {
        File back = new File(this.config.getAbsolutePath() + ".backup");
        List<String> data = this.getTextFileData();
        Object data2 = "";
        if (!back.exists()) {
            try {
                back.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Boolean b = false;
        for (String s : data) {
            if (!b.booleanValue()) {
                b = true;
            } else {
                data2 = (String)data2 + "\n";
            }
            data2 = (String)data2 + s;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(back), StandardCharsets.UTF_8));
            writer.write((String)data2);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (back.exists()) {
            return back;
        }
        return null;
    }

    public List<ConfigEntry> getEntrysForCategory(String category) {
        ArrayList<ConfigEntry> l = new ArrayList<ConfigEntry>();
        for (Map.Entry<String, ConfigEntry> m : this.values.entrySet()) {
            if (!m.getValue().getCategory().equals(category)) continue;
            l.add(m.getValue());
        }
        return l;
    }

    private List<String> getTextFileData() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.config.exists()) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.config), StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    l.add(line);
                }
                reader.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return l;
    }

    public void registerValue(String uniqueName, Integer defaultValue, String category) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.INTEGER, null);
    }

    public void registerValue(String uniqueName, Double defaultValue, String category) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.DOUBLE, null);
    }

    public void registerValue(String uniqueName, Long defaultValue, String category) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.LONG, null);
    }

    public void registerValue(String uniqueName, Float defaultValue, String category) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.FLOAT, null);
    }

    public void registerValue(String uniqueName, Boolean defaultValue, String category) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.BOOLEAN, null);
    }

    public void registerValue(String uniqueName, String defaultValue, String category) throws InvalidValueException {
        this.registerRawValue(uniqueName, defaultValue, category, ConfigEntry.EntryType.STRING, null);
    }

    public void registerValue(String uniqueName, Integer defaultValue, String category, @Nullable String description) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.INTEGER, description);
    }

    public void registerValue(String uniqueName, Double defaultValue, String category, @Nullable String description) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.DOUBLE, description);
    }

    public void registerValue(String uniqueName, Float defaultValue, String category, @Nullable String description) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.FLOAT, description);
    }

    public void registerValue(String uniqueName, Long defaultValue, String category, @Nullable String description) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.LONG, description);
    }

    public void registerValue(String uniqueName, Boolean defaultValue, String category, @Nullable String description) throws InvalidValueException {
        this.registerRawValue(uniqueName, String.valueOf(defaultValue), category, ConfigEntry.EntryType.BOOLEAN, description);
    }

    public void registerValue(String uniqueName, String defaultValue, String category, @Nullable String description) throws InvalidValueException {
        this.registerRawValue(uniqueName, defaultValue, category, ConfigEntry.EntryType.STRING, description);
    }

    private void registerRawValue(String uniqueName, String defaultValue, String category, ConfigEntry.EntryType type, @Nullable String description) throws InvalidValueException {
        if (uniqueName == null) {
            throw new InvalidValueException("Value name cannot be null!");
        }
        if (defaultValue == null) {
            throw new InvalidValueException("Default value cannot be null!");
        }
        if (category == null) {
            throw new InvalidValueException("Category cannot be null!");
        }
        if (type == null) {
            throw new InvalidValueException("Type cannot be null!");
        }
        if (!this.categorys.contains(category)) {
            this.categorys.add(category);
        }
        if (type == ConfigEntry.EntryType.BOOLEAN && !defaultValue.equalsIgnoreCase("true") && !defaultValue.equalsIgnoreCase("false")) {
            throw new InvalidValueException("This value is not a valid BOOLEAN! (" + defaultValue + ")");
        }
        if (type == ConfigEntry.EntryType.INTEGER && !MathUtils.isInteger(defaultValue)) {
            throw new InvalidValueException("This value is not a valid INTEGER! (" + defaultValue + ")");
        }
        if (type == ConfigEntry.EntryType.DOUBLE && !MathUtils.isDouble(defaultValue)) {
            throw new InvalidValueException("This value is not a valid DOUBLE! (" + defaultValue + ")");
        }
        if (type == ConfigEntry.EntryType.FLOAT && !MathUtils.isFloat(defaultValue)) {
            throw new InvalidValueException("This value is not a valid FLOAT! (" + defaultValue + ")");
        }
        if (type == ConfigEntry.EntryType.LONG && !MathUtils.isLong(defaultValue)) {
            throw new InvalidValueException("This value is not a valid LONG! (" + defaultValue + ")");
        }
        if (!this.valueExists(uniqueName)) {
            this.values.put(uniqueName, new ConfigEntry(uniqueName, defaultValue, type, category, description));
        }
        this.registeredValues.add(uniqueName);
    }

    public ConfigEntry getAsEntry(String name) {
        if (this.valueExists(name)) {
            return this.values.get(name);
        }
        return null;
    }

    public List<ConfigEntry> getAllAsEntry() {
        ArrayList<ConfigEntry> l = new ArrayList<ConfigEntry>();
        l.addAll(this.values.values());
        return l;
    }

    public void setValue(String name, String value) throws InvalidValueException {
        if (!this.valueExists(name)) {
            return;
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() != ConfigEntry.EntryType.STRING) {
            throw new InvalidValueException("This value's type is " + e.getType() + "! It isn't possible to set a STRING value to it!");
        }
        e.setValue(value);
        this.syncConfig();
    }

    public void setValue(String name, Integer value) throws InvalidValueException {
        if (!this.valueExists(name)) {
            return;
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() != ConfigEntry.EntryType.INTEGER) {
            throw new InvalidValueException("This value's type is " + e.getType() + "! It isn't possible to set an INTEGER value to it!");
        }
        e.setValue(String.valueOf(value));
        this.syncConfig();
    }

    public void setValue(String name, Boolean value) throws InvalidValueException {
        if (!this.valueExists(name)) {
            return;
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() != ConfigEntry.EntryType.BOOLEAN) {
            throw new InvalidValueException("This value's type is " + e.getType() + "! It isn't possible to set a BOOLEAN value to it!");
        }
        e.setValue(String.valueOf(value));
        this.syncConfig();
    }

    public void setValue(String name, Float value) throws InvalidValueException {
        if (!this.valueExists(name)) {
            return;
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() != ConfigEntry.EntryType.FLOAT) {
            throw new InvalidValueException("This value's type is " + e.getType() + "! It isn't possible to set a FLOAT value to it!");
        }
        e.setValue(String.valueOf(value));
        this.syncConfig();
    }

    public void setValue(String name, Double value) throws InvalidValueException {
        if (!this.valueExists(name)) {
            return;
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() != ConfigEntry.EntryType.DOUBLE) {
            throw new InvalidValueException("This value's type is " + e.getType() + "! It isn't possible to set a DOUBLE value to it!");
        }
        e.setValue(String.valueOf(value));
        this.syncConfig();
    }

    public void setValue(String name, Long value) throws InvalidValueException {
        if (!this.valueExists(name)) {
            return;
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() != ConfigEntry.EntryType.LONG) {
            throw new InvalidValueException("This value's type is " + e.getType() + "! It isn't possible to set a LONG value to it!");
        }
        e.setValue(String.valueOf(value));
        this.syncConfig();
    }

    public void unregisterValue(String name) {
        if (this.valueExists(name)) {
            this.values.remove(name);
            if (this.registeredValues.contains(name)) {
                this.registeredValues.remove(name);
            }
        }
    }

    public Boolean getBoolean(String name) throws InvalidValueException {
        if (!this.valueExists(name)) {
            throw new InvalidValueException("This value does not exist! (" + name + ")");
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() == ConfigEntry.EntryType.BOOLEAN) {
            if (e.getValue().equalsIgnoreCase("true")) {
                return true;
            }
            if (e.getValue().equalsIgnoreCase("false")) {
                return false;
            }
            throw new InvalidValueException("This value is not a valid BOOLEAN value!");
        }
        throw new InvalidValueException("This value's type is not BOOLEAN!");
    }

    public String getString(String name) throws InvalidValueException {
        if (!this.valueExists(name)) {
            throw new InvalidValueException("This value does not exist! (" + name + ")");
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() == ConfigEntry.EntryType.STRING) {
            return e.getValue();
        }
        throw new InvalidValueException("This value's type is not STRING!");
    }

    public Integer getInteger(String name) throws InvalidValueException {
        if (!this.valueExists(name)) {
            throw new InvalidValueException("This value does not exist! (" + name + ")");
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() == ConfigEntry.EntryType.INTEGER) {
            if (MathUtils.isInteger(e.getValue())) {
                return Integer.parseInt(e.getValue());
            }
            throw new InvalidValueException("This value is not a valid INTEGER value!");
        }
        throw new InvalidValueException("This value's type is not INTEGER!");
    }

    public Double getDouble(String name) throws InvalidValueException {
        if (!this.valueExists(name)) {
            throw new InvalidValueException("This value does not exist! (" + name + ")");
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() == ConfigEntry.EntryType.DOUBLE) {
            if (MathUtils.isDouble(e.getValue())) {
                return Double.parseDouble(e.getValue());
            }
            throw new InvalidValueException("This value is not a valid DOUBLE value!");
        }
        throw new InvalidValueException("This value's type is not DOUBLE!");
    }

    public Long getLong(String name) throws InvalidValueException {
        if (!this.valueExists(name)) {
            throw new InvalidValueException("This value does not exist! (" + name + ")");
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() == ConfigEntry.EntryType.LONG) {
            if (MathUtils.isLong(e.getValue())) {
                return Long.parseLong(e.getValue());
            }
            throw new InvalidValueException("This value is not a valid LONG value!");
        }
        throw new InvalidValueException("This value's type is not LONG!");
    }

    public Float getFloat(String name) throws InvalidValueException {
        if (!this.valueExists(name)) {
            throw new InvalidValueException("This value does not exist! (" + name + ")");
        }
        ConfigEntry e = this.getAsEntry(name);
        if (e.getType() == ConfigEntry.EntryType.FLOAT) {
            if (MathUtils.isFloat(e.getValue())) {
                return Float.valueOf(Float.parseFloat(e.getValue()));
            }
            throw new InvalidValueException("This value is not a valid LONG value!");
        }
        throw new InvalidValueException("This value's type is not LONG!");
    }

    public void setCategory(String valueName, String category) throws InvalidValueException {
        if (this.valueExists(valueName)) {
            ConfigEntry e = this.getAsEntry(valueName);
            e.setCategory(category);
            if (!this.categorys.contains(category)) {
                this.categorys.add(category);
            }
        } else {
            throw new InvalidValueException("This values does not exist! (" + valueName + ")");
        }
        this.syncConfig();
    }

    public void setDescription(String valueName, String description) throws InvalidValueException {
        if (!this.valueExists(valueName)) {
            throw new InvalidValueException("This values does not exist! (" + valueName + ")");
        }
        ConfigEntry e = this.getAsEntry(valueName);
        e.setDescription(description);
        this.syncConfig();
    }

    public boolean valueExists(String name) {
        return this.values.containsKey(name);
    }

    public void clearUnusedValues() {
        ArrayList<String> l = new ArrayList<String>();
        for (Map.Entry<String, ConfigEntry> m : this.values.entrySet()) {
            if (this.registeredValues.contains(m.getKey())) continue;
            l.add(m.getKey());
        }
        for (String s : l) {
            this.unregisterValue(s);
        }
        this.syncConfig();
    }

    public <T> T getOrDefault(String valueName, T defaultValue) {
        try {
            if (defaultValue instanceof Integer) {
                return (T)this.getInteger(valueName);
            }
            if (defaultValue instanceof Boolean) {
                return (T)this.getBoolean(valueName);
            }
            if (defaultValue instanceof String) {
                return (T)this.getString(valueName);
            }
            if (defaultValue instanceof Long) {
                return (T)this.getLong(valueName);
            }
            if (defaultValue instanceof Double) {
                return (T)this.getDouble(valueName);
            }
            if (defaultValue instanceof Float) {
                return (T)this.getFloat(valueName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

