/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.registry;

import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemRegistry;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_2960;

public enum FilterRegistry implements FTBFilterSystemRegistry
{
    INSTANCE;

    private final Map<class_2960, FilterDetails<?>> filterMap = new ConcurrentHashMap();
    private final Map<class_2960, SmartFilter> defaultInstances = new ConcurrentHashMap<class_2960, SmartFilter>();
    private boolean frozen = false;

    @Override
    public <T extends SmartFilter> void register(class_2960 id, SmartFilter.Factory<T> factory, SmartFilter.DefaultFactory<T> defaultFactory) {
        if (this.frozen) {
            throw new IllegalStateException("filter registry is now frozen!");
        }
        this.filterMap.put(id, new FilterDetails<T>(id, factory, defaultFactory));
    }

    @Override
    public Collection<class_2960> allFilterKeys() {
        return Collections.unmodifiableCollection(this.filterMap.keySet());
    }

    @Override
    public Collection<SmartFilter> defaultFilterInstances() {
        return this.defaultInstances.values();
    }

    public Optional<FilterDetails<?>> getDetails(class_2960 type) {
        return Optional.ofNullable(this.filterMap.get(type));
    }

    public void freeze() {
        this.frozen = true;
        this.filterMap.forEach((id, entry) -> this.defaultInstances.put((class_2960)id, (SmartFilter)entry.defaultSupplier().create(null)));
    }

    public Optional<SmartFilter> createDefaultFilter(SmartFilter.Compound parent, class_2960 filterId) {
        if (this.filterMap.containsKey(filterId)) {
            return Optional.of(this.filterMap.get(filterId).defaultSupplier().create(parent));
        }
        return Optional.empty();
    }

    public record FilterDetails<T extends SmartFilter>(class_2960 id, SmartFilter.Factory<T> factory, SmartFilter.DefaultFactory<T> defaultSupplier) {
    }
}

