/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import dev.ftb.mods.ftbfiltersystem.FTBFilterSystem;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.network.FTBFilterSystemNet;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class SyncFilterMessage
extends BaseC2SMessage {
    private final String filterStr;
    @Nullable
    private final String newTitle;
    private final class_1268 hand;

    public SyncFilterMessage(String filterStr, @Nullable String newTitle, class_1268 hand) {
        this.filterStr = filterStr;
        this.newTitle = newTitle;
        this.hand = hand;
    }

    public SyncFilterMessage(class_2540 buf) {
        this.filterStr = buf.method_19772();
        this.newTitle = (String)buf.method_43827(class_2540::method_19772);
        this.hand = (class_1268)buf.method_10818(class_1268.class);
    }

    public MessageType getType() {
        return FTBFilterSystemNet.SYNC_FILTER;
    }

    public void write(class_2540 buf) {
        buf.method_10814(this.filterStr);
        buf.method_43826((Object)this.newTitle, class_2540::method_10814);
        buf.method_10817((Enum)this.hand);
    }

    public void handle(NetworkManager.PacketContext context) {
        class_1799 stack = context.getPlayer().method_5998(this.hand);
        if (stack.method_7909() instanceof SmartFilterItem) {
            try {
                SmartFilterItem.setFilter(stack, FilterParser.parse(this.filterStr).toString());
                if (this.newTitle != null) {
                    if (this.newTitle.isEmpty()) {
                        stack.method_7925();
                    } else {
                        stack.method_7977((class_2561)class_2561.method_43470((String)this.newTitle));
                    }
                }
            }
            catch (FilterException e) {
                FTBFilterSystem.LOGGER.error("received filter sync message with bad filter data from client {}: {}", (Object)context.getPlayer().method_7334().getName(), (Object)e.getMessage());
            }
        }
    }
}

