/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.filter;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.util.NBTUtil;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NbtFilter
extends AbstractSmartFilter {
    public static final class_2960 ID = FTBFilterSystemAPI.rl("nbt");
    protected final class_2487 tag;
    private final boolean fuzzyMatch;

    public NbtFilter(@Nullable SmartFilter.Compound parent) {
        this(parent, true, new class_2487());
    }

    public NbtFilter(SmartFilter.Compound parent, boolean fuzzyMatch, class_2487 tag) {
        super(parent);
        this.fuzzyMatch = fuzzyMatch;
        this.tag = tag;
    }

    @NotNull
    public static String getNBTPrefix(boolean fuzzy) {
        return fuzzy ? "fuzzy:" : "strict:";
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public boolean test(class_1799 stack) {
        return this.tag.method_33133() ? stack.method_7969() == null || stack.method_7969().method_33133() : (this.fuzzyMatch ? this.fuzzyMatch(stack.method_7969()) : this.tag.equals((Object)stack.method_7969()));
    }

    private boolean fuzzyMatch(class_2487 toMatch) {
        return this.tag != null && NBTUtil.compareNbt((class_2520)this.tag, (class_2520)toMatch, true, true);
    }

    @Override
    public String getStringArg() {
        return NbtFilter.getNBTPrefix(this.fuzzyMatch) + this.tag.toString();
    }

    public class_2487 getTag() {
        return this.tag;
    }

    public boolean isFuzzyMatch() {
        return this.fuzzyMatch;
    }

    public static NbtFilter fromString(SmartFilter.Compound parent, String str) {
        try {
            boolean fuzzy = true;
            if (str.startsWith("strict:") || str.startsWith("fuzzy:")) {
                fuzzy = str.startsWith("fuzzy:");
                str = str.substring(str.indexOf(58) + 1);
            }
            return new NbtFilter(parent, fuzzy, NbtFilter.parseNBT(str));
        }
        catch (CommandSyntaxException e) {
            throw new FilterException("invalid NBT tag: " + str, e);
        }
    }

    private static class_2487 parseNBT(String str) throws CommandSyntaxException {
        if (!((String)str).startsWith("{") && !((String)str).endsWith("}")) {
            str = "{" + (String)str + "}";
        }
        return class_2522.method_10718((String)str);
    }
}

