/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomSelectionList;
import dev.ftb.mods.ftbfiltersystem.filter.ModFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_5250;
import net.minecraft.class_768;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModConfigScreen
extends AbstractFilterConfigScreen<ModFilter>
implements GhostDropReceiver {
    private static String lastSearch;
    private final List<ModData> matchingModData = new ArrayList<ModData>();
    private class_342 searchField;
    private ModList modList;

    public ModConfigScreen(ModFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 200, 176);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.searchField = this.makeSearchEditBox(this.leftPos + 8, this.topPos + 20, () -> lastSearch, s -> {
            lastSearch = s;
        });
        this.updateSearchEntries();
        this.modList = new ModList(this.field_22787, this.getListWidth() + 8, this.getListHeight(), this.topPos + 32, this.topPos + 35 + this.getListHeight());
        this.modList.method_25333(this.leftPos + 8);
        this.modList.method_31322(false);
        this.modList.method_31323(false);
        this.method_25429((class_364)this.modList);
        this.modList.method_25396().stream().filter(child -> child.modData.modId().equals(((ModFilter)this.filter).getStringArg())).findFirst().ifPresent(entry -> this.modList.selectAndCenter(entry));
    }

    @Override
    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.modList.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    @Nullable
    protected ModFilter makeNewFilter() {
        return this.modList.method_25334() != null ? new ModFilter(((ModFilter)this.filter).getParent(), ((ModList.ModEntry)this.modList.method_25334()).modData.modId) : null;
    }

    @Override
    protected void doScheduledUpdate() {
        this.updateSearchEntries();
        this.modList.addChildren();
    }

    private int getListHeight() {
        return 148;
    }

    private int getListWidth() {
        return 176;
    }

    private void updateSearchEntries() {
        String srch = this.searchField.method_1882().toLowerCase(Locale.ROOT);
        this.matchingModData.clear();
        this.matchingModData.addAll(Platform.getMods().stream().filter(mod -> srch.isEmpty() || mod.getModId().toLowerCase(Locale.ROOT).contains(srch)).map(mod -> new ModData(mod.getModId(), mod.getName())).sorted().toList());
    }

    @Override
    public class_768 getGhostDropRegion() {
        return new class_768(this.leftPos + 9, this.topPos + 33, this.getListWidth() + 6, this.getListHeight() + 2);
    }

    @Override
    public void receiveGhostDrop(class_1799 stack) {
        String modId = stack.method_7909().arch$registryName().method_12836();
        this.modList.method_25396().stream().filter(entry -> entry.modData.modId.equals(modId)).findFirst().ifPresent(modEntry -> this.modList.selectAndCenter(modEntry));
    }

    private class ModList
    extends CustomSelectionList<ModEntry> {
        private static final int ELEMENT_HEIGHT = 12;

        public ModList(class_310 minecraft, int width, int height, int top, int bottom) {
            super(minecraft, width, height, top, bottom, 12);
            this.addChildren();
        }

        @Override
        protected List<ModEntry> buildChildrenList() {
            return ModConfigScreen.this.matchingModData.stream().map(x$0 -> new ModEntry((ModData)x$0)).toList();
        }

        private class ModEntry
        extends CustomSelectionList.Entry<ModEntry> {
            private final ModData modData;

            private ModEntry(ModData modData) {
                this.modData = modData;
            }

            public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
                class_5250 txt = class_2561.method_43470((String)this.modData.modId()).method_27696(class_2583.field_24360.method_36139(0x202060)).method_10852((class_2561)class_2561.method_43470((String)" [")).method_10852((class_2561)class_2561.method_43470((String)this.modData.modName()).method_27696(class_2583.field_24360.method_36139(8405024))).method_10852((class_2561)class_2561.method_43470((String)"]"));
                guiGraphics.method_51439(ModConfigScreen.this.field_22793, (class_2561)txt, left + 1, top + 1, 0x404040, false);
            }

            @Override
            protected boolean onMouseClick(double x, double y, int button, boolean isDoubleClick) {
                ModList.this.method_25313((class_350.class_351)this);
                if (isDoubleClick) {
                    ModConfigScreen.this.applyChanges();
                }
                return true;
            }

            public class_2561 method_37006() {
                return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.modData.modId()});
            }
        }
    }

    private record ModData(String modId, String modName) implements Comparable<ModData>
    {
        @Override
        public int compareTo(@NotNull ModData modData) {
            return this.modId.compareTo(modData.modId);
        }
    }
}

