/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.gui.GhostDropReceiver;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.ItemWidget;
import dev.ftb.mods.ftbfiltersystem.filter.ItemFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_7225;
import net.minecraft.class_768;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ItemConfigScreen
extends AbstractFilterConfigScreen<ItemFilter>
implements GhostDropReceiver {
    private static final class_2960 SCROLL_TEXTURE = new class_2960("textures/gui/container/creative_inventory/tabs.png");
    private static final int SEARCH_ROWS = 4;
    private static final int SEARCH_COLS = 9;
    private static ItemSource itemSource = ItemSource.CREATIVE;
    private static String lastSearch = "";
    private static List<SearchEntry> cachedCreativeEntries;
    private static List<SearchEntry> cachedInventoryEntries;
    private final List<class_1799> currentStacks = new ArrayList<class_1799>();
    private class_768 scrollArea;
    private double currentScroll;
    private boolean isScrolling;
    private class_342 searchField;
    private final List<SearchItemWidget> itemWidgets = new ArrayList<SearchItemWidget>();
    private ItemWidget selectedWidget;

    public ItemConfigScreen(ItemFilter filter, AbstractFilterScreen parentScreen) {
        super(filter, parentScreen, 194, 115);
        cachedInventoryEntries = null;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.searchField = this.makeSearchEditBox(this.leftPos + 8, this.topPos + 38, () -> lastSearch, s -> {
            lastSearch = s;
        });
        this.method_37063((class_364)this.searchField);
        this.method_25395((class_364)this.searchField);
        this.selectedWidget = (ItemWidget)this.method_37063((class_364)new ItemWidget(this.leftPos + 8, this.topPos + 17, 18, 18, class_1799.field_8037));
        int btnWidth = Arrays.stream(ItemSource.values()).map(val -> this.field_22793.method_27525((class_5348)val.getDisplayName())).max(Integer::compareTo).orElse(50) + 10;
        this.method_37063((class_364)class_5676.method_32606(ItemSource::getDisplayName).method_32624((Object[])ItemSource.values()).method_32616().method_32619((Object)itemSource).method_32617(this.leftPos + this.guiWidth - btnWidth - 21, this.topPos + 5, btnWidth, 16, (class_2561)class_2561.method_43473(), (btn, val) -> {
            itemSource = val;
            this.updateSearchEntries();
        }));
        this.itemWidgets.clear();
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                SearchItemWidget w = new SearchItemWidget(row, col);
                this.itemWidgets.add(w);
                this.method_37063((class_364)w);
            }
        }
        this.scrollArea = new class_768(this.leftPos + 174, this.topPos + 52, 14, 70);
        this.setSelectedStack(new class_1799((class_1935)((ItemFilter)this.filter).getMatchItem()));
        this.updateSearchEntries();
    }

    private void setSelectedStack(class_1799 stack) {
        this.selectedWidget.setStack(stack.method_7972());
    }

    @Override
    protected void doScheduledUpdate() {
        this.updateSearchEntries();
    }

    @Override
    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
        int sx = this.scrollArea.method_3321();
        int sy1 = this.scrollArea.method_3322();
        int sy2 = sy1 + this.scrollArea.method_3320();
        class_5348 txt = GuiUtil.ellipsize(this.field_22793, (class_5348)this.selectedWidget.getStack().method_7909().method_7848(), this.leftPos + this.guiWidth - (this.selectedWidget.method_46426() + this.selectedWidget.method_25368() + 6));
        guiGraphics.method_51430(this.field_22793, class_2477.method_10517().method_30934(txt), this.selectedWidget.method_46426() + this.selectedWidget.method_25368() + 3, this.selectedWidget.method_46427() + 8, 0x404040, false);
        guiGraphics.method_25294(this.scrollArea.method_3321() - 2, this.scrollArea.method_3322() - 2, this.scrollArea.method_3321() + this.scrollArea.method_3319(), this.scrollArea.method_3322() + this.scrollArea.method_3320(), -8355712);
        guiGraphics.method_25294(this.scrollArea.method_3321() - 1, this.scrollArea.method_3322() - 1, this.scrollArea.method_3321() + this.scrollArea.method_3319() - 1, this.scrollArea.method_3322() + this.scrollArea.method_3320() - 1, -6250336);
        guiGraphics.method_25302(SCROLL_TEXTURE, sx, sy1 + (int)((double)(sy2 - sy1 - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
    }

    public boolean method_25401(double x, double y, double dir) {
        if (dir != 0.0 && this.needsScrollBars()) {
            int j = this.currentStacks.size() / 10 - 3 + 1;
            float i = dir > 0.0 ? 1.0f : -1.0f;
            this.scrollTo(class_3532.method_15350((double)(this.currentScroll - (double)(i / (float)j)), (double)0.0, (double)1.0));
            return true;
        }
        return super.method_25401(x, y, dir);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl = this.isScrolling = button == 0 && this.needsScrollBars() && this.scrollArea.method_3318((int)mouseX, (int)mouseY);
        if (this.isScrolling) {
            this.scrollToMouse(mouseY);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            this.scrollToMouse(mouseY);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    protected ItemFilter makeNewFilter() {
        return new ItemFilter(((ItemFilter)this.filter).getParent(), this.selectedWidget.getStack().method_7909());
    }

    private boolean needsScrollBars() {
        return this.currentStacks.size() > 36;
    }

    private void scrollToMouse(double mouseY) {
        this.scrollTo(class_3532.method_15350((double)((mouseY - (double)this.scrollArea.method_3322()) / (double)this.scrollArea.method_3320()), (double)0.0, (double)1.0));
    }

    private void scrollTo(double scrollPos) {
        this.currentScroll = scrollPos;
        int i = this.currentStacks.size() / 9 - 4 + 1;
        int j = Math.max(0, (int)(this.currentScroll * (double)i + 0.5));
        for (int row = 0; row < 4; ++row) {
            for (int col = 0; col < 9; ++col) {
                int idx = col + (row + j) * 9;
                class_1799 stack = idx >= 0 && idx < this.currentStacks.size() ? this.currentStacks.get(idx) : class_1799.field_8037;
                this.itemWidgets.get(row * 9 + col).setStack(stack);
            }
        }
    }

    private void updateSearchEntries() {
        this.currentStacks.clear();
        String srch = this.searchField.method_1882().toLowerCase();
        List<class_1799> applicableEntries = itemSource.get().stream().filter(entry -> entry.test(srch)).map(entry -> entry.stack).toList();
        this.currentStacks.addAll(applicableEntries);
        this.scrollTo(0.0);
    }

    @Override
    public class_768 getGhostDropRegion() {
        return new class_768(this.selectedWidget.method_46426(), this.selectedWidget.method_46427(), this.selectedWidget.method_25368(), this.selectedWidget.method_25364());
    }

    @Override
    public void receiveGhostDrop(class_1799 stack) {
        this.selectedWidget.setStack(stack);
    }

    static enum ItemSource {
        CREATIVE(ItemSource::getCreativeItems, "creative"),
        INV(ItemSource::getInventoryItems, "inventory");

        private final Supplier<List<SearchEntry>> itemSupplier;
        private final class_2561 name;

        private ItemSource(Supplier<List<SearchEntry>> itemSupplier, String name) {
            this.itemSupplier = itemSupplier;
            this.name = class_2561.method_43471((String)("ftbfiltersystem.gui.item_source." + name));
        }

        List<SearchEntry> get() {
            return this.itemSupplier.get();
        }

        public class_2561 getDisplayName() {
            return this.name;
        }

        private static List<SearchEntry> getCreativeItems() {
            if (cachedCreativeEntries == null) {
                class_7706.method_47330((class_7699)class_7701.field_40183, (boolean)false, (class_7225.class_7874)class_310.method_1551().field_1687.method_30349());
                cachedCreativeEntries = class_7706.method_47344().method_47313().stream().map(SearchEntry::new).toList();
            }
            return cachedCreativeEntries;
        }

        private static List<SearchEntry> getInventoryItems() {
            if (cachedInventoryEntries == null) {
                int i;
                class_1661 inv = class_310.method_1551().field_1724.method_31548();
                cachedInventoryEntries = new ArrayList<SearchEntry>();
                for (i = 9; i < 36; ++i) {
                    cachedInventoryEntries.add(new SearchEntry((class_1799)inv.field_7547.get(i)));
                }
                for (i = 0; i < 9; ++i) {
                    cachedInventoryEntries.add(new SearchEntry((class_1799)inv.field_7547.get(i)));
                }
            }
            return cachedInventoryEntries;
        }
    }

    private class SearchItemWidget
    extends ItemWidget {
        public SearchItemWidget(int row, int col) {
            super(ItemConfigScreen.this.leftPos + 8 + 18 * col, ItemConfigScreen.this.topPos + 50 + 18 * row, 18, 18, class_1799.field_8037);
        }

        @Override
        protected void handleClick(boolean doubleClick) {
            if (doubleClick) {
                ItemConfigScreen.this.applyChanges();
            } else {
                ItemConfigScreen.this.setSelectedStack(this.getStack());
            }
        }

        @Nullable
        public class_7919 method_51254() {
            return super.method_51254();
        }
    }

    static class SearchEntry
    implements Predicate<String> {
        public final class_1799 stack;
        private final String tooltip;

        SearchEntry(class_1799 stack) {
            List l;
            this.stack = stack;
            try {
                class_310 mc = class_310.method_1551();
                l = stack.method_7950((class_1657)mc.field_1724, (class_1836)(mc.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)).stream().map(class_2561::getString).collect(Collectors.toList());
            }
            catch (Exception ignored) {
                l = Collections.emptyList();
            }
            this.tooltip = String.join((CharSequence)"\n", l).toLowerCase();
        }

        @Override
        public boolean test(String searchString) {
            return this.tooltip.contains(searchString);
        }
    }
}

