/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client;

import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.GuiUtil;
import dev.ftb.mods.ftbfiltersystem.client.gui.widget.CustomStringWidget;
import dev.ftb.mods.ftbfiltersystem.registry.FilterRegistry;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7845;
import net.minecraft.class_7847;
import net.minecraft.class_7919;
import net.minecraft.class_8021;

public class SelectionPanel {
    private static final int BUTTON_HEIGHT = 16;
    private boolean visible;
    private class_7845 layout;
    private static final class_2561 COMPOUND = class_2561.method_43471((String)"ftbfiltersystem.gui.compound");
    private static final class_2561 BASIC = class_2561.method_43471((String)"ftbfiltersystem.gui.basic");
    private final class_327 font;
    private class_768 bounds;
    private final List<class_4185> compoundButtons = new ArrayList<class_4185>();
    private final List<class_4185> basicButtons = new ArrayList<class_4185>();

    public SelectionPanel(class_327 font, Consumer<class_2960> onClicked, int availableHeight) {
        this.font = font;
        this.createButtons(font, onClicked);
        int maxPerColumn = Math.max(1, availableHeight / 18) - 1;
        this.arrangeButtons(maxPerColumn);
    }

    public void resize(int newAvailableHeight) {
        int maxPerColumn = Math.max(1, newAvailableHeight / 18) - 1;
        this.arrangeButtons(maxPerColumn);
    }

    private void createButtons(class_327 font, Consumer<class_2960> onClicked) {
        int widestButton = Math.max(font.method_27525((class_5348)BASIC), font.method_27525((class_5348)COMPOUND));
        for (SmartFilter filter2 : FilterRegistry.INSTANCE.defaultFilterInstances()) {
            widestButton = Math.max(widestButton, font.method_27525((class_5348)filter2.getDisplayName()) + 10);
        }
        for (SmartFilter filter2 : FilterRegistry.INSTANCE.defaultFilterInstances().stream().sorted(Comparator.comparing(filter -> filter.getDisplayName().getString())).toList()) {
            class_2960 id = filter2.getId();
            class_4185 button = class_4185.method_46430((class_2561)filter2.getDisplayName(), b -> onClicked.accept(id)).method_46437(widestButton, 16).method_46436(class_7919.method_47407((class_2561)AbstractSmartFilter.getTooltip(id))).method_46431();
            button.field_22764 = false;
            (filter2 instanceof SmartFilter.Compound ? this.compoundButtons : this.basicButtons).add(button);
        }
    }

    private void arrangeButtons(int maxPerColumn) {
        ArrayList<List<Object>> buttons = new ArrayList<List<Object>>();
        buttons.add(this.compoundButtons);
        int nBasic = this.basicButtons.size();
        if (nBasic > maxPerColumn) {
            int div = nBasic / (nBasic / maxPerColumn + 1) + 1;
            ArrayList<class_4185> l = new ArrayList<class_4185>();
            for (int i = 0; i < nBasic; ++i) {
                l.add(this.basicButtons.get(i));
                if (i % div != div - 1 && i != nBasic - 1) continue;
                buttons.add(new ArrayList(l));
                l.clear();
            }
        } else {
            buttons.add(this.basicButtons);
        }
        this.layout = new class_7845();
        class_7847 padding = class_7847.method_46481().method_46464(1);
        class_7847 paddingR = class_7847.method_46481().method_46464(1).method_46473(10);
        this.layout.method_46455((class_8021)new CustomStringWidget(COMPOUND, this.font).method_48597().method_46438(-14671744), 0, 0, paddingR);
        this.layout.method_46455((class_8021)new CustomStringWidget(BASIC, this.font).method_48597().method_46438(-14671744), 0, 1, padding);
        for (int col = 0; col < buttons.size(); ++col) {
            for (int row = 0; row < ((List)buttons.get(col)).size(); ++row) {
                this.layout.method_46455((class_8021)((class_4185)((List)buttons.get(col)).get(row)), row + 1, col, col == 0 ? paddingR : padding);
            }
        }
        this.layout.method_48222();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.layout.method_48206(w -> {
            w.field_22764 = visible;
        });
    }

    public void visitWidgets(Consumer<class_339> consumer) {
        this.layout.method_48206(consumer);
    }

    public void positionAndRender(class_332 guiGraphics, int topEdge, int rightEdge, int mouseX, int mouseY, float partialTick) {
        int xBase = Math.max(5, rightEdge - this.layout.method_25368());
        this.bounds = new class_768(xBase, topEdge, this.layout.method_25368(), this.layout.method_25364());
        this.layout.method_48229(this.bounds.method_3321(), this.bounds.method_3322());
        GuiUtil.drawPanel(guiGraphics, GuiUtil.outsetRect(this.bounds, 3), -2697514, -12566464, GuiUtil.BorderStyle.PLAIN, 1);
        guiGraphics.method_25301(xBase + this.compoundButtons.get(0).method_25368() + 5, topEdge, topEdge + this.layout.method_25364(), -6250336);
        this.visitWidgets(w -> w.method_25394(guiGraphics, mouseX, mouseY, partialTick));
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.bounds != null && this.bounds.method_3318((int)mouseX, (int)mouseY);
    }
}

