/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.client;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.client.FTBFilterSystemClientAPI;
import dev.ftb.mods.ftbfiltersystem.api.client.FilterScreenFactory;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterConfigScreen;
import dev.ftb.mods.ftbfiltersystem.api.event.client.ClientFilterRegistrationEvent;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.client.gui.CustomConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.DurabilityConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.ExpressionConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.FilterScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.FoodValueConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.ItemConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.ItemTagConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.MaxCountConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.ModConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.NBTConfigScreen;
import dev.ftb.mods.ftbfiltersystem.client.gui.StackSizeConfigScreen;
import dev.ftb.mods.ftbfiltersystem.filter.CustomFilter;
import dev.ftb.mods.ftbfiltersystem.filter.DurabilityFilter;
import dev.ftb.mods.ftbfiltersystem.filter.ExpressionFilter;
import dev.ftb.mods.ftbfiltersystem.filter.FoodValueFilter;
import dev.ftb.mods.ftbfiltersystem.filter.ItemFilter;
import dev.ftb.mods.ftbfiltersystem.filter.ItemTagFilter;
import dev.ftb.mods.ftbfiltersystem.filter.MaxStackSizeFilter;
import dev.ftb.mods.ftbfiltersystem.filter.ModFilter;
import dev.ftb.mods.ftbfiltersystem.filter.NbtFilter;
import dev.ftb.mods.ftbfiltersystem.filter.StackSizeFilter;
import dev.ftb.mods.ftbfiltersystem.registry.FilterRegistry;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_485;
import net.minecraft.class_746;

public enum FTBFilterSystemClient implements FTBFilterSystemClientAPI
{
    INSTANCE;

    private final Map<class_2960, FilterScreenFactory<?>> screenFactories = new ConcurrentHashMap();

    public void init() {
        FTBFilterSystemAPI._initClient(this);
        ClientLifecycleEvent.CLIENT_SETUP.register(this::onClientSetup);
        ClientLifecycleEvent.CLIENT_STARTED.register(this::onClientStarted);
        ClientFilterRegistrationEvent.REGISTER.register(this::registerClientFilters);
    }

    private void registerClientFilters(FTBFilterSystemClientAPI api) {
        api.registerFilterScreenFactory(ItemFilter.ID, ItemConfigScreen::new);
        api.registerFilterScreenFactory(DurabilityFilter.ID, DurabilityConfigScreen::new);
        api.registerFilterScreenFactory(MaxStackSizeFilter.ID, MaxCountConfigScreen::new);
        api.registerFilterScreenFactory(StackSizeFilter.ID, StackSizeConfigScreen::new);
        api.registerFilterScreenFactory(FoodValueFilter.ID, FoodValueConfigScreen::new);
        api.registerFilterScreenFactory(ItemTagFilter.ID, ItemTagConfigScreen::new);
        api.registerFilterScreenFactory(ModFilter.ID, ModConfigScreen::new);
        api.registerFilterScreenFactory(NbtFilter.ID, NBTConfigScreen::new);
        api.registerFilterScreenFactory(CustomFilter.ID, CustomConfigScreen::new);
        api.registerFilterScreenFactory(ExpressionFilter.ID, ExpressionConfigScreen::new);
    }

    private void onClientStarted(class_310 minecraft) {
        ((ClientFilterRegistrationEvent)ClientFilterRegistrationEvent.REGISTER.invoker()).registerFilters(FTBFilterSystemAPI.clientApi());
    }

    public void onClientSetup(class_310 minecraft) {
        FilterRegistry.INSTANCE.freeze();
    }

    public void openFilterScreen(class_1268 interactionHand) {
        class_746 player = class_310.method_1551().field_1724;
        class_1799 stack = player.method_5998(interactionHand);
        if (stack.method_7909() instanceof SmartFilterItem) {
            try {
                class_310.method_1551().method_1507((class_437)new FilterScreen(stack.method_7964(), SmartFilterItem.getFilter(stack), interactionHand));
            }
            catch (FilterException e) {
                player.method_7353((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061), false);
            }
        }
    }

    public <T extends SmartFilter> void openFilterConfigScreen(T filter, FilterScreen parent, boolean deleteOnCancel) {
        FilterScreenFactory<?> factory = this.screenFactories.get(filter.getId());
        if (factory != null) {
            AbstractFilterConfigScreen<?> screen = factory.createScreen(filter, parent);
            screen.setDeleteOnCancel(deleteOnCancel);
            class_310.method_1551().method_1507(screen);
        }
    }

    public static boolean isPlayerHolding(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        return player != null && (player.method_6047() == stack || player.method_6079() == stack);
    }

    public static boolean shouldShowItemTooltip() {
        return class_310.method_1551().field_1755 instanceof class_485;
    }

    @Override
    public <T extends SmartFilter> void registerFilterScreenFactory(class_2960 filterId, FilterScreenFactory<T> factory) {
        this.screenFactories.put(filterId, factory);
    }
}

