/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api.client.gui;

import dev.ftb.mods.ftbfiltersystem.api.client.Textures;
import dev.ftb.mods.ftbfiltersystem.api.client.gui.AbstractFilterScreen;
import dev.ftb.mods.ftbfiltersystem.api.filter.AbstractSmartFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_768;
import net.minecraft.class_7843;
import net.minecraft.class_7849;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8208;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFilterConfigScreen<T extends SmartFilter>
extends class_437 {
    protected final T filter;
    protected final AbstractFilterScreen parentScreen;
    protected final int guiWidth;
    protected final int guiHeight;
    protected int leftPos;
    protected int topPos;
    protected T modifiedFilter;
    private int updateCounter = 0;
    private boolean deleteOnCancel = false;
    private boolean changesApplied = false;
    private class_768 bounds = new class_768(0, 0, 0, 0);

    public AbstractFilterConfigScreen(T filter, AbstractFilterScreen parentScreen, int guiWidth, int guiHeight) {
        super(filter.getDisplayName());
        this.filter = filter;
        this.modifiedFilter = filter;
        this.parentScreen = parentScreen;
        this.guiWidth = guiWidth;
        this.guiHeight = guiHeight + 40;
    }

    protected final void scheduleUpdate(int ticks) {
        this.updateCounter = ticks;
    }

    protected void doScheduledUpdate() {
    }

    @Nullable
    protected abstract T makeNewFilter();

    public final class_768 getGuiBounds() {
        return this.bounds;
    }

    protected void method_25426() {
        this.setupGuiDimensions();
        class_7849 bottomPanel = new class_7849(this.leftPos, this.topPos + this.guiHeight - 25, this.guiWidth, 20, class_7849.class_7851.field_40789);
        ((class_7843)bottomPanel.method_46495((class_8021)new class_7843(this.guiWidth / 2, 20))).method_46441((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), b -> this.applyChanges()).method_46432(70).method_46431());
        ((class_7843)bottomPanel.method_46495((class_8021)new class_7843(this.guiWidth / 2, 20))).method_46441((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), b -> this.method_25419()).method_46432(70).method_46431());
        bottomPanel.method_48222();
        bottomPanel.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        class_8208 img = (class_8208)this.method_37063((class_364)new class_8208(this.leftPos + this.guiWidth - 19, this.topPos + 3, 16, 16, Textures.INFO_ICON));
        img.method_47400(class_7919.method_47407((class_2561)AbstractSmartFilter.getTooltip(this.filter.getId())));
    }

    public void method_25393() {
        if (this.updateCounter > 0 && --this.updateCounter == 0) {
            this.doScheduledUpdate();
        }
    }

    public void method_25419() {
        this.field_22787.method_1507((class_437)this.parentScreen);
        this.parentScreen.findAndSelect((SmartFilter)this.filter);
        if (!this.changesApplied && this.deleteOnCancel) {
            this.parentScreen.deleteSelectedFilter(true);
        }
    }

    public void method_25394(class_332 guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_25420(guiGraphics);
        guiGraphics.method_48586(Textures.BACKGROUND, this.leftPos, this.topPos, this.guiWidth, this.guiHeight, 4, 32, 32, 0, 0);
        guiGraphics.method_25292(this.leftPos + 3, this.leftPos + this.guiWidth - 4, this.topPos + this.guiHeight - 29, -2143272896);
        guiGraphics.method_25292(this.leftPos + 3, this.leftPos + this.guiWidth - 4, this.topPos + this.guiHeight - 28, -2130706433);
        guiGraphics.method_51439(this.field_22793, this.field_22785, this.leftPos + 8, this.topPos + 6, 0x404040, false);
        super.method_25394(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    protected final class_342 makeSearchEditBox(int x, int y, Supplier<String> prevStrSupplier, Consumer<String> prevStrConsumer) {
        Objects.requireNonNull(this.field_22793);
        class_342 editBox = new class_342(this.field_22793, x, y, 88, 9 + 1, (class_2561)class_2561.method_43473());
        editBox.method_1880(15);
        editBox.method_1858(true);
        editBox.method_1862(true);
        editBox.method_1868(0xFFFFFF);
        editBox.method_1852(prevStrSupplier.get());
        editBox.method_1863(s -> {
            if (!s.equals(prevStrSupplier.get())) {
                this.scheduleUpdate(5);
                prevStrConsumer.accept((String)s);
            }
        });
        this.method_37063((class_364)editBox);
        this.method_25395((class_364)editBox);
        return editBox;
    }

    private void setupGuiDimensions() {
        this.leftPos = (this.field_22789 - this.guiWidth) / 2;
        this.topPos = (this.field_22790 - this.guiHeight) / 2;
        this.bounds = new class_768(this.leftPos, this.topPos, this.field_22789, this.field_22790);
    }

    protected final void applyChanges() {
        T newFilter = this.makeNewFilter();
        if (newFilter != null) {
            this.parentScreen.replaceFilter(this.filter, newFilter);
            this.changesApplied = true;
        }
        this.method_25419();
    }

    public void setDeleteOnCancel(boolean deleteOnCancel) {
        this.deleteOnCancel = deleteOnCancel;
    }
}

