/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem.api;

import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntPredicate;
import net.minecraft.class_156;
import net.minecraft.class_2561;

public class NumericComparison
implements IntPredicate {
    private final ComparisonOp op;
    private final int value;
    private final boolean percentage;

    public NumericComparison(ComparisonOp op, int value, boolean percentage) {
        this.op = op;
        this.value = value;
        this.percentage = percentage;
    }

    public static NumericComparison fromString(String str, boolean allowPercentages) throws FilterException {
        boolean pct = false;
        if (str.endsWith("%")) {
            if (!allowPercentages) {
                throw new FilterException("Percentage used but not permitted in: '" + str + "'");
            }
            pct = true;
            str = str.substring(0, str.length() - 1);
        }
        int numStart = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            numStart = i;
            break;
        }
        if (numStart < 0) {
            throw new FilterException("Missing number in: '" + str + "'");
        }
        String numStr = str.substring(numStart);
        String opStr = str.substring(0, numStart);
        try {
            int val = Integer.parseInt(numStr);
            ComparisonOp op = ComparisonOp.byString(opStr).orElseThrow(() -> new FilterException("Invalid comparison op: '" + opStr + "'"));
            return new NumericComparison(op, val, pct);
        }
        catch (NumberFormatException e) {
            throw new FilterException("Invalid number: '" + numStr + "'");
        }
    }

    public String toString() {
        return this.op.toString() + this.value + (this.percentage ? "%" : "");
    }

    @Override
    public boolean test(int toCheck) {
        return this.op.test(toCheck, this.value);
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public int getValue() {
        return this.value;
    }

    public ComparisonOp getOp() {
        return this.op;
    }

    public static enum ComparisonOp {
        EQ("=", (v1, v2) -> v1 == v2),
        NE("!=", (v1, v2) -> v1 != v2),
        GT(">", (v1, v2) -> v1 > v2),
        LT("<", (v1, v2) -> v1 < v2),
        LE("<=", (v1, v2) -> v1 <= v2),
        GE(">=", (v1, v2) -> v1 >= v2);

        private final String str;
        private final ValuePredicate predicate;
        private static final Map<String, ComparisonOp> map;

        private ComparisonOp(String str, ValuePredicate predicate) {
            this.str = str;
            this.predicate = predicate;
        }

        public static Optional<ComparisonOp> byString(String str) {
            return Optional.ofNullable(map.get(str));
        }

        public boolean test(int val1, int val2) {
            return this.predicate.compare(val1, val2);
        }

        public String toString() {
            return this.str;
        }

        public class_2561 getDisplayName() {
            return class_2561.method_43470((String)this.str);
        }

        static {
            ComparisonOp.map = (Map)class_156.method_654(new HashMap(), map -> Arrays.stream(ComparisonOp.values()).forEach(op -> map.put(op.str, op)));
        }
    }

    static interface ValuePredicate {
        public boolean compare(int var1, int var2);
    }
}

