/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbfiltersystem;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.ftb.mods.ftbfiltersystem.api.FTBFilterSystemAPI;
import dev.ftb.mods.ftbfiltersystem.api.FilterException;
import dev.ftb.mods.ftbfiltersystem.api.filter.DumpedFilter;
import dev.ftb.mods.ftbfiltersystem.api.filter.SmartFilter;
import dev.ftb.mods.ftbfiltersystem.registry.item.SmartFilterItem;
import dev.ftb.mods.ftbfiltersystem.util.FilterParser;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

public class FilterSystemCommands {
    public static final DynamicCommandExceptionType PARSE_FAILED = new DynamicCommandExceptionType(object -> class_2561.method_43469((String)"ftbfiltersystem.message.parse_failed", (Object[])new Object[]{object}));
    public static final SimpleCommandExceptionType NOT_A_FILTER = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbfiltersystem.message.not_a_filter"));
    public static final SimpleCommandExceptionType NO_OFFHAND_ITEM = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"ftbfiltersystem.message.no_offhand_item"));
    private static final class_2561 TICK_MARK = class_2561.method_43470((String)"\u2713 ").method_27692(class_124.field_1060);
    private static final class_2561 X_MARK = class_2561.method_43470((String)"\u2717 ").method_27692(class_124.field_1061);

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 context, class_2170.class_5364 selection) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ftbfiltersystem").then(class_2170.method_9247((String)"parse").then(class_2170.method_9244((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FilterSystemCommands.tryParseCommand((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"string")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"get_filter").executes(ctx -> FilterSystemCommands.tryShowFilter((class_2168)ctx.getSource(), false))).then(class_2170.method_9247((String)"pretty").executes(ctx -> FilterSystemCommands.tryShowFilter((class_2168)ctx.getSource(), true))))).then(class_2170.method_9247((String)"set_filter").then(class_2170.method_9244((String)"string", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> FilterSystemCommands.trySetFilter((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"string")))))).then(class_2170.method_9247((String)"try_match").executes(ctx -> FilterSystemCommands.tryMatch((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"dump_nbt").requires(ctx -> ctx.method_9259(2))).executes(ctx -> FilterSystemCommands.dumpNbt((class_2168)ctx.getSource()))));
    }

    private static int tryParseCommand(class_2168 source, String string) throws CommandSyntaxException {
        try {
            for (DumpedFilter entry : FTBFilterSystemAPI.api().dump(FilterParser.parse(string))) {
                source.method_9226(() -> {
                    class_5250 txt = entry.filter().getDisplayName().method_27661().method_27692(class_124.field_1075);
                    if (!(entry.filter() instanceof SmartFilter.Compound)) {
                        txt.method_27693(" ").method_10852((class_2561)entry.filter().getDisplayArg().method_27661().method_27692(class_124.field_1054));
                    }
                    return class_2561.method_43470((String)FilterSystemCommands.makeDumpPrefix(entry.indent())).method_27692(class_124.field_1054).method_10852((class_2561)txt);
                }, false);
            }
        }
        catch (FilterException e) {
            throw PARSE_FAILED.create((Object)e.getMessage());
        }
        return 0;
    }

    private static int tryShowFilter(class_2168 source, boolean prettyPrint) throws CommandSyntaxException {
        String filterString = SmartFilterItem.getFilterString(FilterSystemCommands.getHeldFilter(source));
        if (prettyPrint) {
            return FilterSystemCommands.tryParseCommand(source, filterString);
        }
        source.method_9226(() -> class_2561.method_43470((String)filterString), false);
        return 1;
    }

    private static int trySetFilter(class_2168 source, String string) throws CommandSyntaxException {
        try {
            SmartFilterItem.setFilter(FilterSystemCommands.getHeldFilter(source), FilterParser.parse(string).toString());
            return 1;
        }
        catch (FilterException e) {
            source.method_9213((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1061));
            return 0;
        }
    }

    public static int tryMatch(class_2168 source) throws CommandSyntaxException {
        class_1799 offhandItem = source.method_9207().method_6079();
        if (offhandItem.method_7960()) {
            throw NO_OFFHAND_ITEM.create();
        }
        SmartFilter filter = FilterParser.parse(SmartFilterItem.getFilterString(FilterSystemCommands.getHeldFilter(source)));
        if (filter.test(offhandItem)) {
            source.method_9226(() -> TICK_MARK.method_27661().method_10852((class_2561)class_2561.method_43469((String)"ftbfiltersystem.message.matched", (Object[])new Object[]{offhandItem.method_7954()})), false);
            return 1;
        }
        source.method_9226(() -> X_MARK.method_27661().method_10852((class_2561)class_2561.method_43469((String)"ftbfiltersystem.message.not_matched", (Object[])new Object[]{offhandItem.method_7954()})), false);
        return 0;
    }

    private static int dumpNbt(class_2168 source) throws CommandSyntaxException {
        class_1799 stack = source.method_9207().method_6047();
        if (stack.method_7985()) {
            source.method_9226(() -> class_2561.method_43470((String)"NBT dump:").method_27692(class_124.field_1054), false);
            source.method_9226(() -> class_2561.method_43470((String)stack.method_7969().toString()), false);
            return 1;
        }
        source.method_9213((class_2561)class_2561.method_43470((String)"No NBT").method_27692(class_124.field_1061));
        return 0;
    }

    private static class_1799 getHeldFilter(class_2168 source) throws CommandSyntaxException {
        class_1799 stack = source.method_9207().method_6047();
        if (stack.method_7909() instanceof SmartFilterItem) {
            return stack;
        }
        throw NOT_A_FILTER.create();
    }

    private static String makeDumpPrefix(int indent) {
        if (indent == 0) {
            return "";
        }
        String s1 = "\u2503 ".repeat(indent - 1);
        return s1 + "\u2523\u2501";
    }
}

