/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.web.server.paths;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sun.net.httpserver.HttpExchange;
import com.teamresourceful.resourcefulconfig.common.annotations.ByteRange;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.annotations.DoubleRange;
import com.teamresourceful.resourcefulconfig.common.annotations.FloatRange;
import com.teamresourceful.resourcefulconfig.common.annotations.IntRange;
import com.teamresourceful.resourcefulconfig.common.annotations.LongRange;
import com.teamresourceful.resourcefulconfig.common.annotations.ShortRange;
import com.teamresourceful.resourcefulconfig.common.config.Configurations;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.web.annotations.Multiline;
import com.teamresourceful.resourcefulconfig.web.info.ResourcefulWebConfig;
import com.teamresourceful.resourcefulconfig.web.info.UserJwtPayload;
import com.teamresourceful.resourcefulconfig.web.server.paths.BasePath;
import com.teamresourceful.resourcefulconfig.web.utils.WebServerUtils;
import com.teamresourceful.resourcefulconfig.web.utils.WebVerifier;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.function.BiFunction;
import net.minecraft.class_1074;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public record GetConfigPath(WebVerifier verifier) implements BasePath
{
    @Override
    public void handleCall(HttpExchange exchange, UserJwtPayload payload) throws IOException {
        String query = WebServerUtils.getQueryValue(exchange, "id");
        if (query != null) {
            ResourcefulConfig config = Configurations.INSTANCE.configs().get(query);
            if (config != null && !config.getWebConfig().hidden()) {
                JsonObject json = GetConfigPath.createWebConfig(config);
                WebServerUtils.send(exchange, 200, "application/json", json.toString().getBytes());
            } else {
                WebServerUtils.send(exchange, 400, null, new byte[0]);
            }
        } else {
            WebServerUtils.send(exchange, 400, null, new byte[0]);
        }
    }

    @Override
    public String method() {
        return "GET";
    }

    private static JsonObject createWebConfig(ResourcefulConfig config) {
        ResourcefulWebConfig resourcefulWebConfig = config.getWebConfig();
        JsonObject json = GetConfigPath.createWebConfigData(config);
        json.addProperty("icon", resourcefulWebConfig.icon());
        json.addProperty("title", resourcefulWebConfig.title());
        json.addProperty("description", resourcefulWebConfig.description());
        json.add("links", (JsonElement)resourcefulWebConfig.toJsonLinks());
        return json;
    }

    private static JsonObject createWebConfigData(ResourcefulConfig config) {
        JsonObject json = new JsonObject();
        json.add("entries", (JsonElement)GetConfigPath.createEntries(config));
        JsonArray categories = new JsonArray();
        config.getSubConfigs().forEach((id, category) -> {
            ResourcefulWebConfig info = ResourcefulWebConfig.showOf(category.getWebConfig());
            if (!info.hidden()) {
                JsonObject categoryJson = GetConfigPath.createWebConfigData(category);
                categoryJson.addProperty("id", id);
                categoryJson.addProperty("icon", info.icon());
                categoryJson.addProperty("title", GetConfigPath.getTitle(info.title(), category));
                categories.add((JsonElement)categoryJson);
            }
        });
        json.add("categories", (JsonElement)categories);
        return json;
    }

    private static JsonArray createEntries(ResourcefulConfig config) {
        JsonArray array = new JsonArray();
        config.getEntries().forEach((id, entry) -> {
            JsonObject json = new JsonObject();
            switch (entry.type()) {
                case BYTE: {
                    ByteRange byteRange = entry.getAnnotation(ByteRange.class);
                    NumberRange range = byteRange != null ? new NumberRange(byteRange.min(), byteRange.max()) : null;
                    GetConfigPath.createNumber(json, entry, range, ParsingUtils::getByte);
                    break;
                }
                case SHORT: {
                    ShortRange shortRange = entry.getAnnotation(ShortRange.class);
                    NumberRange range = shortRange != null ? new NumberRange(shortRange.min(), shortRange.max()) : null;
                    GetConfigPath.createNumber(json, entry, range, ParsingUtils::getShort);
                    break;
                }
                case INTEGER: {
                    IntRange intRange = entry.getAnnotation(IntRange.class);
                    NumberRange range = intRange != null ? new NumberRange(intRange.min(), intRange.max()) : null;
                    GetConfigPath.createNumber(json, entry, range, ParsingUtils::getInt);
                    break;
                }
                case LONG: {
                    LongRange longRange = entry.getAnnotation(LongRange.class);
                    NumberRange range = longRange != null ? new NumberRange(longRange.min(), longRange.max()) : null;
                    GetConfigPath.createNumber(json, entry, range, ParsingUtils::getLong);
                    break;
                }
                case FLOAT: {
                    FloatRange floatRange = entry.getAnnotation(FloatRange.class);
                    NumberRange range = floatRange != null ? new NumberRange(Float.valueOf(floatRange.min()), Float.valueOf(floatRange.max())) : null;
                    GetConfigPath.createNumber(json, entry, range, ParsingUtils::getFloat);
                    break;
                }
                case DOUBLE: {
                    DoubleRange doubleRange = entry.getAnnotation(DoubleRange.class);
                    NumberRange range = doubleRange != null ? new NumberRange(doubleRange.min(), doubleRange.max()) : null;
                    GetConfigPath.createNumber(json, entry, range, ParsingUtils::getDouble);
                    break;
                }
                case ENUM: {
                    Enum def = (Enum)entry.defaultValue();
                    json.addProperty("type", "dropdown");
                    json.addProperty("current", ParsingUtils.getEnum(entry.field(), def).name());
                    json.addProperty("default", def.name());
                    JsonArray options = new JsonArray();
                    for (Enum<?> e : GetConfigPath.getEnumConstants(entry.field().getType())) {
                        options.add(e.name());
                    }
                    json.add("options", (JsonElement)options);
                    break;
                }
                case BOOLEAN: {
                    boolean def = entry.getDefaultOrElse(false);
                    json.addProperty("type", "toggle");
                    json.addProperty("current", Boolean.valueOf(ParsingUtils.getBoolean(entry.field(), def)));
                    json.addProperty("default", Boolean.valueOf(def));
                    break;
                }
                case STRING: {
                    boolean multiline = entry.getAnnotation(Multiline.class) != null;
                    String def = entry.getDefaultOrElse("");
                    json.addProperty("type", multiline ? "large-textbox" : "small-textbox");
                    json.addProperty("current", ParsingUtils.getString(entry.field(), def));
                    json.addProperty("default", def);
                }
            }
            json.addProperty("id", id);
            json.addProperty("title", GetConfigPath.getTitle(entry, id));
            json.addProperty("description", GetConfigPath.getDescription(entry));
            array.add((JsonElement)json);
        });
        return array;
    }

    private static <T extends Number> void createNumber(JsonObject json, ResourcefulConfigEntry entry, NumberRange range, BiFunction<Field, T, T> getter) {
        Number def = entry.getDefaultOrElse(WebServerUtils.ZERO);
        Number current = (Number)getter.apply(entry.field(), (Field)((Object)def));
        json.addProperty("type", range != null ? "range" : "number");
        json.addProperty("decimals", Boolean.valueOf(def instanceof Float || def instanceof Double));
        json.addProperty("current", current);
        json.addProperty("default", def);
        if (range != null) {
            json.addProperty("min", range.min());
            json.addProperty("max", range.max());
            json.addProperty("step", (Number)1);
        }
    }

    private static Enum<?>[] getEnumConstants(Class<?> clazz) {
        return (Enum[])clazz.getEnumConstants();
    }

    private static String getTitle(ResourcefulConfigEntry entry, String def) {
        ConfigEntry configEntry = entry.getAnnotation(ConfigEntry.class);
        if (configEntry != null) {
            return class_1074.method_4662((String)configEntry.translation(), (Object[])new Object[0]);
        }
        return def;
    }

    private static String getTitle(String input, ResourcefulConfig config) {
        return input.isBlank() ? config.getDisplayName().getString() : input;
    }

    private static String getDescription(ResourcefulConfigEntry entry) {
        Comment comment = entry.getAnnotation(Comment.class);
        if (comment != null) {
            return comment.value();
        }
        return "";
    }

    private record NumberRange(Number min, Number max) {
    }
}

