/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.common.config.impl;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefulconfig.common.annotations.Category;
import com.teamresourceful.resourcefulconfig.common.annotations.Config;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.annotations.InlineCategory;
import com.teamresourceful.resourcefulconfig.common.config.ParsingUtils;
import com.teamresourceful.resourcefulconfig.common.config.ResourcefulConfigButton;
import com.teamresourceful.resourcefulconfig.common.config.impl.ResourcefulButtonEntryImpl;
import com.teamresourceful.resourcefulconfig.common.config.impl.ResourcefulConfigEntryImpl;
import com.teamresourceful.resourcefulconfig.common.config.impl.ResourcefulConfigImpl;
import com.teamresourceful.resourcefulconfig.web.info.ResourcefulWebConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class ConfigParser {
    public static ResourcefulConfigImpl parseConfig(Class<?> config) throws Exception {
        Config data = config.getAnnotation(Config.class);
        if (data == null) {
            throw new Exception("Config class " + config.getName() + " is missing @Config annotation!");
        }
        return ConfigParser.createConfig(ConfigParser.parseData(config, Config.class, "resourcefulconfig.config"), data.value());
    }

    private static ResourcefulConfigImpl createConfig(TempConfig config, @Nullable String file) {
        LinkedHashMap<String, ResourcefulConfigImpl> subConfigs = new LinkedHashMap<String, ResourcefulConfigImpl>();
        ArrayList sortedConfigs = new ArrayList();
        config.configs.forEach((key, value) -> sortedConfigs.add(Pair.of((Object)((Integer)value.getFirst()), (Object)Pair.of((Object)key, (Object)((TempConfig)value.getSecond())))));
        sortedConfigs.stream().sorted(Comparator.comparingInt(Pair::getFirst)).map(Pair::getSecond).forEach(pair -> subConfigs.put((String)pair.getFirst(), ConfigParser.createConfig((TempConfig)pair.getSecond(), null)));
        return new ResourcefulConfigImpl(config.web(), new LinkedHashMap<String, ResourcefulConfigEntryImpl>(config.entries()), new ArrayList<ResourcefulConfigButton>(config.buttons()), subConfigs, file, config.translation());
    }

    private static TempConfig parseData(Class<?> config, Class<? extends Annotation> annotation, String translation) {
        Annotation data;
        ParsingUtils.assertValidClass(config, annotation);
        TempConfig builtConfig = new TempConfig(config, translation);
        for (Field field : config.getDeclaredFields()) {
            InlineCategory inlineCategory = field.getAnnotation(InlineCategory.class);
            if (inlineCategory != null) {
                Category data2 = field.getType().getAnnotation(Category.class);
                if (data2 == null) continue;
                builtConfig.configs.put(data2.id(), (Pair<Integer, TempConfig>)Pair.of((Object)data2.sortOrder(), (Object)ConfigParser.parseData(field.getType(), Category.class, data2.translation())));
                continue;
            }
            ConfigEntry data2 = ParsingUtils.assertEntry(field);
            if (data2 == null) continue;
            builtConfig.entries.put(data2.id(), ResourcefulConfigEntryImpl.create(data2, field));
        }
        for (AccessibleObject accessibleObject : config.getDeclaredMethods()) {
            data = ParsingUtils.assertButton((Method)accessibleObject);
            if (data == null) continue;
            String after = builtConfig.entries.containsKey(data.after()) ? data.after() : "";
            builtConfig.buttons.add(new ResourcefulButtonEntryImpl(after, (Method)accessibleObject));
        }
        for (AnnotatedElement annotatedElement : config.getDeclaredClasses()) {
            data = ((Class)annotatedElement).getAnnotation(Category.class);
            if (data == null) continue;
            builtConfig.configs.put(data.id(), (Pair<Integer, TempConfig>)Pair.of((Object)data.sortOrder(), (Object)ConfigParser.parseData(annotatedElement, Category.class, data.translation())));
        }
        return builtConfig;
    }

    private record TempConfig(ResourcefulWebConfig web, Map<String, ResourcefulConfigEntryImpl> entries, List<ResourcefulButtonEntryImpl> buttons, Map<String, Pair<Integer, TempConfig>> configs, String translation) {
        private TempConfig(Class<?> config, String translation) {
            this(ResourcefulWebConfig.of(config), new LinkedHashMap<String, ResourcefulConfigEntryImpl>(), new ArrayList<ResourcefulButtonEntryImpl>(), new LinkedHashMap<String, Pair<Integer, TempConfig>>(), translation);
        }
    }
}

