/*
 * Decompiled with CFR 0.152.
 */
package toni.doesittick;

import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_7923;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import toni.chunkactivitytracker.ChunkActivityTracker;
import toni.doesittick.api.Tickable;
import toni.doesittick.integration.FTBChunkClaimProvider;
import toni.doesittick.integration.IChunkClaimProvider;
import toni.doesittick.integration.OPACChunkClaimProvider;

public class DoesItTick
implements ModInitializer {
    public static final String MOD_ID = "does_it_tick";
    private static final boolean IS_FTB_CHUNKS_PRESENT = FabricLoader.getInstance().isModLoaded("ftbchunks");
    private static final boolean IS_OPAC_PRESENT = FabricLoader.getInstance().isModLoaded("openpartiesandclaims");
    @Nullable
    public static final IChunkClaimProvider FTB_CLAIM_PROVIDER = IS_FTB_CHUNKS_PRESENT ? new FTBChunkClaimProvider() : null;
    @Nullable
    public static final IChunkClaimProvider OPAC_CLAIM_PROVIDER = IS_OPAC_PRESENT ? new OPACChunkClaimProvider() : null;
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final ForgeConfigSpec.IntValue LIVING_HORIZONTAL_TICK_DIST;
    public static final ForgeConfigSpec.IntValue LIVING_VERTICAL_TICK_DIST;
    public static final ForgeConfigSpec.BooleanValue DISABLE_ON_CLIENT;
    public static final ForgeConfigSpec.BooleanValue DISABLE_IN_ACTIVE_CHUNKS;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ITEM_MOVEMENT;
    public static final ForgeConfigSpec.BooleanValue IGNORE_DEAD_ENTITIES;
    public static final ForgeConfigSpec.BooleanValue IGNORE_HOSTILE_ENTITIES;
    public static final ForgeConfigSpec.BooleanValue IGNORE_PASSIVE_ENTITIES;
    public static final ForgeConfigSpec.BooleanValue TICKING_RAIDER_ENTITIES_IN_RAID;
    public static final ForgeConfigSpec.BooleanValue OPTIMIZE_ENTITIES_TICKING;
    public static final ForgeConfigSpec.BooleanValue SEND_MESSAGE;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITIES_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ITEMS_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITIES_MOD_ID_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> RAID_ENTITIES_WHITELIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> RAID_ENTITIES_MOD_ID_LIST;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> DIMENSION_WHITELIST;
    private static final Supplier<Set<class_1792>> ITEMS;
    private static final Supplier<Boolean> ALL_DIMS_ALLOWED;
    private static final Supplier<Integer> MAX_HEIGHT;
    private static final Supplier<Integer> MAX_DIST_SQUARED;

    public static class_2960 resource(String path) {
        return new class_2960(path);
    }

    public DoesItTick() {
        ForgeConfigRegistry.INSTANCE.register(MOD_ID, ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG);
    }

    public void onInitialize() {
    }

    public static boolean isTickable(@NotNull class_1297 entity) {
        if (entity instanceof class_1657) {
            return true;
        }
        if (!((Boolean)OPTIMIZE_ENTITIES_TICKING.get()).booleanValue()) {
            return true;
        }
        class_1937 level = entity.method_37908();
        if (!DoesItTick.isOptimizableDim(level)) {
            return true;
        }
        if (((Boolean)DISABLE_ON_CLIENT.get()).booleanValue() && level.field_9236) {
            return true;
        }
        if (entity instanceof class_1540) {
            return true;
        }
        if (((Boolean)DISABLE_IN_ACTIVE_CHUNKS.get()).booleanValue()) {
            class_1923 chunkPos = entity.method_31476();
            for (int x = -2; x < 2; ++x) {
                for (int z = -2; z < 2; ++z) {
                    long secondsInChunk = ChunkActivityTracker.getTotalTimeInChunk((class_1937)level, (class_1923)new class_1923(chunkPos.field_9181 + x, chunkPos.field_9180 + z));
                    if (secondsInChunk <= 15L) continue;
                    return true;
                }
            }
        }
        if (entity instanceof class_1309) {
            boolean isMonster;
            if (!((Boolean)IGNORE_DEAD_ENTITIES.get()).booleanValue() && ((class_1309)entity).method_29504()) {
                return true;
            }
            boolean bl = isMonster = entity instanceof class_1588 || entity instanceof class_1621;
            if (((Boolean)IGNORE_HOSTILE_ENTITIES.get()).booleanValue() && isMonster) {
                return true;
            }
            if (((Boolean)IGNORE_PASSIVE_ENTITIES.get()).booleanValue() && !isMonster) {
                return true;
            }
        }
        if (DoesItTick.isOptimizableItemEntity(entity)) {
            return ThreadLocalRandom.current().nextBoolean() || ThreadLocalRandom.current().nextBoolean();
        }
        class_2338 entityPos = entity.method_24515();
        if (DoesItTick.isInClaimedChunk(level, entityPos)) {
            return true;
        }
        class_1299 entityType = entity.method_5864();
        if (((Tickable.EntityType)entityType).doespotatotick$shouldAlwaysTick().booleanValue()) {
            return true;
        }
        if (DoesItTick.shouldTickInRaid(level, entityPos, entityType, entity)) {
            return true;
        }
        return DoesItTick.isNearPlayer(level, entityPos);
    }

    private static boolean shouldTickInRaid(class_1937 level, class_2338 blockPos, class_1299<?> entityType, class_1297 entity) {
        if (level instanceof class_3218 && ((class_3218)level).method_19503(blockPos)) {
            if (entity instanceof class_3763) {
                return (Boolean)TICKING_RAIDER_ENTITIES_IN_RAID.get();
            }
            return ((Tickable.EntityType)entityType).doespotatotick$shouldAlwaysTickInRaid();
        }
        return false;
    }

    private static boolean isOptimizableItemEntity(class_1297 entity) {
        if (!((Boolean)OPTIMIZE_ITEM_MOVEMENT.get()).booleanValue()) {
            return false;
        }
        if (entity instanceof class_1542) {
            return !((Set)ITEMS.get()).contains(((class_1542)entity).method_6983().method_7909());
        }
        return false;
    }

    private static boolean isInClaimedChunk(class_1937 level, class_2338 pos) {
        boolean flag = false;
        if (FTB_CLAIM_PROVIDER != null) {
            flag = FTB_CLAIM_PROVIDER.isInClaimedChunk(level, pos);
        }
        if (OPAC_CLAIM_PROVIDER != null) {
            flag = flag || OPAC_CLAIM_PROVIDER.isInClaimedChunk(level, pos);
        }
        return flag;
    }

    private static boolean isOptimizableDim(class_1937 level) {
        if (((Boolean)ALL_DIMS_ALLOWED.get()).booleanValue()) {
            return true;
        }
        return ((Tickable.Level)level).doespotatotick$isInOptimizableDimension();
    }

    private static boolean isNearPlayer(@NotNull class_1937 level, @NotNull class_2338 pos) {
        int posX = pos.method_10263();
        int posY = pos.method_10264();
        int posZ = pos.method_10260();
        int maxHeight = (Integer)MAX_HEIGHT.get();
        int maxDistSquared = (Integer)MAX_DIST_SQUARED.get();
        for (class_1657 player : level.method_18456()) {
            double z;
            double x;
            if (!(Math.abs(player.method_23318() - (double)posY) < (double)maxHeight) || !((x = player.method_23317() - (double)posX) * x + (z = player.method_23321() - (double)posZ) * z < (double)maxDistSquared)) continue;
            return true;
        }
        return false;
    }

    static {
        ObjectArrayList itemList = ObjectArrayList.wrap((Object[])new String[]{"minecraft:cobblestone"});
        ObjectArrayList entityModIdList = ObjectArrayList.wrap((Object[])new String[]{"create", "witherstormmod"});
        ObjectArrayList entityWhiteList = ObjectArrayList.wrap((Object[])new String[]{"minecraft:ender_dragon", "minecraft:ghast", "minecraft:wither", "minecraft:player", "alexsmobs:void_worm", "alexsmobs:void_worm_part", "alexsmobs:spectre", "twilightforest:naga", "twilightforest:lich", "twilightforest:yeti", "twilightforest:snow_queen", "twilightforest:minoshroom", "twilightforest:hydra", "twilightforest:knight_phantom", "twilightforest:ur_ghast", "atum:pharaoh", "mowziesmobs:barako", "mowziesmobs:ferrous_wroughtnaut", "mowziesmobs:frostmaw", "mowziesmobs:naga", "aoa3:skeletron", "aoa3:smash", "aoa3:baroness", "aoa3:clunkhead", "aoa3:corallus", "aoa3:cotton_candor", "aoa3:craexxeus", "aoa3:xxeus", "aoa3:creep", "aoa3:crystocore", "aoa3:dracyon", "aoa3:graw", "aoa3:gyro", "aoa3:hive_king", "aoa3:kajaros", "aoa3:miskel", "aoa3:harkos", "aoa3:raxxan", "aoa3:okazor", "aoa3:king_bambambam", "aoa3:king_shroomus", "aoa3:kror", "aoa3:mechbot", "aoa3:nethengeic_wither", "aoa3:red_guardian", "aoa3:blue_guardian", "aoa3:green_guardian", "aoa3:yellow_guardian", "aoa3:rock_rider", "aoa3:shadowlord", "aoa3:tyrosaur", "aoa3:vinecorne", "aoa3:visualent", "aoa3:voxxulon", "aoa3:bane", "aoa3:elusive", "gaiadimension:malachite_drone", "gaiadimension:malachite_guard", "blue_skies:alchemist", "blue_skies:arachnarch", "blue_skies:starlit_crusher", "blue_skies:summoner", "stalwart_dungeons:awful_ghast", "stalwart_dungeons:nether_keeper", "stalwart_dungeons:shelterer_without_armor", "dungeonsmod:extrapart", "dungeonsmod:king", "dungeonsmod:deserted", "dungeonsmod:crawler", "dungeonsmod:ironslime", "dungeonsmod:kraken", "dungeonsmod:voidmaster", "dungeonsmod:lordskeleton", "dungeonsmod:winterhunter", "dungeonsmod:sun", "forestcraft:beequeen", "forestcraft:iguana_king", "forestcraft:cosmic_fiend", "forestcraft:nether_scourge", "cataclysm:ender_golem", "cataclysm:ender_guardian", "cataclysm:ignis", "cataclysm:ignited_revenant", "cataclysm:netherite_monstrosity", "iceandfire:fire_dragon", "iceandfire:ice_dragon", "iceandfire:lightning_dragon", "iceandfire:dragon_multipart"});
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Does It Tick?").push("Living Entities Tick Settings");
        OPTIMIZE_ENTITIES_TICKING = builder.comment("If you disable this, entities will not stop ticking when they'are far from you, this mod may be useless for you too").define("OptimizeEntitiesTicking", true);
        LIVING_HORIZONTAL_TICK_DIST = builder.defineInRange("LivingEntitiesMaxHorizontalTickDistance", 64, 1, Integer.MAX_VALUE);
        LIVING_VERTICAL_TICK_DIST = builder.defineInRange("LivingEntitiesMaxVerticalTickDistance", 32, 1, Integer.MAX_VALUE);
        ENTITIES_WHITELIST = builder.comment("If you don't want an entity to be affected by the optimization, you can write its registry name down here.").defineList("EntitiesWhitelist", (List)entityWhiteList, (Predicate)Predicates.alwaysTrue());
        ENTITIES_MOD_ID_WHITELIST = builder.comment("If you don't want entities of a mod to be affected by the optimization, you can write its modid down here").defineList("EntitiesModIDWhiteList", (List)entityModIdList, (Predicate)Predicates.alwaysTrue());
        TICKING_RAIDER_ENTITIES_IN_RAID = builder.comment("With this turned on, all the raider won't stop ticking in raid chunks even if they are far from players (well this is not perfect as the raiders may walk out of the raid range)").define("TickRaidersInRaid", true);
        RAID_ENTITIES_WHITELIST = builder.comment("Similar with entity whitelist, but only take effect in raid.").defineList("RaidEntitiesWhiteList", (List)ObjectArrayList.wrap((Object[])new String[]{"minecraft:witch", "minecraft:vex"}), (Predicate)Predicates.alwaysTrue());
        RAID_ENTITIES_MOD_ID_LIST = builder.comment("Similar with entity modID whitelist, but only take effect in raid").defineList("RaidEntitiesModIDWhiteList", (List)new ObjectArrayList(), (Predicate)Predicates.alwaysTrue());
        DIMENSION_WHITELIST = builder.comment(new String[]{"Leave this empty for applying to all the dimensions", "Entities in these dimensions will be affected by the optimization"}).defineList("DimensionWhitelist", (List)new ObjectArrayList(), (Predicate)Predicates.alwaysTrue());
        IGNORE_DEAD_ENTITIES = builder.comment("If this is enabled, tickable check will run a lot faster, but the entity will not die out of range").define("IgnoreDeadEntities", false);
        IGNORE_HOSTILE_ENTITIES = builder.comment("If this is enabled, this mod will only work on passive entities.").define("IgnoreHostileEntities", false);
        IGNORE_PASSIVE_ENTITIES = builder.comment("If this is enabled, this mod will only work on hostile entities.").define("IgnorePassiveEntities", false);
        builder.pop();
        builder.push("Item Entities Tick Settings");
        OPTIMIZE_ITEM_MOVEMENT = builder.comment("Slow down item entities' ticking speed by 1/4").define("OptimizeItemMovement", false);
        ITEMS_WHITELIST = builder.comment(new String[]{"If you don't want to let a specific item entity in the world to be effected by the optimization, you can write its registry name down here.", "Require 'OptimizeItemMovement' to be true"}).defineList("ItemWhiteList", (List)itemList, (Predicate)Predicates.alwaysTrue());
        builder.pop();
        builder.push("Misc");
        DISABLE_ON_CLIENT = builder.define("DisableOnClient", true);
        SEND_MESSAGE = builder.define("SendWarningMessageWhenPlayerLogIn", true);
        DISABLE_IN_ACTIVE_CHUNKS = builder.comment("If you disable this, entities near player bases may be affected.").define("DisableInActiveChunks", true);
        builder.pop();
        COMMON_CONFIG = builder.build();
        ITEMS = Suppliers.memoize(() -> ((List)ITEMS_WHITELIST.get()).stream().map(s -> (class_1792)class_7923.field_41178.method_10223(DoesItTick.resource(s))).collect(Collectors.toSet()));
        ALL_DIMS_ALLOWED = Suppliers.memoize(() -> ((List)DIMENSION_WHITELIST.get()).isEmpty());
        MAX_HEIGHT = Suppliers.memoize(() -> ((ForgeConfigSpec.IntValue)LIVING_VERTICAL_TICK_DIST).get());
        MAX_DIST_SQUARED = Suppliers.memoize(() -> (Integer)LIVING_HORIZONTAL_TICK_DIST.get() * (Integer)LIVING_HORIZONTAL_TICK_DIST.get());
    }
}

