/*
 * Decompiled with CFR 0.152.
 */
package toni.chunkactivitytracker;

import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import java.nio.file.Path;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2818;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.config.IConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import toni.chunkactivitytracker.data.ChunkActivityInfo;
import toni.chunkactivitytracker.data.ChunkActivityMap;
import toni.chunkactivitytracker.foundation.config.AllConfigs;

public class ChunkActivityTracker
implements ModInitializer,
ClientModInitializer {
    public static final String MODNAME = "Chunk Activity Tracker";
    public static final String ID = "chunkactivitytracker";
    public static final Logger LOGGER = LogManager.getLogger((String)"Chunk Activity Tracker");
    private static MinecraftServer currentServer;
    private static long lastTime;
    private static final float NANOSECONDS_PER_TICK = 5.0E7f;

    public ChunkActivityTracker() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            currentServer = server;
        });
    }

    public static long getSecondsInCurrentChunk(class_1657 player) {
        class_1937 level = player.method_37908();
        if (level == null) {
            return 0L;
        }
        ChunkActivityInfo chunkInfo = ChunkActivityMap.getChunkInfo((class_5321<class_1937>)level.method_27983(), player.method_31476());
        if (chunkInfo == null) {
            return 0L;
        }
        return chunkInfo.getPlayerTime(player.method_5667());
    }

    public static long getTotalTimeInChunk(class_1937 level, class_1923 chunkPos) {
        if (level == null) {
            return 0L;
        }
        ChunkActivityInfo chunkInfo = ChunkActivityMap.getChunkInfo((class_5321<class_1937>)level.method_27983(), chunkPos);
        if (chunkInfo == null) {
            return 0L;
        }
        long sum = 0L;
        for (Long kvp : chunkInfo.getPlayerTimeMap().values()) {
            sum += kvp.longValue();
        }
        return sum;
    }

    public static Path getWorldPath(class_5218 resource) {
        if (currentServer == null) {
            System.out.println("No MinecraftServer instance available.");
            return null;
        }
        return currentServer.method_27050(resource);
    }

    public void onInitialize() {
        AllConfigs.register((type, spec) -> ForgeConfigRegistry.INSTANCE.register(ID, type, (IConfigSpec)spec));
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            currentServer = null;
            ChunkActivityMap.clear();
        });
        UseBlockCallback.EVENT.register((player, block, hand, hit) -> {
            if (player.method_37908().field_9236) {
                return class_1269.field_5811;
            }
            ChunkActivityInfo chunkInfo = ChunkActivityMap.getChunkInfo((class_5321<class_1937>)player.method_37908().method_27983(), player.method_31476());
            if (chunkInfo != null) {
                chunkInfo.incrementBlocksPlaced(player.method_5667());
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.START_SERVER_TICK.register(event -> {
            long currentTime = System.nanoTime();
            float delta = (float)(currentTime - lastTime) / 5.0E7f;
            if (delta < 20.0f) {
                return;
            }
            lastTime = currentTime;
            event.method_3760().method_14571().forEach(player -> {
                class_1937 level = player.method_37908();
                if (level == null) {
                    return;
                }
                ChunkActivityInfo chunkInfo = ChunkActivityMap.getChunkInfo((class_5321<class_1937>)level.method_27983(), player.method_31476());
                if (chunkInfo == null) {
                    if (((Boolean)AllConfigs.server().storeHeightmaps.get()).booleanValue()) {
                        class_2818 chunk = level.method_8500(player.method_24515());
                        if (chunk == null) {
                            return;
                        }
                        chunkInfo = ChunkActivityMap.createChunkInfo((class_5321<class_1937>)level.method_27983(), chunk);
                    } else {
                        chunkInfo = ChunkActivityMap.createChunkInfo((class_5321<class_1937>)level.method_27983(), player.method_31476());
                    }
                }
                chunkInfo.updatePlayerTime(player.method_5667());
            });
        });
    }

    public void onInitializeClient() {
    }

    static {
        lastTime = System.nanoTime();
    }
}

