/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.instancing;

import dev.djefrey.colorwheel.engine.ClrwlInstanceVisual;
import dev.djefrey.colorwheel.engine.ClrwlMeshPool;
import dev.djefrey.colorwheel.instancing.ClrwlInstancedInstancer;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.backend.engine.GroupKey;
import dev.engine_room.flywheel.backend.gl.TextureBuffer;

public class ClrwlInstancedDraw {
    public final GroupKey<?> groupKey;
    private final ClrwlInstancedInstancer<?> instancer;
    private final ClrwlMeshPool.PooledMesh mesh;
    private final Material material;
    private final int bias;
    private final int indexOfMeshInModel;
    private boolean deleted;

    public ClrwlInstancedDraw(ClrwlInstancedInstancer<?> instancer, ClrwlMeshPool.PooledMesh mesh, GroupKey<?> groupKey, Material material, int bias, int indexOfMeshInModel) {
        this.instancer = instancer;
        this.mesh = mesh;
        this.groupKey = groupKey;
        this.material = material;
        this.bias = bias;
        this.indexOfMeshInModel = indexOfMeshInModel;
        mesh.acquire();
    }

    public ClrwlInstanceVisual visual() {
        return this.instancer.visual;
    }

    public int bias() {
        return this.bias;
    }

    public int indexOfMeshInModel() {
        return this.indexOfMeshInModel;
    }

    public Material material() {
        return this.material;
    }

    public boolean deleted() {
        return this.deleted;
    }

    public ClrwlMeshPool.PooledMesh mesh() {
        return this.mesh;
    }

    public void render(TextureBuffer buffer) {
        if (this.mesh.isInvalid()) {
            return;
        }
        this.instancer.bind(buffer);
        this.mesh.draw(this.instancer.instanceCount());
    }

    public void renderOne(TextureBuffer buffer) {
        if (this.mesh.isInvalid()) {
            return;
        }
        this.instancer.bind(buffer);
        this.mesh.draw(1);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        this.mesh.release();
        this.deleted = true;
    }
}

