/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import dev.djefrey.colorwheel.ClrwlConfig;
import dev.djefrey.colorwheel.Colorwheel;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ClrwlConfigFabric
implements ClrwlConfig {
    public static final Path PATH = FabricLoader.getInstance().getConfigDir().resolve("colorwheel.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final ClrwlConfigFabric INSTANCE = new ClrwlConfigFabric(PATH.toFile());
    private final File file;
    private final String ALERT_INCOMPATIBLE_KEY = "alertIncompatiblePack";
    private final String ALERT_BROKEN_KEY = "alertBrokenPack";
    private final String FALLBACK_MODE_KEY = "enableFallbackMode";
    public boolean alertIncompatiblePack = true;
    public boolean alertBrokenPack = true;
    public boolean fallbackModeEnabled = false;

    public ClrwlConfigFabric(File file) {
        this.file = file;
        Colorwheel.CONFIG = this;
    }

    @Override
    public boolean shouldAlertIncompatiblePack() {
        return this.alertIncompatiblePack;
    }

    @Override
    public boolean shouldAlertBrokenPack() {
        return this.alertBrokenPack;
    }

    @Override
    public boolean isFallbackModeEnabled() {
        return this.fallbackModeEnabled;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                JsonElement json = JsonParser.parseReader((Reader)reader);
                if (json instanceof JsonObject) {
                    JsonObject jsonObj = (JsonObject)json;
                    this.alertIncompatiblePack = this.readBoolean(jsonObj, "alertIncompatiblePack", true);
                    this.alertBrokenPack = this.readBoolean(jsonObj, "alertBrokenPack", true);
                    this.fallbackModeEnabled = this.readBoolean(jsonObj, "enableFallbackMode", false);
                }
            }
            catch (Exception e) {
                Colorwheel.LOGGER.error("Config: could not read config file", (Throwable)e);
                this.alertIncompatiblePack = true;
                this.alertBrokenPack = true;
                this.fallbackModeEnabled = false;
            }
        }
        this.save();
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson(this.toJson(), (Appendable)writer);
        }
        catch (Exception e) {
            Colorwheel.LOGGER.warn("Config: could not save config to file '{}'", (Object)this.file.getAbsolutePath(), (Object)e);
        }
    }

    private boolean readBoolean(JsonObject json, String key, boolean deflt) {
        JsonPrimitive primitive;
        JsonElement jsonBool = json.get(key);
        if (jsonBool instanceof JsonPrimitive && (primitive = (JsonPrimitive)jsonBool).isBoolean()) {
            return primitive.getAsBoolean();
        }
        Colorwheel.LOGGER.error("Config: '{}' is not a boolean", (Object)key);
        return deflt;
    }

    private JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("alertIncompatiblePack", Boolean.valueOf(this.alertIncompatiblePack));
        json.addProperty("alertBrokenPack", Boolean.valueOf(this.alertBrokenPack));
        json.addProperty("enableFallbackMode", Boolean.valueOf(this.fallbackModeEnabled));
        return json;
    }
}

