/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine;

import com.google.common.collect.ImmutableList;
import dev.djefrey.colorwheel.accessors.BlendModeOverrideAccessor;
import dev.djefrey.colorwheel.accessors.IrisRenderingPipelineAccessor;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.accessors.ShaderPackAccessor;
import dev.djefrey.colorwheel.compile.oit.ClrwlOitPrograms;
import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.djefrey.colorwheel.engine.ClrwlOitFramebuffers;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramGroup;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.irisshaders.iris.gl.blending.BufferBlendInformation;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.ProgramDirectives;
import org.jetbrains.annotations.Nullable;

public class ClrwlProgramFramebuffers {
    private final Map<ClrwlProgramId, GlFramebuffer> framebuffers = new HashMap<ClrwlProgramId, GlFramebuffer>();
    @Nullable
    private ClrwlOitFramebuffers gbuffersOitFramebuffer;
    @Nullable
    private ClrwlOitFramebuffers shadowOitFramebuffer;
    private final Map<ClrwlProgramId, List<BufferBlendInformation>> bufferBlendOverrides = new HashMap<ClrwlProgramId, List<BufferBlendInformation>>();

    @Nullable
    public GlFramebuffer getFramebuffer(ClrwlProgramId program, IrisRenderingPipeline pipeline, ProgramSet programSet) {
        IrisRenderingPipelineAccessor pipelineAccessor = (IrisRenderingPipelineAccessor)pipeline;
        ProgramSetAccessor programSetAccessor = (ProgramSetAccessor)programSet;
        if (pipelineAccessor.colorwheel$consumeFramebufferChanged()) {
            for (Map.Entry<ClrwlProgramId, GlFramebuffer> entry : this.framebuffers.entrySet()) {
                if (entry.getKey().group() != ClrwlProgramGroup.GBUFFERS) continue;
                pipelineAccessor.colorwheel$destroyGbuffersFramebuffer(entry.getValue());
            }
            for (ClrwlProgramId key2 : ClrwlProgramId.gbuffers()) {
                this.framebuffers.remove((Object)key2);
            }
        }
        return this.framebuffers.computeIfAbsent(program, key -> {
            Optional<ProgramSource> maybeSrc = programSetAccessor.colorwheel$getClrwlProgramSource((ClrwlProgramId)((Object)key));
            if (maybeSrc.isEmpty()) {
                return null;
            }
            ProgramSource src = maybeSrc.get();
            switch (key.group()) {
                case GBUFFERS: {
                    return program.afterTranslucent() ? pipelineAccessor.colorwheel$createTranslucentGbuffersFramebuffer(src) : pipelineAccessor.colorwheel$createSolidGbuffersFramebuffer(src);
                }
                case SHADOW: {
                    return pipelineAccessor.colorwheel$createShadowFramebuffer(src);
                }
            }
            throw new RuntimeException("Unknown program group: " + key.group().groupName());
        });
    }

    @Nullable
    public ClrwlOitFramebuffers getOitFramebuffers(ClrwlProgramGroup programGroup, ClrwlOitPrograms oitPrograms, IrisRenderingPipeline pipeline, ClrwlShaderProperties properties, ProgramDirectives directives) {
        switch (programGroup) {
            case GBUFFERS: {
                if (this.gbuffersOitFramebuffer == null) {
                    this.gbuffersOitFramebuffer = new ClrwlOitFramebuffers(programGroup, oitPrograms, pipeline, properties, directives);
                }
                return this.gbuffersOitFramebuffer;
            }
            case SHADOW: {
                if (this.shadowOitFramebuffer == null) {
                    this.shadowOitFramebuffer = new ClrwlOitFramebuffers(programGroup, oitPrograms, pipeline, properties, directives);
                }
                return this.shadowOitFramebuffer;
            }
        }
        throw new RuntimeException("Unknown program group: " + programGroup);
    }

    public Optional<ClrwlBlendModeOverride> getBlendModeOverride(ClrwlProgramId programId, ShaderPack pack, ProgramSet programSet) {
        ProgramSetAccessor programSetAccessor = (ProgramSetAccessor)programSet;
        if (!programSetAccessor.colorwheel$isFallbackMode()) {
            ClrwlShaderProperties properties = ((ShaderPackAccessor)pack).colorwheel$getProperties();
            Optional<ClrwlProgramId> realProgramId = programSetAccessor.colorwheel$getRealClrwlProgram(programId);
            return realProgramId.flatMap(properties::getBlendModeOverride).or(programId::defaultBlendOverride);
        }
        Optional<ProgramSource> maybeSrc = programSetAccessor.colorwheel$getClrwlProgramSource(programId);
        return maybeSrc.flatMap(src -> src.getDirectives().getBlendModeOverride().map(bm -> ((BlendModeOverrideAccessor)bm).colorwheel$convert())).or(programId::defaultBlendOverride);
    }

    public List<BufferBlendInformation> getBufferBlendModeOverrides(ClrwlProgramId programId, ShaderPack pack, ProgramSet programSet) {
        ProgramSetAccessor programSetAccessor = (ProgramSetAccessor)programSet;
        if (!programSetAccessor.colorwheel$isFallbackMode()) {
            Optional<ClrwlProgramId> realProgram = programSetAccessor.colorwheel$getRealClrwlProgram(programId);
            if (realProgram.isEmpty()) {
                return Collections.emptyList();
            }
            return this.bufferBlendOverrides.computeIfAbsent(realProgram.get(), key -> {
                ClrwlShaderProperties properties = ((ShaderPackAccessor)pack).colorwheel$getProperties();
                Optional<ProgramSource> maybeSrc = programSetAccessor.colorwheel$getClrwlProgramSource((ClrwlProgramId)((Object)key));
                return maybeSrc.map(src -> this.computeBufferBlendOff((ProgramSource)src, properties.getBufferBlendModeOverrides((ClrwlProgramId)((Object)((Object)((Object)realProgram.get())))))).orElse(Collections.emptyList());
            });
        }
        return this.bufferBlendOverrides.computeIfAbsent(programId, key -> {
            Optional<ProgramSource> maybeSrc = programSetAccessor.colorwheel$getClrwlProgramSource(programId);
            return maybeSrc.map(src -> src.getDirectives().getBufferBlendOverrides()).orElse(Collections.emptyList());
        });
    }

    private List<BufferBlendInformation> computeBufferBlendOff(ProgramSource source, List<BufferBlendInformation> blendOverrides) {
        if (blendOverrides.isEmpty()) {
            return Collections.emptyList();
        }
        int[] drawBuffers = source.getDirectives().getDrawBuffers();
        ArrayList<BufferBlendInformation> list = new ArrayList<BufferBlendInformation>();
        for (int i = 0; i < drawBuffers.length; ++i) {
            int buf = drawBuffers[i];
            for (BufferBlendInformation entry : blendOverrides) {
                if (entry.index() != buf) continue;
                list.add(new BufferBlendInformation(i, entry.blendMode()));
            }
        }
        return ImmutableList.copyOf(list);
    }

    public void delete(IrisRenderingPipeline pipeline) {
        IrisRenderingPipelineAccessor pipelineAccessor = (IrisRenderingPipelineAccessor)pipeline;
        for (Map.Entry<ClrwlProgramId, GlFramebuffer> entry : this.framebuffers.entrySet()) {
            switch (entry.getKey().group()) {
                case GBUFFERS: {
                    pipelineAccessor.colorwheel$destroyGbuffersFramebuffer(entry.getValue());
                    break;
                }
                case SHADOW: {
                    pipelineAccessor.colorwheel$destroyShadowFramebuffer(entry.getValue());
                }
            }
        }
        if (this.gbuffersOitFramebuffer != null) {
            this.gbuffersOitFramebuffer.delete();
            this.gbuffersOitFramebuffer = null;
        }
        if (this.shadowOitFramebuffer != null) {
            this.shadowOitFramebuffer.delete();
            this.shadowOitFramebuffer = null;
        }
        this.framebuffers.clear();
        this.bufferBlendOverrides.clear();
    }
}

