/*
 * Decompiled with CFR 0.152.
 */
package dev.corgitaco.featurerecycler;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7510;
import org.slf4j.Logger;

public class FeatureRecycler {
    public static final String MOD_ID = "featurerecycler";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
    }

    public static <T extends class_6880<class_1959>> List<class_7510.class_6827> recycle(List<T> biomes, Function<T, List<class_6885<class_6796>>> toFeatueSetFunction) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("Starting feature recycler...");
        int crashesPrevented = 0;
        ArrayList<Reference2ObjectLinkedOpenHashMap> biomeTracker = new ArrayList<Reference2ObjectLinkedOpenHashMap>();
        class_2893.class_2895[] values = class_2893.class_2895.values();
        for (int i = 0; i < values.length; ++i) {
            biomeTracker.add(new Reference2ObjectLinkedOpenHashMap());
        }
        for (class_6880 class_68802 : biomes) {
            List<class_6885<class_6796>> features = toFeatueSetFunction.apply(class_68802);
            for (int i = 0; i < features.size(); ++i) {
                class_6885<class_6796> feature = features.get(i);
                ((Map)biomeTracker.get(i)).put(class_68802, new ArrayList(feature.method_40239().toList()));
            }
        }
        for (Map map : biomeTracker) {
            for (int biomeIdx = 0; biomeIdx < biomes.size(); ++biomeIdx) {
                class_6880 biome = (class_6880)biomes.get(biomeIdx);
                List currentList = (List)map.get(biome);
                if (currentList == null) continue;
                for (int currentHolderIndex = 0; currentHolderIndex < currentList.size(); ++currentHolderIndex) {
                    class_6880 currentHolder = (class_6880)currentList.get(currentHolderIndex);
                    for (int nextHolderIndex = currentHolderIndex + 1; nextHolderIndex < currentList.size(); ++nextHolderIndex) {
                        class_6880 nextHolder = (class_6880)currentList.get(nextHolderIndex);
                        int currentFeatureIDX = -1;
                        int nextFeatureIDX = -1;
                        class_6880 biomeRuleSetter = null;
                        for (int previousBiomeIdx = 0; previousBiomeIdx < biomeIdx - 1; ++previousBiomeIdx) {
                            class_6880 previousBiome = (class_6880)biomes.get(previousBiomeIdx);
                            List previousBiomeStageData = (List)map.get(previousBiome);
                            if (previousBiomeStageData == null) continue;
                            if (currentFeatureIDX >= 0 && nextFeatureIDX >= 0) break;
                            int previousBiomeCurrentFeatureIDX = -1;
                            int previousBiomeNextFeatureIDX = -1;
                            for (int previousBiomeHolderIdx = 0; previousBiomeHolderIdx < previousBiomeStageData.size(); ++previousBiomeHolderIdx) {
                                class_6880 previousBiomePlacedFeatureHolder = (class_6880)previousBiomeStageData.get(previousBiomeHolderIdx);
                                if (previousBiomePlacedFeatureHolder == currentHolder) {
                                    previousBiomeCurrentFeatureIDX = previousBiomeHolderIdx;
                                }
                                if (previousBiomePlacedFeatureHolder == nextHolder) {
                                    previousBiomeNextFeatureIDX = previousBiomeHolderIdx;
                                }
                                if (previousBiomeCurrentFeatureIDX >= 0 && previousBiomeNextFeatureIDX >= 0) break;
                            }
                            currentFeatureIDX = previousBiomeCurrentFeatureIDX;
                            nextFeatureIDX = previousBiomeNextFeatureIDX;
                            biomeRuleSetter = previousBiome;
                        }
                        if (currentFeatureIDX < 0 || nextFeatureIDX < 0 || currentFeatureIDX <= nextFeatureIDX) continue;
                        class_2960 currentBiomeLocation = biome.method_40230().isEmpty() ? null : ((class_5321)biome.method_40230().orElseThrow()).method_29177();
                        String currentBiomeName = currentBiomeLocation == null ? "???" : currentBiomeLocation.toString();
                        String currentFeatureName = currentHolder.method_40230().isEmpty() ? "???" : ((class_5321)currentHolder.method_40230().orElseThrow()).method_29177().toString();
                        String nextFeatureName = nextHolder.method_40230().isEmpty() ? "???" : ((class_5321)nextHolder.method_40230().orElseThrow()).method_29177().toString();
                        class_2960 ruleSetterLocation = biomeRuleSetter.method_40230().isEmpty() ? null : ((class_5321)biomeRuleSetter.method_40230().orElseThrow()).method_29177();
                        String biomeRuleSetterName = ruleSetterLocation == null ? "???" : ruleSetterLocation.toString();
                        LOGGER.warn("Moved placed feature \"%s\" from index %d to index %d for biome \"%s\". Placed Feature index rules set by biome \"%s\".".formatted(currentFeatureName, currentHolderIndex, nextHolderIndex, currentBiomeName, biomeRuleSetterName));
                        LOGGER.warn("Moved placed feature \"%s\" from index %d to index %d for biome \"%s\". Placed Feature index rules set by biome \"%s\".".formatted(nextFeatureName, nextHolderIndex, currentHolderIndex, currentBiomeName, biomeRuleSetterName));
                        LOGGER.warn("Just prevented a crash between %s and %s! Please report the issues to their respective issue trackers.".formatted(currentBiomeLocation == null ? "???" : currentBiomeLocation.method_12836(), ruleSetterLocation == null ? "???" : ruleSetterLocation.method_12836()));
                        ++crashesPrevented;
                        currentList.set(currentHolderIndex, nextHolder);
                        currentList.set(nextHolderIndex, currentHolder);
                    }
                }
            }
        }
        ArrayList<class_7510.class_6827> steps = new ArrayList<class_7510.class_6827>();
        biomeTracker.forEach(stepData -> {
            ArrayList<class_6796> organizedFeatures = new ArrayList<class_6796>();
            Object2IntOpenHashMap indexGetter = new Object2IntOpenHashMap();
            int idx = 0;
            for (List value : stepData.values()) {
                for (class_6880 holder : value) {
                    organizedFeatures.add((class_6796)holder.comp_349());
                    indexGetter.put((Object)((class_6796)holder.comp_349()), idx);
                    ++idx;
                }
            }
            steps.add(new class_7510.class_6827(organizedFeatures, arg_0 -> ((Object2IntOpenHashMap)indexGetter).getInt(arg_0)));
        });
        LOGGER.info("Finished recycling features. Took %dms".formatted(System.currentTimeMillis() - startTime));
        if (crashesPrevented > 0) {
            LOGGER.info("Feature Recycler just prevented %d crashes!".formatted(crashesPrevented));
        }
        return steps;
    }
}

