/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow.compat.sereneseasons;

import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonHooks;
import snownee.snow.SnowCommonConfig;

public class SereneSeasonsCompat {
    public static boolean shouldMelt(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        if (!SereneSeasonsCompat.snowAndIceMeltInWarmBiomes((class_5321<class_1937>)level.method_27983(), biome)) {
            return false;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((class_1937)level).getSubSeason();
        SeasonsConfig.SeasonProperties meltInfo = ModConfig.seasons.getSeasonProperties(subSeason);
        if (meltInfo == null) {
            return false;
        }
        float meltChance = meltInfo.meltChance() * (float)meltInfo.meltRolls() * 0.01f;
        return meltChance > 0.0f && level.field_9229.method_43057() < meltChance && !SereneSeasonsCompat.coldEnoughToSnow(level, pos, biome);
    }

    public static boolean snowAndIceMeltInWarmBiomes(class_5321<class_1937> dimension, class_6880<class_1959> biome) {
        if (!ModConfig.seasons.generateSnowAndIce) {
            return false;
        }
        if (biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return false;
        }
        return ModConfig.seasons.isDimensionWhitelisted(dimension);
    }

    public static boolean coldEnoughToSnow(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        if (ModConfig.seasons.generateSnowAndIce) {
            return SeasonHooks.getBiomeTemperature((class_1937)level, biome, (class_2338)pos) < 0.15f;
        }
        return ((class_1959)biome.comp_349()).method_33599(pos);
    }

    public static boolean isWinter(class_1937 level, class_2338 pos, class_6880<class_1959> biome) {
        if (!SereneSeasonsCompat.isSeasonal((class_5321<class_1937>)level.method_27983(), biome)) {
            return false;
        }
        return SeasonHelper.getSeasonState((class_1937)level).getSeason() == Season.WINTER;
    }

    public static boolean isSeasonal(class_5321<class_1937> dimension, class_6880<class_1959> biome) {
        return !biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES) && !biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES) && ModConfig.seasons.isDimensionWhitelisted(dimension);
    }

    public static void weatherTick(class_3218 level, Runnable action) {
        if (!ModConfig.seasons.isDimensionWhitelisted(level.method_27983())) {
            return;
        }
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((class_1937)level).getSubSeason();
        if (subSeason.getSeason() == Season.WINTER) {
            if (level.field_9229.method_43048(SnowCommonConfig.weatherTickSlowness) == 0) {
                action.run();
            }
            return;
        }
        SeasonsConfig.SeasonProperties meltInfo = ModConfig.seasons.getSeasonProperties(subSeason);
        if (meltInfo == null) {
            action.run();
            return;
        }
        int meltRolls = meltInfo.meltRolls();
        if (meltRolls == 0) {
            return;
        }
        float meltChance = meltInfo.meltChance() * 0.01f;
        if (meltChance == 0.0f) {
            return;
        }
        for (int i = 0; i < meltRolls; ++i) {
            if (!(level.field_9229.method_43057() < meltChance)) continue;
            action.run();
        }
    }
}

