/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import snownee.snow.CoreModule;
import snownee.snow.Hooks;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowVariant;
import snownee.snow.entity.FallingSnowEntity;
import snownee.snow.mixin.IceBlockAccess;
import snownee.snow.util.CommonProxy;

public class WorldTickHandler {
    public static void tick(class_3218 level, class_2818 chunk) {
        int x = chunk.method_12004().method_8326();
        int y = chunk.method_12004().method_8328();
        class_2338.class_2339 pos = level.method_8598(class_2902.class_2903.field_13197, level.method_8536(x, 0, y, 15)).method_25503();
        pos.method_10098(class_2350.field_11033);
        class_6880 biomeHolder = level.method_23753((class_2338)pos);
        boolean coldEnoughToSnow = CommonProxy.coldEnoughToSnow((class_1937)level, (class_2338)pos, (class_6880<class_1959>)biomeHolder);
        if (coldEnoughToSnow) {
            WorldTickHandler.doSnow(level, pos);
        } else {
            WorldTickHandler.doMelt(level, pos);
        }
    }

    private static void doMelt(class_3218 level, class_2338.class_2339 pos) {
        class_2680 state = level.method_8320((class_2338)pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof IceBlockAccess) {
            IceBlockAccess ice = (IceBlockAccess)class_22482;
            class_6880 biome = level.method_23753((class_2338)pos);
            if (CommonProxy.snowAndIceMeltInWarmBiomes((class_5321<class_1937>)level.method_27983(), (class_6880<class_1959>)biome) && ((class_1959)biome.comp_349()).method_39927((class_2338)pos)) {
                ice.callMelt(state, (class_1937)level, (class_2338)pos);
            }
            return;
        }
        class_2680 stateAbove = level.method_8320((class_2338)pos.method_10098(class_2350.field_11036));
        if (stateAbove.method_26204() instanceof SnowVariant) {
            Hooks.randomTick(stateAbove, level, (class_2338)pos, level.field_9229, 1.0f);
        } else if (state.method_26204() instanceof SnowVariant) {
            pos.method_10098(class_2350.field_11033);
            Hooks.randomTick(state, level, (class_2338)pos, level.field_9229, 1.0f);
        }
    }

    private static void doSnow(class_3218 level, class_2338.class_2339 pos) {
        int blizzard;
        if (!level.method_8419()) {
            return;
        }
        int n = blizzard = SnowCommonConfig.snowGravity ? level.method_8450().method_8356(CoreModule.BLIZZARD_STRENGTH) : 0;
        if (blizzard > 0) {
            WorldTickHandler.doBlizzard(level, (class_2338)pos, blizzard);
            return;
        }
        class_2680 state = level.method_8320((class_2338)pos);
        if (SnowCommonConfig.snowAccumulationMaxLayers <= 0) {
            return;
        }
        if (!Hooks.canContainState(state)) {
            if (SnowCommonConfig.snowAccumulationMaxLayers < 9 && state.method_26204() instanceof SnowVariant) {
                return;
            }
            state = level.method_8320((class_2338)pos.method_10098(class_2350.field_11036));
            if (!state.method_26215() && !Hooks.canContainState(state)) {
                return;
            }
        }
        if (state.method_26215() && !Hooks.canSnowSurvive(class_2246.field_10477.method_9564(), (class_1922)level, (class_2338)pos)) {
            return;
        }
        if (level.method_8314(class_1944.field_9282, (class_2338)pos.method_10098(class_2350.field_11036)) > SnowCommonConfig.snowSpawnMaxLightLevel) {
            return;
        }
        Hooks.convert((class_1936)level, (class_2338)pos.method_10098(class_2350.field_11033), state, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
        for (int i = 0; i < 5 && !state.method_26164(class_3481.field_15469) && !state.method_26164(class_3481.field_15459) && ((state = level.method_8320((class_2338)pos.method_10098(class_2350.field_11033))).method_26215() || Hooks.canContainState(state)); ++i) {
            if (!Hooks.canSnowSurvive(class_2246.field_10477.method_9564(), (class_1922)level, (class_2338)pos)) continue;
            pos.method_10098(class_2350.field_11036);
            if (level.method_8320((class_2338)pos).method_26204() instanceof class_2488 || level.method_8314(class_1944.field_9282, (class_2338)pos) > SnowCommonConfig.snowSpawnMaxLightLevel) break;
            Hooks.convert((class_1936)level, (class_2338)pos.method_10098(class_2350.field_11033), state, 1, 3, SnowCommonConfig.placeSnowOnBlockNaturally);
        }
    }

    private static void doBlizzard(class_3218 world, class_2338 pos, int blizzard) {
        if (pos.method_10264() == world.method_31605()) {
            return;
        }
        int frequency = world.method_8450().method_8356(CoreModule.BLIZZARD_FREQUENCY);
        if ((frequency = class_3532.method_15340((int)frequency, (int)0, (int)10000)) == 0) {
            return;
        }
        int i = world.field_9229.method_43048(10000);
        if (frequency != 10000 && i >= frequency) {
            return;
        }
        if ((blizzard = class_3532.method_15340((int)blizzard, (int)1, (int)8)) > 1) {
            blizzard = world.field_9229.method_43048(blizzard) + 1;
        }
        pos = pos.method_10086(64);
        FallingSnowEntity entity = new FallingSnowEntity((class_1937)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() - 0.5, (double)pos.method_10260() + 0.5, blizzard);
        world.method_8649((class_1297)entity);
    }
}

