/*
 * Decompiled with CFR 0.152.
 */
package snownee.snow;

import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2356;
import net.minecraft.class_2382;
import net.minecraft.class_2420;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2493;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2526;
import net.minecraft.class_2544;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2902;
import net.minecraft.class_2968;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3558;
import net.minecraft.class_3830;
import net.minecraft.class_4538;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import snownee.kiwi.KiwiGO;
import snownee.snow.CoreModule;
import snownee.snow.SnowCommonConfig;
import snownee.snow.block.SnowFenceBlock;
import snownee.snow.block.SnowVariant;
import snownee.snow.block.entity.SnowBlockEntity;
import snownee.snow.network.SSnowLandEffectPacket;
import snownee.snow.util.CommonProxy;

public final class Hooks {
    private Hooks() {
    }

    public static boolean canGrassSurvive(class_2680 blockState, class_4538 level, class_2338 blockPos) {
        class_2338 blockPos2 = blockPos.method_10084();
        class_2680 blockState2 = level.method_8320(blockPos2);
        if (blockState2.method_26164(CoreModule.SNOWY_SETTING)) {
            class_2248 class_22482 = blockState2.method_26204();
            if (class_22482 instanceof SnowVariant) {
                SnowVariant snowVariant = (SnowVariant)class_22482;
                return SnowCommonConfig.sustainGrassIfLayerMoreThanOne || snowVariant.layers(blockState2, (class_1922)level, blockPos2) <= 1;
            }
            return true;
        }
        int i = class_3558.method_20049((class_1922)level, (class_2680)blockState, (class_2338)blockPos, (class_2680)blockState2, (class_2338)blockPos2, (class_2350)class_2350.field_11036, (int)blockState2.method_26193((class_1922)level, blockPos2));
        return i < level.method_8315();
    }

    public static void placeFeatureExtra(class_1959 biome, class_5281 level, class_2338 pos, class_2338 belowPos) {
        if (SnowCommonConfig.replaceWorldFeature && SnowCommonConfig.placeSnowOnBlockNaturally && SnowCommonConfig.canPlaceSnowInBlock()) {
            if (biome.method_39927(pos) || level.method_8314(class_1944.field_9282, pos) >= 10 || !class_2246.field_10477.method_9564().method_26184((class_4538)level, pos)) {
                return;
            }
            class_2680 blockstate = level.method_8320(pos);
            if (Hooks.convert((class_1936)level, pos, blockstate, 1, 2, true) && (blockstate = level.method_8320(belowPos)).method_28498((class_2769)class_2493.field_11522)) {
                level.method_8652(belowPos, (class_2680)blockstate.method_11657((class_2769)class_2493.field_11522, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    public static boolean canSnowSurvive(class_2680 state, class_1922 level, class_2338 pos) {
        class_2680 blockstate = level.method_8320(pos = pos.method_10074());
        if (blockstate.method_26164(class_3481.field_39104)) {
            return false;
        }
        if (blockstate.method_26164(class_3481.field_39105)) {
            return true;
        }
        return class_2248.method_9501((class_265)blockstate.method_26220(level, pos), (class_2350)class_2350.field_11036);
    }

    public static boolean canContainState(class_2680 state) {
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.method_31709() || !state.method_26227().method_15769()) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (state.method_26164(CoreModule.NOT_CONTAINABLES)) {
            return false;
        }
        if (state.method_26164(CoreModule.CONTAINABLES) || block instanceof class_2526 || block instanceof class_2320 || block instanceof class_2356 || block instanceof class_2473 || block instanceof class_2420 || block instanceof class_3830) {
            return true;
        }
        if (block instanceof class_2354) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE.defaultBlockState());
        }
        if (block instanceof class_2349) {
            return Hooks.hasAllProperties(state, CoreModule.FENCE_GATE.defaultBlockState());
        }
        if (block instanceof class_2544) {
            return Hooks.hasAllProperties(state, CoreModule.WALL.defaultBlockState());
        }
        if (block instanceof class_2482 && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
            return true;
        }
        if (block instanceof class_2510 && state.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617) {
            return Hooks.hasAllProperties(state, CoreModule.STAIRS.defaultBlockState());
        }
        return false;
    }

    public static boolean convert(class_1936 level, class_2338 pos, class_2680 state, int layers, int flags, boolean canConvert) {
        if (state.method_26215()) {
            Hooks.placeNormalSnow(level, pos, layers, flags);
            return true;
        }
        if (!SnowCommonConfig.canPlaceSnowInBlock() || state.method_31709()) {
            return false;
        }
        if (!canConvert) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (state.method_26164(CoreModule.CONTAINABLES) || block instanceof class_2526 || block instanceof class_2320 || block instanceof class_2356 || block instanceof class_2473 || block instanceof class_2420 || block instanceof class_3830) {
            level.method_8652(pos, (class_2680)CoreModule.TILE_BLOCK.defaultBlockState().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(layers)), flags);
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof SnowBlockEntity) {
                SnowBlockEntity snowBlockEntity = (SnowBlockEntity)class_25862;
                snowBlockEntity.setContainedState(state);
            }
            return true;
        }
        class_2338 posDown = pos.method_10074();
        class_2680 stateDown = level.method_8320(posDown);
        if (block instanceof class_2510 && !CoreModule.STAIRS.is(state)) {
            newState = CoreModule.STAIRS.defaultBlockState();
            newState = Hooks.copyProperties(state, newState);
            level.method_8652(pos, newState, flags);
        } else if (block instanceof class_2482 && !CoreModule.SLAB.is(state) && state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
            level.method_8652(pos, CoreModule.SLAB.defaultBlockState(), flags);
        } else if (block instanceof class_2354 && block.getClass() != SnowFenceBlock.class) {
            KiwiGO<class_2248> newBlock = state.method_26164(class_3481.field_17619) || state.method_26231() == class_2498.field_11547 ? CoreModule.FENCE : CoreModule.FENCE2;
            class_2680 newState = newBlock.defaultBlockState();
            newState = (class_2680)Hooks.copyProperties(state, newState).method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            newState = newState.method_26191(class_2350.field_11033, stateDown, level, pos, posDown);
            level.method_8652(pos, newState, flags);
        } else if (block instanceof class_2349 && !CoreModule.FENCE_GATE.is(state)) {
            newState = CoreModule.FENCE_GATE.defaultBlockState();
            newState = (class_2680)Hooks.copyProperties(state, newState).method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            newState = newState.method_26191(class_2350.field_11033, stateDown, level, pos, posDown);
            level.method_8652(pos, newState, flags);
        } else if (block instanceof class_2544 && !CoreModule.WALL.is(state)) {
            newState = CoreModule.WALL.defaultBlockState();
            newState = (class_2680)Hooks.copyProperties(state, newState).method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(layers));
            newState = newState.method_26191(class_2350.field_11033, stateDown, level, pos, posDown);
            level.method_8652(pos, newState, flags);
        } else {
            return false;
        }
        class_2586 tile = level.method_8321(pos);
        if (tile instanceof SnowBlockEntity) {
            ((SnowBlockEntity)tile).setContainedState(state);
        }
        return true;
    }

    private static <T extends Comparable<T>> boolean hasAllProperties(class_2680 oldState, class_2680 newState) {
        for (Map.Entry entry : newState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            if (property == SnowVariant.OPTIONAL_LAYERS || oldState.method_28498(property)) continue;
            return false;
        }
        return true;
    }

    public static <T extends Comparable<T>> class_2680 copyProperties(class_2680 oldState, class_2680 newState) {
        for (Map.Entry entry : oldState.method_11656().entrySet()) {
            class_2769 property = (class_2769)entry.getKey();
            if (!newState.method_28498(property)) continue;
            newState = (class_2680)newState.method_11657(property, (Comparable)property.method_11902().cast(entry.getValue()));
        }
        return newState;
    }

    public static boolean placeLayersOn(class_1937 level, class_2338 pos, int layers, boolean fallingEffect, class_1750 useContext, boolean playSound, boolean canConvert) {
        layers = class_3532.method_15340((int)layers, (int)1, (int)8);
        class_2680 state = level.method_8320(pos);
        int originLayers = 0;
        if (state.method_28498((class_2769)class_2488.field_11518)) {
            originLayers = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(class_3532.method_15340((int)(originLayers + layers), (int)1, (int)8))));
        } else if (state.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
            originLayers = (Integer)state.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS);
            if (originLayers == 0 && !Hooks.canSnowSurvive(state, (class_1922)level, pos)) {
                return false;
            }
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(class_3532.method_15340((int)(originLayers + layers), (int)1, (int)8))));
        } else if (canConvert && Hooks.canContainState(state) && state.method_26184((class_4538)level, pos)) {
            Hooks.convert((class_1936)level, pos, state, class_3532.method_15340((int)layers, (int)1, (int)8), 3, canConvert);
        } else if (Hooks.canSnowSurvive(state, (class_1922)level, pos) && state.method_26166(useContext)) {
            Hooks.placeNormalSnow((class_1936)level, pos, layers, 3);
        } else {
            return false;
        }
        class_2680 newState = level.method_8320(pos);
        class_2248.method_9582((class_2680)state, (class_2680)newState, (class_1936)level, (class_2338)pos);
        if (fallingEffect) {
            SSnowLandEffectPacket.send(level, pos, originLayers, layers);
        } else if (playSound) {
            class_2498 soundtype = class_2246.field_10477.method_9573(class_2246.field_10477.method_9564());
            level.method_8396(null, pos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
        }
        if (originLayers + layers > 8) {
            pos = pos.method_10084();
            newState = level.method_8320(pos);
            useContext = class_1750.method_16355((class_1750)useContext, (class_2338)pos, (class_2350)class_2350.field_11036);
            if (Hooks.canSnowSurvive(class_2246.field_10477.method_9564(), (class_1922)level, pos) && newState.method_26166(useContext)) {
                Hooks.placeLayersOn(level, pos, layers - (8 - originLayers), fallingEffect, useContext, playSound, canConvert);
            }
        }
        return true;
    }

    public static void placeNormalSnow(class_1936 level, class_2338 pos, int layers, int flags) {
        class_2680 stateBelow = level.method_8320(pos.method_10074());
        class_2248 block = SnowCommonConfig.fancySnowOnUpperSlab && stateBelow.method_26204() instanceof class_2482 ? (class_2248)CoreModule.TILE_BLOCK.get() : class_2246.field_10477;
        stateBelow = (class_2680)block.method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(class_3532.method_15340((int)layers, (int)1, (int)8)));
        level.method_8652(pos, stateBelow, flags);
        if (CoreModule.TILE_BLOCK.is((Object)block)) {
            Hooks.setPlacedBy(level, pos, stateBelow);
        }
    }

    public static void setPlacedBy(class_1936 level, class_2338 pos, class_2680 state) {
        SnowBlockEntity blockEntity;
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof SnowBlockEntity && (blockEntity = (SnowBlockEntity)class_25862).getContainedState().method_26215()) {
            blockEntity.options.update(true);
        }
    }

    public static boolean canFallThrough(class_2680 state, class_1937 level, class_2338 pos) {
        SnowVariant snow;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof SnowVariant && (snow = (SnowVariant)class_22482).maxLayers(state, level, pos) == 8 && snow.layers(state, (class_1922)level, pos) < 8) {
            return true;
        }
        return class_2346.method_10128((class_2680)state) && state.method_26220((class_1922)level, pos).method_1110();
    }

    public static void randomTick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        Hooks.randomTick(state, level, pos, random, 0.125f);
    }

    public static void randomTick(class_2680 state, class_3218 level, class_2338 pos, class_5819 random, float chance) {
        boolean melt;
        if (CommonProxy.terraforged) {
            return;
        }
        if (chance != 1.0f && random.method_43057() > chance) {
            return;
        }
        class_6880 biome = level.method_23753(pos);
        SnowVariant snow = (SnowVariant)state.method_26204();
        int layers = snow.layers(state, (class_1922)level, pos);
        boolean meltByTemperature = false;
        boolean meltByBrightness = false;
        if (!SnowCommonConfig.snowNeverMelt) {
            if (layers == 8) {
                SnowVariant s;
                class_2338 above = pos.method_10084();
                class_2680 upState = level.method_8320(above);
                class_2248 class_22482 = upState.method_26204();
                if (class_22482 instanceof SnowVariant && (s = (SnowVariant)class_22482).layers(upState, (class_1922)level, above) > 0) {
                    return;
                }
                meltByBrightness = level.method_8314(class_1944.field_9282, above) >= SnowCommonConfig.snowPersistMaxLightLevel;
            } else {
                meltByBrightness = level.method_8314(class_1944.field_9282, pos) > SnowCommonConfig.snowPersistMaxLightLevel;
            }
            meltByTemperature = CommonProxy.shouldMelt((class_1937)level, pos, (class_6880<class_1959>)biome, layers);
        }
        boolean bl = melt = meltByTemperature || meltByBrightness;
        if (!melt && SnowCommonConfig.accumulationWinterOnly && !CommonProxy.isWinter((class_1937)level, pos, (class_6880<class_1959>)biome)) {
            return;
        }
        boolean accumulate = false;
        if (layers < SnowCommonConfig.snowAccumulationMaxLayers && !meltByBrightness && level.method_8419() && CommonProxy.coldEnoughToSnow((class_1937)level, pos, (class_6880<class_1959>)biome)) {
            accumulate = CommonProxy.snowAccumulationNow((class_1937)level);
        }
        if (accumulate) {
            if (!level.method_8320(pos.method_10074()).method_26164(CoreModule.CANNOT_ACCUMULATE_ON)) {
                Hooks.accumulate(level, pos, state, (w, p) -> (SnowCommonConfig.snowAccumulationMaxLayers > 8 || !(w.method_8320(p.method_10074()).method_26204() instanceof class_2488)) && w.method_8314(class_1944.field_9282, p) <= SnowCommonConfig.snowSpawnMaxLightLevel, true);
            }
        } else if (melt) {
            Hooks.accumulate(level, pos, state, (w, p) -> !(w.method_8320(p.method_10084()).method_26204() instanceof class_2488), false);
        }
    }

    private static void accumulate(class_3218 level, class_2338 pos, class_2680 centerState, BiPredicate<class_1936, class_2338> filter, boolean accumulate) {
        SnowVariant centerSnowVariant = (SnowVariant)centerState.method_26204();
        int i = centerSnowVariant.layers(centerState, (class_1922)level, pos);
        class_2338.class_2339 pos2 = pos.method_25503();
        for (int j = 0; j < 8; ++j) {
            int l;
            SnowVariant snowVariant;
            int k = j / 2;
            class_2350 direction = class_2350.method_10139((int)k);
            pos2.method_25505((class_2382)pos, direction);
            if (j % 2 == 1) {
                pos2.method_10098(direction);
            }
            if (!level.method_8477((class_2338)pos2) || !filter.test((class_1936)level, (class_2338)pos2)) continue;
            class_2680 state = level.method_8320((class_2338)pos2);
            class_2338 height = level.method_8598(class_2902.class_2903.field_13197, (class_2338)pos2);
            if (height.method_10264() != pos2.method_10264() && (height.method_10264() != pos2.method_10264() + 1 || !(state.method_26204() instanceof SnowVariant)) || !Hooks.canSnowSurvive(state, (class_1922)level, (class_2338)pos2)) continue;
            class_2248 class_22482 = state.method_26204();
            if (class_22482 instanceof SnowVariant) {
                snowVariant = (SnowVariant)class_22482;
                l = snowVariant.layers(state, (class_1922)level, (class_2338)pos2);
                if (accumulate) {
                    if (l >= snowVariant.maxLayers(state, (class_1937)level, (class_2338)pos2) || level.method_8320((class_2338)pos2.method_10098(class_2350.field_11033)).method_26164(CoreModule.CANNOT_ACCUMULATE_ON)) continue;
                    pos2.method_10098(class_2350.field_11036);
                }
            } else {
                l = 0;
            }
            if (!(accumulate ? i > l : i < l)) continue;
            if (accumulate) {
                Hooks.placeLayersOn((class_1937)level, (class_2338)pos2, 1, false, (class_1750)new class_2968((class_1937)level, (class_2338)pos2, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false, SnowCommonConfig.placeSnowOnBlockNaturally);
            } else {
                snowVariant = (SnowVariant)state.method_26204();
                level.method_8501((class_2338)pos2, snowVariant.decreaseLayer(state, (class_1937)level, (class_2338)pos2, false));
            }
            return;
        }
        if (accumulate) {
            Hooks.placeLayersOn((class_1937)level, pos, 1, false, (class_1750)new class_2968((class_1937)level, pos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033), false, SnowCommonConfig.placeSnowOnBlockNaturally);
        } else {
            level.method_8501(pos, centerSnowVariant.decreaseLayer(centerState, (class_1937)level, pos, false));
        }
    }

    public static boolean isSnowySetting(class_2680 state) {
        if (state.method_26164(CoreModule.SNOWY_SETTING)) {
            return !state.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS) || (Integer)state.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS) != 0;
        }
        return false;
    }

    public static boolean canBeReplaced(class_2680 state, class_1750 context) {
        if (!context.method_8041().method_31574(class_1802.field_8749)) {
            return false;
        }
        int i = (Integer)state.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS);
        if (i == 8) {
            return false;
        }
        return i > 0 || Hooks.canSnowSurvive(state, (class_1922)context.method_8045(), context.method_8037());
    }

    public static class_2680 getStateForPlacement(class_1750 context) {
        class_2680 stateBelow;
        class_2680 state = context.method_8045().method_8320(context.method_8037());
        if (state.method_28498((class_2769)class_2488.field_11518)) {
            int i = (Integer)state.method_11654((class_2769)class_2488.field_11518);
            return (class_2680)state.method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        if (state.method_28498((class_2769)SnowVariant.OPTIONAL_LAYERS)) {
            int i = (Integer)state.method_11654((class_2769)SnowVariant.OPTIONAL_LAYERS);
            return (class_2680)state.method_11657((class_2769)SnowVariant.OPTIONAL_LAYERS, (Comparable)Integer.valueOf(Math.min(8, i + 1)));
        }
        class_1799 stack = context.method_8041();
        class_2487 tag = class_1747.method_38072((class_1799)stack);
        if (tag != null && "snowrealmagic:snow".equals(tag.method_10558("id"))) {
            return CoreModule.TILE_BLOCK.defaultBlockState();
        }
        if (SnowCommonConfig.fancySnowOnUpperSlab && (stateBelow = context.method_8045().method_8320(context.method_8037().method_10074())).method_26204() instanceof class_2482) {
            return CoreModule.TILE_BLOCK.defaultBlockState();
        }
        return class_2246.field_10477.method_9564();
    }

    public static boolean isFallable(class_2680 blockState) {
        return SnowCommonConfig.snowGravity && (blockState.method_27852(class_2246.field_10477) || CoreModule.TILE_BLOCK.is(blockState));
    }
}

