/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.integration.supp;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.snowyspirit.SnowySpirit;
import net.mehvahdjukaar.snowyspirit.reg.ModMemoryModules;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.PresentBlockTile;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class PlacePresentTask
extends class_4097<class_1646> {
    private final float speedModifier;
    private class_2338 targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 600;

    public static boolean isPresentOn() {
        return CommonConfigs.isEnabled((String)"present");
    }

    public PlacePresentTask(float speed) {
        super((Map)ImmutableMap.of(ModMemoryModules.PLACED_PRESENT.get(), (Object)class_4141.field_18457, (Object)class_4140.field_18440, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18457), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(class_3218 level, class_1646 pOwner) {
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.method_6109()) {
            return false;
        }
        if (!SnowySpirit.isChristmasSeason((class_1937)level)) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((class_1937)level, (class_1297)pOwner) || level.field_9229.method_43048(5) != 0) {
            this.cooldown = 1000;
            return false;
        }
        Optional meeting = pOwner.method_18868().method_18904(class_4140.field_18440);
        if (meeting.isEmpty() || level.method_27983() != ((class_4208)meeting.get()).method_19442() || ((class_4208)meeting.get()).method_19446().method_10262((class_2382)pOwner.method_24515()) > 225.0) {
            this.cooldown = 400;
            return false;
        }
        return true;
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        this.cooldown = 20 * (10 + pLevel.field_9229.method_43048(10)) + pLevel.field_9229.method_43048(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlacePresentTask.getValidPlacementPos(pLevel, (class_1309)pEntity);
        if (this.targetPos != null) {
            pEntity.method_18868().method_18875(class_4140.field_18447);
            pEntity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, this.speedModifier, 1));
            PlacePresentTask.displayAsHeldItem(pEntity, this.getRandomPresent(pLevel.field_9229));
        }
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
        PlacePresentTask.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        return this.targetPos != null && PlacePresentTask.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(class_3218 pLevel, class_1646 pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.method_18868().method_18875(class_4140.field_18447);
            pOwner.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, this.speedModifier, 2));
            pOwner.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetPos));
            if (this.targetPos.method_19769((class_2374)pOwner.method_19538(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    class_1799 stack = pOwner.method_6047();
                    class_1792 class_17922 = stack.method_7909();
                    if (class_17922 instanceof class_1747) {
                        class_1747 blockItem = (class_1747)class_17922;
                        class_2680 state = (class_2680)blockItem.method_7711().method_9564().method_11657((class_2769)PresentBlock.PACKED, (Comparable)Boolean.valueOf(true));
                        pLevel.method_8501(this.targetPos, state);
                        class_2498 soundtype = state.method_26231();
                        pLevel.method_8396(null, this.targetPos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                        pOwner.method_18868().method_18878(ModMemoryModules.PLACED_PRESENT.get(), (Object)true);
                        class_2586 class_25862 = pLevel.method_8321(this.targetPos);
                        if (class_25862 instanceof PresentBlockTile) {
                            PresentBlockTile tile = (PresentBlockTile)class_25862;
                            tile.method_11285(SnowySpirit.res("chests/present_villager"), pLevel.method_8409().method_43055());
                            tile.setSender(pOwner.method_5477().getString());
                        }
                    }
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static class_2338 getValidPlacementPos(class_3218 pLevel, class_1309 pWalker) {
        class_5819 random = pWalker.method_6051();
        Optional v = pWalker.method_18868().method_18904(class_4140.field_18440);
        if (v.isEmpty()) {
            return null;
        }
        class_2338 meeting = ((class_4208)v.get()).method_19446();
        for (int i = 0; i < 6; ++i) {
            class_2338 pos = meeting.method_10069(random.method_43048(20) - 10, random.method_43048(6) - 3, random.method_43048(20) - 10);
            if (!PlacePresentTask.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(class_3218 serverLevel, class_2338 pos) {
        class_2680 state;
        if (serverLevel.method_8311(pos) && (double)serverLevel.method_8598(class_2902.class_2903.field_13197, pos).method_10264() >= (double)(serverLevel.method_8615() - 10) && (state = serverLevel.method_8320(pos)).method_45474() && state.method_26227().method_15769()) {
            class_2680 below = serverLevel.method_8320(pos.method_10074());
            return below.method_26206((class_1922)serverLevel, pos, class_2350.field_11036) || below.method_26164(class_3481.field_29822);
        }
        return false;
    }

    public class_1799 getRandomPresent(class_5819 random) {
        return ((class_2248)((Supplier)ModRegistry.PRESENTS.get(class_1767.values()[random.method_43048(class_1767.values().length)])).get()).method_8389().method_7854();
    }

    public static void clearHeldItem(class_1646 self) {
        self.method_5673(class_1304.field_6173, class_1799.field_8037);
        self.method_5946(class_1304.field_6173, 0.085f);
    }

    public static void displayAsHeldItem(class_1646 self, class_1799 stack) {
        self.method_5673(class_1304.field_6173, stack);
        self.method_5946(class_1304.field_6173, 0.0f);
    }
}

