/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl;

import com.github.thedeathlycow.thermoo.api.temperature.effects.ConfiguredTemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public class TemperatureEffectLoader
implements SimpleSynchronousResourceReloadListener {
    public static final TemperatureEffectLoader INSTANCE = new TemperatureEffectLoader(Thermoo.id("temperature_effects"));
    private final Map<class_2960, ConfiguredTemperatureEffect<?>> globalEffects = new HashMap();
    private final Map<class_2960, Set<ConfiguredTemperatureEffect<?>>> typeSpecificEffects = new HashMap();
    private final class_2960 id;

    public TemperatureEffectLoader(class_2960 id) {
        this.id = id;
    }

    public Collection<ConfiguredTemperatureEffect<?>> getEffectsForEntity(class_1309 entity) {
        class_1299 type = entity.method_5864();
        class_2960 typeId = class_7923.field_41177.method_10221((Object)type);
        Set<ConfiguredTemperatureEffect<?>> effects = this.typeSpecificEffects.get(typeId);
        if (effects == null) {
            return Collections.emptySet();
        }
        return effects;
    }

    public Collection<ConfiguredTemperatureEffect<?>> getGlobalEffects() {
        return this.globalEffects.values();
    }

    public class_2960 getFabricId() {
        return this.id;
    }

    public void method_14491(class_3300 manager) {
        HashMap newEffects = new HashMap();
        HashMap newTypeEffects = new HashMap();
        for (Map.Entry<class_2960, class_3298> entry : manager.method_14488("thermoo/temperature_effects", eid -> eid.method_12832().endsWith(".json")).entrySet()) {
            try {
                BufferedReader reader = ((class_3298)entry.getValue()).method_43039();
                try {
                    this.loadEffect(newEffects, newTypeEffects, entry, reader);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (Exception e) {
                Thermoo.LOGGER.error("An error occurred while loading temperature effect {}: {}", entry.getKey(), (Object)e);
            }
        }
        this.globalEffects.clear();
        this.globalEffects.putAll(newEffects);
        this.typeSpecificEffects.clear();
        this.typeSpecificEffects.putAll(newTypeEffects);
        int numEffects = this.globalEffects.size();
        int n = this.typeSpecificEffects.values().stream().map(Set::size).reduce(0, Integer::sum);
        Thermoo.LOGGER.info("Loaded {} global temperature effect{}", (Object)numEffects, (Object)(numEffects == 1 ? "" : "s"));
        Thermoo.LOGGER.info("Loaded {} type specific temperature effect{}", (Object)n, (Object)(n == 1 ? "" : "s"));
    }

    private void loadEffect(Map<class_2960, ConfiguredTemperatureEffect<?>> newEffects, Map<class_2960, Set<ConfiguredTemperatureEffect<?>>> newTypeEffects, Map.Entry<class_2960, class_3298> entry, BufferedReader reader) {
        ConfiguredTemperatureEffect effect = (ConfiguredTemperatureEffect)ConfiguredTemperatureEffect.Serializer.GSON.fromJson((Reader)reader, ConfiguredTemperatureEffect.class);
        class_1299<?> type = effect.getEntityType();
        if (type != null) {
            newTypeEffects.computeIfAbsent(class_7923.field_41177.method_10221(type), eid -> new HashSet()).add(effect);
        } else {
            newEffects.put(entry.getKey(), effect);
        }
    }
}

