/*
 * Decompiled with CFR 0.152.
 */
package com.betterchunkloading.chunk;

import com.betterchunkloading.BetterChunkLoading;
import com.betterchunkloading.config.CommonConfiguration;
import com.betterchunkloading.event.EventHandler;
import com.betterchunkloading.event.ITickingTask;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3194;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3228;
import net.minecraft.class_3230;
import net.minecraft.class_4706;
import net.minecraft.class_5321;
import net.minecraft.class_8563;

public class PlayerChunkData {
    private static final class_1923 INVALID = new class_1923(0, 0){

        public boolean equals(Object other) {
            return other == INVALID;
        }
    };
    private final class_3230<class_1923> chunkloadTicketType;
    private final class_3230<class_1923> predictionTicketType;
    private class_1923 lastChunk = INVALID;
    private class_5321<class_1937> lastLevel = null;
    private ChunkLoadingTask viewDistLoadTask = null;
    private int playerChunkLoadViewDistance = 0;
    ChunkLoadingTask predictionTask = null;
    private class_2338[] playerMovementTracker = new class_2338[6];
    private int playerMovementTrackerIndex = 0;
    private long lastPlayerMovementUpdate = 0L;
    private class_2338 lastPlayerPos = null;
    private double playerMovementSpeed = 0.0;
    private class_243 direction = class_243.field_1353;
    private static Long2ObjectOpenHashMap<Set<class_3228>> expiringTicketsMap = new Long2ObjectOpenHashMap();

    public PlayerChunkData(class_3222 player) {
        this.chunkloadTicketType = class_3230.method_20628((String)("bcl_player_" + player.method_5477().getString()), Comparator.comparingLong(class_1923::method_8324), (int)24000);
        this.predictionTicketType = class_3230.method_20628((String)("bcl_pred_player_" + player.method_5477().getString()), Comparator.comparingLong(class_1923::method_8324), (int)1200);
    }

    public void onChunkChanged(class_3222 player, class_1923 chunkPos) {
        if (player == null || player.getClass() != class_3222.class) {
            return;
        }
        if (chunkPos == null) {
            chunkPos = player.method_31476();
        }
        if (!player.method_37908().method_27983().equals(this.lastLevel)) {
            if (this.lastLevel != null && this.predictionTask != null) {
                this.predictionTask.cancel();
                this.predictionTask = null;
            }
            this.updatePlayerViewDistance(chunkPos, (class_3215)player.method_37908().method_8398(), 4, this.chunkloadTicketType);
            this.playerChunkLoadViewDistance = 4;
            this.playerMovementTracker = new class_2338[6];
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
            this.direction = class_243.field_1353;
            this.lastLevel = player.method_37908().method_27983();
            this.lastChunk = null;
            return;
        }
        if (this.lastChunk != null && chunkPos.method_24022(this.lastChunk) > 10) {
            this.playerMovementTracker = new class_2338[6];
            this.playerMovementTrackerIndex = 0;
            this.lastPlayerMovementUpdate = 0L;
            this.lastPlayerPos = null;
            this.playerMovementSpeed = 0.0;
            this.direction = class_243.field_1353;
            if (this.predictionTask != null) {
                this.predictionTask.cancel();
                this.predictionTask = null;
            }
            this.updatePlayerViewDistance(chunkPos, (class_3215)player.method_37908().method_8398(), 4, this.chunkloadTicketType);
            this.lastLevel = player.method_37908().method_27983();
            this.lastChunk = null;
            return;
        }
        if (chunkPos.equals((Object)this.lastChunk)) {
            if (System.currentTimeMillis() - this.lastPlayerMovementUpdate > 5000L) {
                this.trackPlayerMovement(player);
            }
            return;
        }
        this.trackPlayerMovement(player);
        this.lastChunk = chunkPos;
    }

    private void trackPlayerMovement(class_3222 player) {
        long currentTime = System.currentTimeMillis();
        if (this.lastPlayerPos != null) {
            this.playerMovementSpeed -= this.playerMovementSpeed / 5.0;
            int x = player.method_31477() - this.lastPlayerPos.method_10263();
            int z = player.method_31479() - this.lastPlayerPos.method_10260();
            this.playerMovementSpeed += Math.sqrt(x * x + z * z) / ((double)(currentTime - this.lastPlayerMovementUpdate) / 1000.0) / 5.0;
        }
        this.lastPlayerPos = player.method_24515();
        this.lastPlayerMovementUpdate = currentTime;
        if (!player.method_31476().equals((Object)this.lastChunk)) {
            this.playerMovementTrackerIndex = (this.playerMovementTrackerIndex + 1) % this.playerMovementTracker.length;
            this.playerMovementTracker[this.playerMovementTrackerIndex] = player.method_24515();
            this.checkDirection(player);
        }
        this.doChunkLoadForPlayer(player, this.lastChunk);
    }

    private class_243 calculatePlayerMovementVec() {
        int xOld = 0;
        int zOld = 0;
        int oldCounter = 0;
        int xNew = 0;
        int zNew = 0;
        int newCounter = 0;
        for (int i = 0; i < this.playerMovementTracker.length; ++i) {
            class_2338 pos = this.playerMovementTracker[(this.playerMovementTrackerIndex + 1 + i) % this.playerMovementTracker.length];
            if (pos == null) continue;
            if (i < this.playerMovementTracker.length / 2) {
                xOld += pos.method_10263();
                zOld += pos.method_10260();
                ++oldCounter;
                continue;
            }
            xNew += pos.method_10263();
            zNew += pos.method_10260();
            ++newCounter;
        }
        if (oldCounter == 0 || newCounter == 0) {
            return new class_243(48.0, 0.0, 0.0);
        }
        return new class_243((double)((xNew /= newCounter) - (xOld /= oldCounter)), 0.0, (double)((zNew /= newCounter) - (zOld /= oldCounter)));
    }

    private void doChunkLoadForPlayer(class_3222 player, class_1923 lastChunk) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        int viewDistance = ((class_3215)player.method_37908().method_8398()).field_17254.field_18243;
        if (player.method_31476().equals((Object)lastChunk) && viewDistance == this.playerChunkLoadViewDistance) {
            return;
        }
        this.updatePlayerViewDistance(player.method_31476(), ((class_3218)player.method_37908()).method_14178(), viewDistance, this.chunkloadTicketType);
    }

    private void updatePlayerViewDistance(class_1923 pos, class_3215 chunkSource, int viewDistance, class_3230 ticketType) {
        if (!((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enableSmartChunkLoading) {
            return;
        }
        if (pos == null) {
            if (this.viewDistLoadTask != null) {
                this.viewDistLoadTask.cancel();
            }
            this.viewDistLoadTask = null;
            return;
        }
        this.playerChunkLoadViewDistance = viewDistance;
        class_1923 predictionPos = new class_1923(pos.field_9181 + (int)this.direction.method_1029().method_18805((double)3.0, (double)3.0, (double)3.0).field_1352, pos.field_9180 + (int)this.direction.method_1029().method_18805((double)3.0, (double)3.0, (double)3.0).field_1350);
        ArrayList<ChunkTicketPos> toLoad = new ArrayList<ChunkTicketPos>();
        for (int x = pos.field_9181 - viewDistance; x < pos.field_9181 + viewDistance; ++x) {
            for (int z = pos.field_9180 - viewDistance; z < pos.field_9180 + viewDistance; ++z) {
                int xDiff = pos.field_9181 - x;
                int zDiff = pos.field_9180 - z;
                double distance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                if (!(distance < (double)viewDistance)) continue;
                ChunkTicketPos ticketPos = new ChunkTicketPos(new class_1923(x, z), (class_3230<class_1923>)ticketType, 2);
                xDiff = predictionPos.field_9181 - x;
                zDiff = predictionPos.field_9180 - z;
                ticketPos.distanceToPlayer = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                ticketPos.ticking = true;
                toLoad.add(ticketPos);
            }
        }
        toLoad.sort(Comparator.comparingDouble(ChunkTicketPos::getDistanceToPlayer));
        ChunkLoadingTask newTask = new ChunkLoadingTask(pos, chunkSource, new ArrayDeque<ChunkTicketPos>(toLoad));
        EventHandler.addTickingTask((class_5321<class_1937>)chunkSource.method_16434().method_27983(), newTask);
        this.checkExisting((class_3218)chunkSource.method_16434());
        if (this.viewDistLoadTask != null) {
            newTask.syncWithLastTask(this.viewDistLoadTask);
            this.viewDistLoadTask.cancel();
        }
        newTask.loadSpeedModifier = 7.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).smartChunkLoadingSpeed;
        this.viewDistLoadTask = newTask;
        this.checkExisting((class_3218)chunkSource.method_16434());
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            BetterChunkLoading.LOGGER.info("Set player chunkloading chunk position to: " + pos + " viewdist:" + viewDistance);
        }
    }

    public static int getTicketLevelForArea(int ticketArea) {
        return class_8563.method_51828((class_3194)class_3194.field_44855) - ticketArea;
    }

    public void onLogout(class_3222 player) {
        this.updatePlayerViewDistance(null, ((class_3218)player.method_37908()).method_14178(), 0, this.chunkloadTicketType);
        if (this.predictionTask != null) {
            this.predictionTask.cancel();
        }
    }

    private void checkDirection(class_3222 player) {
        this.direction = this.calculatePlayerMovementVec();
        class_243 currentpos = player.method_19538();
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).enablePrediction) {
            this.checkPrediction(this.direction, currentpos, player);
        }
    }

    private void checkPrediction(class_243 direction, class_243 currentPos, class_3222 player) {
        class_243 predictedPos = currentPos.method_1019(direction.method_1029().method_1021((double)(16 * Math.max(3, ((class_3215)player.method_37908().method_8398()).field_17254.field_18243 - ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea * 2))));
        for (int i = 0; i < 30 && !player.method_37908().method_8393((int)predictedPos.field_1352 >> 4, (int)predictedPos.field_1350 >> 4); ++i) {
            predictedPos = predictedPos.method_1019(direction.method_1029().method_22882().method_1021(16.0));
        }
        if (((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).debugLogging) {
            class_1923 nextPredictedStartChunk = new class_1923((int)predictedPos.field_1352 >> 4, (int)predictedPos.field_1350 >> 4);
            BetterChunkLoading.LOGGER.info("Set predictive loading position with area:" + ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea + " to chunk: " + nextPredictedStartChunk + " player chunk:" + player.method_31476());
        }
        class_1923 center = new class_1923((int)predictedPos.field_1352 >> 4, (int)predictedPos.field_1350 >> 4);
        class_1923 predictionPos = new class_1923(player.method_31476().field_9181 + (int)direction.method_1029().method_18805((double)3.0, (double)3.0, (double)3.0).field_1352, player.method_31476().field_9180 + (int)direction.method_1029().method_18805((double)3.0, (double)3.0, (double)3.0).field_1350);
        int areaRadius = ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionarea;
        ArrayList<ChunkTicketPos> toLoad = new ArrayList<ChunkTicketPos>();
        for (int x = center.field_9181 - areaRadius; x < center.field_9181 + areaRadius; ++x) {
            for (int z = center.field_9180 - areaRadius; z < center.field_9180 + areaRadius; ++z) {
                ChunkTicketPos chunkTicketPos;
                int xDiff = center.field_9181 - x;
                int zDiff = center.field_9180 - z;
                double distance = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                if (!(distance < (double)areaRadius)) continue;
                ChunkTicketPos ticketPos = new ChunkTicketPos(new class_1923(x, z), this.predictionTicketType, 1);
                if (this.viewDistLoadTask != null && ticketPos.equals(chunkTicketPos = this.viewDistLoadTask.loadedChunks.get(ticketPos.pos))) continue;
                xDiff = predictionPos.field_9181 - x;
                zDiff = predictionPos.field_9180 - z;
                ticketPos.distanceToPlayer = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
                toLoad.add(ticketPos);
            }
        }
        toLoad.sort(Comparator.comparingDouble(ChunkTicketPos::getDistanceToPlayer));
        ChunkLoadingTask newTask = new ChunkLoadingTask(center, ((class_3218)player.method_37908()).method_14178(), new ArrayDeque<ChunkTicketPos>(toLoad));
        EventHandler.addTickingTask((class_5321<class_1937>)player.method_37908().method_27983(), newTask);
        this.checkExisting((class_3218)player.method_37908());
        if (this.predictionTask != null) {
            newTask.syncWithLastTask(this.predictionTask);
            this.predictionTask.cancel();
        }
        this.predictionTask = newTask;
        this.predictionTask.loadSpeedModifier = 10.0 * ((CommonConfiguration)BetterChunkLoading.config.getCommonConfig()).predictionLoadingSpeed;
        this.checkExisting((class_3218)player.method_37908());
        this.predictionTask.tick();
    }

    public void checkExisting(class_3218 level) {
        if (!BetterChunkLoading.IN_DEV || this.lastChunk == null) {
            return;
        }
        for (Long2ObjectMap.Entry ticketEntry : level.method_14178().field_17252.field_13895.long2ObjectEntrySet()) {
            class_1923 chunk = new class_1923(ticketEntry.getLongKey());
            double distance = chunk.method_24022(this.lastChunk);
            for (class_3228 ticket : (class_4706)ticketEntry.getValue()) {
                if (ticket.method_14281() != this.chunkloadTicketType && ticket.method_14281() != this.predictionTicketType) continue;
                boolean tracked = false;
                if (this.predictionTask != null && ticket.method_14281() == this.predictionTicketType && this.predictionTask.loadedChunks.get(chunk) != null) {
                    if (distance > (double)(this.playerChunkLoadViewDistance * 3)) {
                        BetterChunkLoading.LOGGER.warn("Far distance ticket: " + chunk + " ticket:" + ticket);
                    }
                    tracked = true;
                }
                if (this.viewDistLoadTask != null && ticket.method_14281() == this.chunkloadTicketType && this.viewDistLoadTask.loadedChunks.get(chunk) != null) {
                    if (distance > (double)(this.playerChunkLoadViewDistance * 3)) {
                        BetterChunkLoading.LOGGER.warn("Far distance ticket: " + chunk + " ticket:" + ticket);
                    }
                    tracked = true;
                }
                if (!tracked && expiringTicketsMap.containsKey(ticketEntry.getLongKey()) && level.method_14178().field_17252.field_13894 - ticket.field_14024 + 30L + 100L > ticket.method_14281().method_20629()) {
                    tracked = true;
                }
                if (tracked) continue;
                BetterChunkLoading.LOGGER.warn("Lost ticket reference at: " + chunk + " ticket:" + ticket);
            }
        }
    }

    private class ChunkLoadingTask
    implements ITickingTask {
        private final class_1923 center;
        private class_3215 chunkSource;
        private Queue<ChunkTicketPos> chunksToTicket;
        private Map<class_1923, ChunkTicketPos> loadedChunks = new HashMap<class_1923, ChunkTicketPos>();
        private double loadSpeedModifier = 1.0;
        private double cooldownCounter = 0.0;

        private ChunkLoadingTask(class_1923 center, class_3215 chunkSource, Queue<ChunkTicketPos> chunksToTicket) {
            this.center = center;
            this.chunkSource = chunkSource;
            this.chunksToTicket = chunksToTicket;
        }

        @Override
        public boolean tick() {
            if (this.chunksToTicket == null || this.chunksToTicket.isEmpty()) {
                return true;
            }
            if (this.cooldownCounter > 1.0) {
                this.cooldownCounter -= 1.0;
                return false;
            }
            int clampedMSTP = Math.min(100, Math.max(EventHandler.MSTP, 40));
            double tpsMod = 1.0;
            tpsMod = clampedMSTP <= 40 ? 4.0 : (clampedMSTP <= 60 ? (double)(clampedMSTP - 40) / 20.0 * -3.0 + 4.0 : (double)(clampedMSTP - 60) / 40.0 * -0.8 + 1.0);
            this.cooldownCounter += (double)this.loadedChunks.size() / (100.0 * this.loadSpeedModifier * tpsMod);
            while (!this.chunksToTicket.isEmpty()) {
                class_3228 firstTicket;
                ChunkTicketPos ticketToAdd = this.chunksToTicket.poll();
                class_4706 ticketsAtPos = (class_4706)this.chunkSource.field_17252.field_13895.get(ticketToAdd.pos.method_8324());
                class_3228 class_32282 = firstTicket = ticketsAtPos != null ? (class_3228)ticketsAtPos.method_23865() : null;
                if (firstTicket != null && firstTicket.method_14283() <= class_8563.method_51828((class_3194)class_3194.field_44855) - 1) {
                    this.addTicketfor(ticketToAdd);
                    continue;
                }
                this.addTicketfor(ticketToAdd);
                break;
            }
            return this.chunksToTicket.isEmpty();
        }

        @Override
        public void cancel() {
            for (ChunkTicketPos pos : this.loadedChunks.values()) {
                this.removeTicketfor(pos);
            }
            this.chunksToTicket = null;
            this.loadedChunks = null;
            this.chunkSource = null;
        }

        private void syncWithLastTask(ChunkLoadingTask oldTask) {
            Iterator iterator = this.chunksToTicket.iterator();
            block0: while (iterator.hasNext()) {
                class_4706 ticketsAtPos;
                ChunkTicketPos oldPos;
                ChunkTicketPos ticketToAdd = (ChunkTicketPos)iterator.next();
                if (!ticketToAdd.equals(oldPos = oldTask.loadedChunks.get(ticketToAdd.pos)) || this.chunkSource != oldTask.chunkSource || (ticketsAtPos = (class_4706)this.chunkSource.field_17252.field_13895.get(ticketToAdd.pos.method_8324())) == null || ticketsAtPos.isEmpty()) continue;
                for (class_3228 ticket : ticketsAtPos) {
                    if (ticket.method_14281() != ticketToAdd.type || ticket.method_14283() != PlayerChunkData.getTicketLevelForArea(ticketToAdd.ticketArea)) continue;
                    ticket.method_23956(this.chunkSource.field_17252.field_13894);
                    this.loadedChunks.put(oldPos.pos, ticketToAdd);
                    oldTask.loadedChunks.remove(oldPos.pos);
                    iterator.remove();
                    continue block0;
                }
            }
        }

        private void addTicketfor(ChunkTicketPos ticketPos) {
            this.chunkSource.field_17252.method_17290(ticketPos.type, ticketPos.pos, PlayerChunkData.getTicketLevelForArea(ticketPos.ticketArea), (Object)ticketPos.pos);
            ChunkTicketPos prev = this.loadedChunks.put(ticketPos.pos, ticketPos);
            if (prev != null && BetterChunkLoading.IN_DEV) {
                BetterChunkLoading.LOGGER.warn("Error, re-adding ticket twice!");
            }
        }

        private void removeTicketfor(ChunkTicketPos ticketPos) {
            class_4706 ticketsAtPos = (class_4706)this.chunkSource.field_17252.field_13895.get(ticketPos.pos.method_8324());
            if (ticketsAtPos != null && !ticketsAtPos.isEmpty()) {
                if (this.chunkSource.field_17254.method_17216(ticketPos.pos.method_8324()).method_41205() == null) {
                    this.chunkSource.field_17252.method_20444(ticketPos.type, ticketPos.pos, PlayerChunkData.getTicketLevelForArea(ticketPos.ticketArea), (Object)ticketPos.pos);
                    return;
                }
                int counter = 0;
                for (class_3228 ticket : ticketsAtPos) {
                    ++counter;
                    if (ticket.method_14281() != ticketPos.type || ticket.method_14283() != PlayerChunkData.getTicketLevelForArea(ticketPos.ticketArea)) continue;
                    if (BetterChunkLoading.IN_DEV) {
                        ((Set)expiringTicketsMap.computeIfAbsent(ticketPos.pos.method_8324(), t -> new HashSet())).add(ticket);
                    }
                    ticket.method_23956(this.chunkSource.field_17252.field_13894 - ticket.method_14281().method_20629() + 30L + (long)counter);
                    return;
                }
            }
        }
    }

    private static class ChunkTicketPos {
        private double distanceToPlayer = 100.0;
        private final class_1923 pos;
        private final class_3230<class_1923> type;
        private final int ticketArea;
        private boolean ticking = false;

        ChunkTicketPos(class_1923 pos, class_3230<class_1923> type, int ticketLevel) {
            this.pos = pos;
            this.type = type;
            this.ticketArea = ticketLevel;
        }

        public double getDistanceToPlayer() {
            return this.distanceToPlayer;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ChunkTicketPos) {
                ChunkTicketPos ticketPos = (ChunkTicketPos)obj;
                return ticketPos.ticketArea == this.ticketArea && ticketPos.pos.equals((Object)this.pos) && ticketPos.type.equals(this.type) && ticketPos.ticking == this.ticking;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.type, this.ticketArea, this.ticking);
        }
    }
}

