/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster.dungeon.boss;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.AetherBossMob;
import com.aetherteam.aether.entity.ai.controller.BlankMoveControl;
import com.aetherteam.aether.entity.ai.goal.MostDamageTargetGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.BossNameGenerator;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.AvoidObstaclesGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.BackOffAfterAttackGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.CollideGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.CrushGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.SetPathUpOrDownGoal;
import com.aetherteam.aether.entity.monster.dungeon.boss.goal.SliderMoveGoal;
import com.aetherteam.aether.event.AetherEventDispatch;
import com.aetherteam.aether.network.AetherPacketHandler;
import com.aetherteam.aether.network.packet.serverbound.BossInfoPacket;
import com.aetherteam.nitrogen.entity.BossRoomTracker;
import com.aetherteam.nitrogen.network.BasePacket;
import com.aetherteam.nitrogen.network.PacketRelay;
import io.github.fabricators_of_create.porting_lib.entity.IEntityAdditionalSpawnData;
import io.github.fabricators_of_create.porting_lib.entity.PortingLibEntity;
import io.github.fabricators_of_create.porting_lib.tool.ToolActions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.pepperbell.simplenetworking.SimpleChannel;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2533;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5195;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Slider
extends class_1314
implements AetherBossMob<Slider>,
class_1569,
IEntityAdditionalSpawnData {
    private static final class_2940<Boolean> DATA_AWAKE_ID = class_2945.method_12791(Slider.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2561> DATA_BOSS_NAME_ID = class_2945.method_12791(Slider.class, (class_2941)class_2943.field_13317);
    private static final class_2940<Float> DATA_HURT_ANGLE_ID = class_2945.method_12791(Slider.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> DATA_HURT_ANGLE_X_ID = class_2945.method_12791(Slider.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> DATA_HURT_ANGLE_Z_ID = class_2945.method_12791(Slider.class, (class_2941)class_2943.field_13320);
    private static final class_5195 SLIDER_MUSIC = new class_5195((class_6880)AetherSoundEvents.MUSIC_BOSS_SLIDER.getHolder().orElseThrow(), 0, 0, true);
    public static final Map<class_2248, Function<class_2680, class_2680>> DUNGEON_BLOCK_CONVERSIONS = new HashMap<class_2248, Function<class_2680, class_2680>>(Map.ofEntries(Map.entry((class_2248)AetherBlocks.LOCKED_CARVED_STONE.get(), blockState -> ((class_2248)AetherBlocks.CARVED_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.LOCKED_SENTRY_STONE.get(), blockState -> ((class_2248)AetherBlocks.SENTRY_STONE.get()).method_9564()), Map.entry((class_2248)AetherBlocks.BOSS_DOORWAY_CARVED_STONE.get(), blockState -> class_2246.field_10124.method_9564()), Map.entry((class_2248)AetherBlocks.TREASURE_DOORWAY_CARVED_STONE.get(), blockState -> (class_2680)((class_2533)AetherBlocks.SKYROOT_TRAPDOOR.get()).method_9564().method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)blockState.method_11654((class_2769)class_2383.field_11177))))));
    private MostDamageTargetGoal mostDamageTargetGoal;
    private final class_3213 bossFight;
    @Nullable
    private BossRoomTracker<Slider> bronzeDungeon;
    private int chatCooldown;
    private class_2350 moveDirection = null;
    private int moveDelay = this.calculateMoveDelay();
    private class_243 targetPoint = null;
    private int attackCooldown = 0;

    public Slider(class_1299<? extends Slider> type, class_1937 level) {
        super(type, level);
        this.field_6207 = new BlankMoveControl((class_1308)this);
        this.bossFight = (class_3213)new class_3213(this.getBossName(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).method_5410(true);
        this.setBossFight(false);
        this.field_6194 = 50;
        this.method_5710(0.0f, 0.0f);
        this.method_5971();
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 tag) {
        this.setBossName((class_2561)BossNameGenerator.generateSliderName(this.method_6051()));
        this.method_24203(class_3532.method_15357((double)this.method_23317()), this.method_23318(), class_3532.method_15357((double)this.method_23321()));
        return spawnData;
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 400.0).method_26868(class_5134.field_23717, 64.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new CollideGoal(this));
        this.field_6201.method_6277(2, (class_1352)new CrushGoal(this));
        this.field_6201.method_6277(3, (class_1352)new BackOffAfterAttackGoal(this));
        this.field_6201.method_6277(4, (class_1352)new SetPathUpOrDownGoal(this));
        this.field_6201.method_6277(5, (class_1352)new AvoidObstaclesGoal(this));
        this.field_6201.method_6277(6, (class_1352)new SliderMoveGoal(this));
        this.mostDamageTargetGoal = new MostDamageTargetGoal((class_1308)this);
        this.field_6185.method_6277(1, (class_1352)this.mostDamageTargetGoal);
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(DATA_AWAKE_ID, (Object)false);
        this.method_5841().method_12784(DATA_BOSS_NAME_ID, (Object)class_2561.method_43470((String)"Slider"));
        this.method_5841().method_12784(DATA_HURT_ANGLE_ID, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(DATA_HURT_ANGLE_X_ID, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(DATA_HURT_ANGLE_Z_ID, (Object)Float.valueOf(0.0f));
    }

    public void method_5773() {
        class_1657 player;
        class_1309 class_13092;
        super.method_5773();
        if (!this.isAwake() || (class_13092 = this.method_5968()) instanceof class_1657 && ((player = (class_1657)class_13092).method_7337() || player.method_7325())) {
            this.method_5980(null);
        }
        this.evaporate();
        if (this.getChatCooldown() > 0) {
            --this.chatCooldown;
        }
    }

    private void evaporate() {
        Pair minMax = this.getDefaultBounds((class_1308)this);
        AetherBossMob.super.evaporate(this, (class_2338)minMax.getLeft(), (class_2338)minMax.getRight(), blockState -> true);
    }

    public void method_5958() {
        super.method_5958();
        this.bossFight.method_5408(this.method_6032() / this.method_6063());
        this.trackDungeon();
        if (this.moveDelay > 0) {
            --this.moveDelay;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        Optional<class_1309> damageResult = this.canDamageSlider(source);
        if (source.method_48789(class_8103.field_42242)) {
            class_1297 class_12972;
            super.method_5643(source, amount);
            if (!this.method_37908().method_8608() && (class_12972 = source.method_5529()) instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                this.mostDamageTargetGoal.addAggro(living, amount);
            }
        } else if (damageResult.isPresent()) {
            class_1309 attacker = damageResult.get();
            if (super.method_5643(source, amount) && this.method_6032() > 0.0f) {
                class_1297 class_12973;
                if (!this.isBossFight()) {
                    this.start();
                }
                this.method_18799(this.method_18798().method_1021(0.75));
                double a = Math.abs(this.method_19538().method_10216() - attacker.method_19538().method_10216());
                double c = Math.abs(this.method_19538().method_10215() - attacker.method_19538().method_10215());
                if (a > c) {
                    this.setHurtAngleZ(1.0f);
                    this.setHurtAngleX(0.0f);
                    if (this.method_19538().method_10216() > attacker.method_19538().method_10216()) {
                        this.setHurtAngleZ(-1.0f);
                    }
                } else {
                    this.setHurtAngleX(1.0f);
                    this.setHurtAngleZ(0.0f);
                    if (this.method_19538().method_10215() > attacker.method_19538().method_10215()) {
                        this.setHurtAngleX(-1.0f);
                    }
                }
                this.setHurtAngle(0.7f - this.method_6032() / 875.0f);
                if (!this.method_37908().method_8608() && (class_12973 = source.method_5529()) instanceof class_1309) {
                    class_1309 living = (class_1309)class_12973;
                    this.mostDamageTargetGoal.addAggro(living, amount);
                }
                return true;
            }
        }
        return false;
    }

    private Optional<class_1309> canDamageSlider(class_1282 source) {
        if (this.method_37908().method_8407() != class_1267.field_5801) {
            class_1297 class_12972 = source.method_5526();
            if (class_12972 instanceof class_1309) {
                class_1309 attacker = (class_1309)class_12972;
                if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((class_1297)attacker)) {
                    if (attacker.method_6047().canPerformAction(ToolActions.PICKAXE_DIG) || attacker.method_6047().method_31573(AetherTags.Items.SLIDER_DAMAGING_ITEMS) || attacker.method_6047().method_7951(((class_2248)AetherBlocks.CARVED_STONE.get()).method_9564())) {
                        return Optional.of(attacker);
                    }
                    return this.sendInvalidToolMessage(attacker);
                }
                this.sendTooFarMessage(attacker);
            } else {
                class_1676 projectile;
                class_1297 class_12973;
                class_12972 = source.method_5526();
                if (class_12972 instanceof class_1676 && (class_12973 = (projectile = (class_1676)class_12972).method_24921()) instanceof class_1309) {
                    class_1309 attacker = (class_1309)class_12973;
                    if (this.getDungeon() == null || this.getDungeon().isPlayerWithinRoomInterior((class_1297)attacker)) {
                        if (projectile.method_5864().method_20210(AetherTags.Entities.SLIDER_DAMAGING_PROJECTILES)) {
                            return Optional.of(attacker);
                        }
                        return this.sendInvalidToolMessage(attacker);
                    }
                    return this.sendTooFarMessage(attacker);
                }
            }
        }
        return Optional.empty();
    }

    private Optional<class_1309> sendInvalidToolMessage(class_1309 attacker) {
        if (!this.method_37908().method_8608() && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (this.getChatCooldown() <= 0) {
                if (((Boolean)AetherConfig.COMMON.reposition_slider_message.get()).booleanValue()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"gui.aether.slider.message.attack.invalid"), true);
                } else {
                    player.method_43496((class_2561)class_2561.method_43471((String)"gui.aether.slider.message.attack.invalid"));
                }
                this.setChatCooldown(15);
            }
        }
        return Optional.empty();
    }

    private Optional<class_1309> sendTooFarMessage(class_1309 attacker) {
        if (!this.method_37908().method_8608() && attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            if (this.getChatCooldown() <= 0) {
                this.displayTooFarMessage(player);
                this.setChatCooldown(15);
            }
        }
        return Optional.empty();
    }

    private void start() {
        if (this.getAwakenSound() != null) {
            this.method_5783(this.getAwakenSound(), 2.5f, 1.0f / (this.method_6051().method_43057() * 0.2f + 0.9f));
        }
        this.method_6033(this.method_6063());
        this.setAwake(true);
        this.setBossFight(true);
        if (this.getDungeon() != null) {
            this.closeRoom();
        }
        AetherEventDispatch.onBossFightStart((class_1297)this, this.getDungeon());
    }

    public void reset() {
        this.method_18799(class_243.field_1353);
        this.setAwake(false);
        this.setBossFight(false);
        this.method_5980(null);
        if (this.getDungeon() != null) {
            this.method_33574(this.getDungeon().originCoordinates());
            this.openRoom();
        }
        AetherEventDispatch.onBossFightStop((class_1297)this, this.getDungeon());
    }

    public void method_6078(class_1282 source) {
        this.method_18799(class_243.field_1353);
        this.explode();
        if (this.method_37908() instanceof class_3218) {
            this.bossFight.method_5408(this.method_6032() / this.method_6063());
            if (this.getDungeon() != null) {
                this.getDungeon().grantAdvancements(source);
                this.tearDownRoom();
            }
        }
        super.method_6078(source);
    }

    private void explode() {
        for (int i = 0; i < (this.method_6032() <= 0.0f ? 16 : 48); ++i) {
            double x = this.method_19538().method_10216() + (double)(this.method_6051().method_43057() - this.method_6051().method_43057()) * 1.5;
            double y = this.method_5829().field_1322 + 1.75 + (double)(this.method_6051().method_43057() - this.method_6051().method_43057()) * 1.5;
            double z = this.method_19538().method_10215() + (double)(this.method_6051().method_43057() - this.method_6051().method_43057()) * 1.5;
            this.method_37908().method_8406((class_2394)class_2398.field_11203, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void method_6005(double strength, double x, double z) {
    }

    public void method_5762(double x, double y, double z) {
    }

    public void method_5982() {
    }

    @Nullable
    public class_2680 convertBlock(class_2680 state) {
        return DUNGEON_BLOCK_CONVERSIONS.getOrDefault(state.method_26204(), blockState -> null).apply(state);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new BossInfoPacket.Display(this.bossFight.method_5407(), this.method_5628()), (class_3222)player);
        if (this.getDungeon() == null || this.getDungeon().isPlayerTracked((class_1657)player)) {
            this.bossFight.method_14088(player);
            AetherEventDispatch.onBossFightPlayerAdd((class_1297)this, this.getDungeon(), player);
        }
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        PacketRelay.sendToPlayer((SimpleChannel)AetherPacketHandler.INSTANCE, (BasePacket)new BossInfoPacket.Remove(this.bossFight.method_5407(), this.method_5628()), (class_3222)player);
        this.bossFight.method_14089(player);
        AetherEventDispatch.onBossFightPlayerRemove((class_1297)this, this.getDungeon(), player);
    }

    public void onDungeonPlayerAdded(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.bossFight.method_14088(serverPlayer);
            AetherEventDispatch.onBossFightPlayerAdd((class_1297)this, this.getDungeon(), serverPlayer);
        }
    }

    public void onDungeonPlayerRemoved(@Nullable class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.bossFight.method_14089(serverPlayer);
            AetherEventDispatch.onBossFightPlayerRemove((class_1297)this, this.getDungeon(), serverPlayer);
        }
    }

    public boolean isAwake() {
        return (Boolean)this.method_5841().method_12789(DATA_AWAKE_ID);
    }

    public void setAwake(boolean awake) {
        this.method_5841().method_12778(DATA_AWAKE_ID, (Object)awake);
    }

    public class_2561 getBossName() {
        if (this.method_16914()) {
            return this.method_5797();
        }
        if (!((Boolean)AetherConfig.COMMON.randomize_boss_names.get()).booleanValue()) {
            return class_2561.method_43471((String)"entity.aether.slider");
        }
        return (class_2561)this.method_5841().method_12789(DATA_BOSS_NAME_ID);
    }

    public void setBossName(class_2561 component) {
        this.method_5841().method_12778(DATA_BOSS_NAME_ID, (Object)component);
        this.bossFight.method_5413(component);
    }

    public float getHurtAngleX() {
        return ((Float)this.method_5841().method_12789(DATA_HURT_ANGLE_X_ID)).floatValue();
    }

    public void setHurtAngleX(float hurtAngleX) {
        this.method_5841().method_12778(DATA_HURT_ANGLE_X_ID, (Object)Float.valueOf(hurtAngleX));
    }

    public float getHurtAngleZ() {
        return ((Float)this.method_5841().method_12789(DATA_HURT_ANGLE_Z_ID)).floatValue();
    }

    public void setHurtAngleZ(float hurtAngleZ) {
        this.method_5841().method_12778(DATA_HURT_ANGLE_Z_ID, (Object)Float.valueOf(hurtAngleZ));
    }

    public float getHurtAngle() {
        return ((Float)this.method_5841().method_12789(DATA_HURT_ANGLE_ID)).floatValue();
    }

    public void setHurtAngle(float hurtAngle) {
        this.method_5841().method_12778(DATA_HURT_ANGLE_ID, (Object)Float.valueOf(hurtAngle));
    }

    @Nullable
    public BossRoomTracker<Slider> getDungeon() {
        return this.bronzeDungeon;
    }

    public void setDungeon(@Nullable BossRoomTracker<Slider> dungeon) {
        this.bronzeDungeon = dungeon;
    }

    public boolean isBossFight() {
        return this.bossFight.method_14093();
    }

    public void setBossFight(boolean isFighting) {
        this.bossFight.method_14091(isFighting);
    }

    @Override
    @Nullable
    public class_2960 getBossBarTexture() {
        return new class_2960("aether", "textures/gui/boss_bar_slider.png");
    }

    @Override
    @Nullable
    public class_5195 getBossMusic() {
        return SLIDER_MUSIC;
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public void setChatCooldown(int cooldown) {
        this.chatCooldown = cooldown;
    }

    public int getDeathScore() {
        return this.field_6232;
    }

    @Nullable
    public class_2350 getMoveDirection() {
        return this.moveDirection;
    }

    public void setMoveDirection(@Nullable class_2350 moveDirection) {
        this.moveDirection = moveDirection;
    }

    public int getMoveDelay() {
        return this.moveDelay;
    }

    public void setMoveDelay(int moveDelay) {
        this.moveDelay = moveDelay;
    }

    @Nullable
    public class_243 findTargetPoint() {
        class_243 pos = this.targetPoint;
        if (pos != null) {
            return pos;
        }
        class_1309 target = this.method_5968();
        return target == null ? null : target.method_19538();
    }

    @Nullable
    public class_243 getTargetPoint() {
        return this.targetPoint;
    }

    public void setTargetPoint(@Nullable class_243 targetPoint) {
        this.targetPoint = targetPoint;
    }

    public int attackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public int calculateMoveDelay() {
        return this.isCritical() ? 1 + this.method_6051().method_43048(10) : 2 + this.method_6051().method_43048(14);
    }

    public static class_2350 calculateDirection(double x, double y, double z) {
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        double absZ = Math.abs(z);
        if (absY > absX && absY > absZ) {
            return y > 0.0 ? class_2350.field_11036 : class_2350.field_11033;
        }
        if (absX > absZ) {
            return x > 0.0 ? class_2350.field_11034 : class_2350.field_11039;
        }
        return z > 0.0 ? class_2350.field_11035 : class_2350.field_11043;
    }

    public static class_238 calculateAdjacentBox(class_238 box, class_2350 direction) {
        double minX = box.field_1323;
        double minY = box.field_1322;
        double minZ = box.field_1321;
        double maxX = box.field_1320;
        double maxY = box.field_1325;
        double maxZ = box.field_1324;
        if (direction == class_2350.field_11036) {
            minY = maxY;
            maxY += 1.0;
        } else if (direction == class_2350.field_11033) {
            maxY = minY;
            minY -= 1.0;
        } else if (direction == class_2350.field_11043) {
            maxZ = minZ;
            minZ -= 1.0;
        } else if (direction == class_2350.field_11035) {
            minZ = maxZ;
            maxZ += 1.0;
        } else if (direction == class_2350.field_11034) {
            minX = maxX;
            maxX += 1.0;
        } else {
            maxX = minX;
            minX -= 1.0;
        }
        return new class_238(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public float getVelocityIncrease() {
        return this.isCritical() ? 0.045f - this.method_6032() / 10000.0f : 0.035f - this.method_6032() / 30000.0f;
    }

    public boolean isCritical() {
        return this.method_6032() <= 100.0f;
    }

    public float getMaxVelocity() {
        return 2.5f;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.setBossName(name);
    }

    protected class_3414 getAwakenSound() {
        return (class_3414)AetherSoundEvents.ENTITY_SLIDER_AWAKEN.get();
    }

    public class_3414 getCollideSound() {
        return (class_3414)AetherSoundEvents.ENTITY_SLIDER_COLLIDE.get();
    }

    public class_3414 getMoveSound() {
        return (class_3414)AetherSoundEvents.ENTITY_SLIDER_MOVE.get();
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)AetherSoundEvents.ENTITY_SLIDER_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)AetherSoundEvents.ENTITY_SLIDER_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)AetherSoundEvents.ENTITY_SLIDER_DEATH.get();
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean method_18395(class_1309 target) {
        return target.method_33190();
    }

    public boolean method_5659() {
        return true;
    }

    public float method_36454() {
        return 0.0f;
    }

    protected boolean method_5860(class_1297 vehicle) {
        return false;
    }

    public boolean method_30948() {
        return !this.isAwake();
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    public boolean method_35053() {
        return true;
    }

    protected boolean method_29920() {
        return false;
    }

    public boolean method_5862() {
        return false;
    }

    public boolean method_32314() {
        return false;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        this.addBossSaveData(tag);
        tag.method_10556("Awake", this.isAwake());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.readBossSaveData(tag);
        if (tag.method_10545("Awake")) {
            this.setAwake(tag.method_10577("Awake"));
        }
    }

    public void writeSpawnData(class_2540 buffer) {
        class_2487 tag = new class_2487();
        this.addBossSaveData(tag);
        buffer.method_10794(tag);
    }

    public void readSpawnData(class_2540 additionalData) {
        class_2487 tag = additionalData.method_10798();
        if (tag != null) {
            this.readBossSaveData(tag);
        }
    }

    public class_2596<class_2602> method_18002() {
        return PortingLibEntity.getEntitySpawningPacket((class_1297)this);
    }
}

