/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.renderers;

import java.util.ArrayList;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3i;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.renderers.ITooltipRenderer;
import toni.immersivemessages.util.AnimationUtil;
import toni.immersivemessages.util.RenderUtil;
import xyz.flirora.caxton.layout.CaxtonText;
import xyz.flirora.caxton.layout.LayoutCache;
import xyz.flirora.caxton.render.CaxtonTextRenderer;

public class CaxtonRenderer
implements ITooltipRenderer {
    @Override
    public void render(ImmersiveMessage tooltip, class_332 graphics, float deltaTicks) {
        CaxtonTextRenderer renderer = CaxtonTextRenderer.getInstance();
        ArrayList<class_5348> textLines = new ArrayList<class_5348>();
        textLines.add((class_5348)tooltip.getText());
        Vector3i size = CaxtonRenderer.wrapText(textLines, tooltip, renderer, tooltip.parent == null);
        Vector2i bgOffset = tooltip.anchor.getNormalized();
        bgOffset = bgOffset.add((Vector2ic)tooltip.align.getNormalized().mul(-1));
        if (tooltip.background) {
            RenderUtil.drawBackground(tooltip, graphics, size, bgOffset.mul(-3, new Vector2i()), deltaTicks);
        }
        int yOffset = 0;
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            class_5348 line = textLines.get(lineNumber);
            if (line != null) {
                CaxtonText text = CaxtonText.fromFormatted((class_5348)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (class_2583)tooltip.style, (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
                float lineWidth = renderer.getHandler().getWidth(text);
                lineWidth = CaxtonRenderer.adjustLineWidthForTypewriter(tooltip, graphics, lineWidth, (class_5348)(textLines.size() == 1 ? tooltip.getRawText() : line), renderer);
                graphics.method_51448().method_22903();
                if (tooltip.onPoseMessage != null) {
                    tooltip.onPoseMessage.applyPose(tooltip, tooltip.animation, graphics, bgOffset.mul(-6, new Vector2i()), tooltip.anchor, tooltip.align, lineWidth, size.y);
                } else {
                    AnimationUtil.applyPose(tooltip.animation, graphics, bgOffset.mul(-6, new Vector2i()), tooltip.anchor, tooltip.align, lineWidth, size.y);
                    graphics.method_51448().method_22904(0.0, 0.0, (double)0.1f);
                }
                if (tooltip.onRenderMessageCaxton != null) {
                    tooltip.onRenderMessageCaxton.render(tooltip, graphics, renderer, text, yOffset);
                } else {
                    renderer.draw(text, 0.0f, (float)yOffset, tooltip.animation.getColor(), tooltip.shadow, graphics.method_51448().method_23760().method_23761(), (class_4597)graphics.method_51450(), true, 0, 255, 0, 1000.0f);
                }
                graphics.method_51448().method_22909();
            }
            yOffset += 10;
        }
    }

    private static float adjustLineWidthForTypewriter(ImmersiveMessage tooltip, class_332 graphics, float lineWidth, class_5348 line, CaxtonTextRenderer renderer) {
        if (!tooltip.typewriter || tooltip.typewriterCenterAligned) {
            return lineWidth;
        }
        if (tooltip.wrapMaxWidth >= 0) {
            return tooltip.wrapMaxWidth == 0 ? (float)graphics.method_51421() / 2.0f : Math.max((float)tooltip.wrapMaxWidth, (float)graphics.method_51421() / 2.0f);
        }
        CaxtonText rawText = CaxtonText.fromFormatted((class_5348)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (class_2583)tooltip.style, (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
        return renderer.getHandler().getWidth(rawText);
    }

    private static Vector3i wrapText(ArrayList<class_5348> textLines, ImmersiveMessage tooltip, CaxtonTextRenderer renderer, boolean isCallingFromRoot) {
        if (tooltip.parent == null || isCallingFromRoot) {
            Vector3i size = RenderUtil.wrapText(textLines, tooltip.wrapMaxWidth, line -> {
                CaxtonText txt = CaxtonText.fromFormatted((class_5348)line, arg_0 -> ((CaxtonTextRenderer)renderer).getFontStorage(arg_0), (class_2583)tooltip.style, (boolean)false, (boolean)renderer.rtl, (LayoutCache)renderer.getHandler().getCache());
                return (int)renderer.getHandler().getWidth(txt);
            });
            if (tooltip.subtext != null) {
                ArrayList<class_5348> subtextLines = new ArrayList<class_5348>();
                subtextLines.add((class_5348)tooltip.subtext.getText());
                Vector3i subtextSize = CaxtonRenderer.wrapText(subtextLines, tooltip.subtext, renderer, true);
                float yOffset = Math.max(0.0f, tooltip.subtext.yLevel - tooltip.yLevel);
                float xOffset = Math.max(0.0f, tooltip.subtext.xLevel - tooltip.xLevel);
                return new Vector3i(Math.max(size.x, (int)xOffset + subtextSize.x), Math.max(size.y, (int)yOffset + subtextSize.y), Math.max(size.z, subtextSize.z));
            }
            return size;
        }
        return CaxtonRenderer.wrapText(textLines, tooltip.parent, renderer, false);
    }
}

