/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.almanac.command;

import com.frikinjay.almanac.Almanac;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class ReloadCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"almanac").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").then(class_2170.method_9244((String)"config", (ArgumentType)StringArgumentType.string()).suggests(ReloadCommand::suggestConfigs).executes(ReloadCommand::reloadConfig))).executes(ReloadCommand::listConfigs)));
    }

    private static CompletableFuture<Suggestions> suggestConfigs(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        String remaining = builder.getRemaining().toLowerCase();
        Almanac.getConfigEntryNames().stream().filter(config -> config.toLowerCase().startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    private static int listConfigs(CommandContext<class_2168> context) {
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Available configs:"), false);
        Almanac.getConfigEntryNames().forEach(configName -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("- " + configName)), false));
        return 1;
    }

    private static int reloadConfig(CommandContext<class_2168> context) {
        String configName = StringArgumentType.getString(context, (String)"config");
        try {
            Almanac.reloadConfig(configName);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Reloaded and repopulated config: " + configName)), true);
        }
        catch (Exception e) {
            Almanac.LOGGER.error("Error reloading config: " + configName, (Throwable)e);
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Error reloading config: " + configName + ". Check the server logs for details.")));
        }
        return 1;
    }
}

