/*
 * Decompiled with CFR 0.152.
 */
package fuzs.tradingpost.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.tradingpost.TradingPost;
import fuzs.tradingpost.mixin.client.accessor.ButtonAccessor;
import fuzs.tradingpost.mixin.client.accessor.MerchantScreenAccessor;
import fuzs.tradingpost.mixin.client.accessor.TradeOfferButtonAccessor;
import fuzs.tradingpost.network.client.C2SClearSlotsMessage;
import fuzs.tradingpost.world.inventory.TradingPostMenu;
import fuzs.tradingpost.world.item.trading.TradingPostOffers;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1124;
import net.minecraft.class_1129;
import net.minecraft.class_1661;
import net.minecraft.class_1723;
import net.minecraft.class_1728;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2863;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_492;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class TradingPostScreen
extends class_492 {
    public static final class_2960 MAGNIFYING_GLASS_LOCATION = new class_2960("tradingpost", "item/magnifying_glass");
    public static final class_1124.class_1125<class_1914> OFFER_SEARCH_TREE = new class_1124.class_1125();
    private static final class_2960 VILLAGER_LOCATION = new class_2960("textures/gui/container/villager2.png");
    private static final class_2960 CREATIVE_INVENTORY_LOCATION = new class_2960("textures/gui/container/creative_inventory/tab_item_search.png");
    private static final class_2561 DEPRECATED_TOOLTIP = class_2561.method_43471((String)"merchant.deprecated");
    private static final class_2561 MERCHANT_GONE = class_2561.method_43471((String)"trading_post.trader_gone");
    private class_4185[] tradeOfferButtons = new class_4185[7];
    private class_342 searchBox;
    private boolean ignoreTextInput;

    public TradingPostScreen(class_1728 container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
    }

    protected void method_25426() {
        super.method_25426();
        for (class_4185 tradeOfferButton : this.tradeOfferButtons = this.getTradeOfferButtons(this.field_33816)) {
            ((ButtonAccessor)tradeOfferButton).tradingpost$setOnPress(button -> {
                MerchantScreenAccessor accessor = (MerchantScreenAccessor)((Object)this);
                int shopItem = ((TradeOfferButtonAccessor)button).tradingpost$getIndex() + accessor.tradingpost$getScrollOff();
                class_1916 offers = this.getMenu().method_17438();
                accessor.tradingpost$setShopItem(shopItem);
                this.getMenu().method_7650(shopItem);
                this.getMenu().getTraders().setActiveOffer((class_1914)offers.get(shopItem));
                this.getMenu().method_20215(shopItem);
                this.field_22787.method_1562().method_2883((class_2596)new class_2863(offers instanceof TradingPostOffers ? ((TradingPostOffers)offers).getOrigShopItem(shopItem) : shopItem));
            });
        }
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 13, this.field_2800 + 6, 80, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search")){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.method_1885() && button == 1) {
                    this.method_1852("");
                    TradingPostScreen.this.refreshSearchResults();
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_25429((class_364)this.searchBox);
    }

    private class_4185[] getTradeOfferButtons(List<class_4068> buttons) {
        class_4185[] tradeOfferButtons = (class_4185[])buttons.stream().filter(button -> button instanceof TradeOfferButtonAccessor).map(button -> (class_4185)button).toArray(class_4185[]::new);
        if (tradeOfferButtons.length != 7) {
            TradingPost.LOGGER.warn("Unable to find enough tradeOfferButtons");
        }
        return tradeOfferButtons;
    }

    public void method_25410(class_310 mc, int newWidth, int newHeight) {
        String lastSearch = this.searchBox.method_1882();
        super.method_25410(mc, newWidth, newHeight);
        this.searchBox.method_1852(lastSearch);
        if (!this.searchBox.method_1882().isEmpty()) {
            this.refreshSearchResults();
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        class_2561 title = this.getMenu().getTraders().getDisplayName();
        if (title != null) {
            int traderLevel = ((class_1728)this.field_2797).method_19258();
            if (traderLevel > 0 && traderLevel <= 5 && ((class_1728)this.field_2797).method_19259()) {
                title = title.method_27661().method_27693(" - ").method_10852((class_2561)class_2561.method_43471((String)("merchant.level." + traderLevel)));
            }
        } else {
            title = this.field_22785;
        }
        guiGraphics.method_51439(this.field_22793, title, 49 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)title) / 2, 6, 0x404040, false);
        guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTime) {
        class_1916 merchantoffers = this.getMenu().method_17438();
        this.setButtonsActive(merchantoffers);
        int scrollOff = ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
        class_1735 hoveredSlot = this.field_2787;
        this.lock(true, merchantoffers.size(), null);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTime);
        this.lock(false, scrollOff, hoveredSlot);
        if (!merchantoffers.isEmpty()) {
            class_1914 merchantoffer;
            int shopItem = ((MerchantScreenAccessor)((Object)this)).tradingpost$getShopItem();
            if (shopItem >= 0 && shopItem < merchantoffers.size() && (merchantoffer = (class_1914)merchantoffers.get(shopItem)).method_8255()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.method_25291(VILLAGER_LOCATION, this.field_2776 + 83 + 99, this.field_2800 + 35, 0, 311.0f, 0.0f, 28, 21, 512, 256);
            }
            int width = (this.field_22789 - this.field_2792) / 2;
            int height = (this.field_22790 - this.field_2779) / 2;
            int posX = width + 5;
            int posY = height + 16 + 2;
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
            ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderScroller(guiGraphics, width, height, merchantoffers);
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                class_1914 merchantoffer2 = (class_1914)merchantoffers.get(i);
                ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderButtonArrows(guiGraphics, merchantoffer2, width, posY + 1);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    guiGraphics.method_25294(posX, posY, posX + 88, posY + 20, 0x30FF0000);
                }
                class_1799 baseCostA = merchantoffer2.method_8246();
                class_1799 costA = merchantoffer2.method_19272();
                class_1799 costB = merchantoffer2.method_8247();
                class_1799 result = merchantoffer2.method_8250();
                guiGraphics.method_51448().method_22903();
                guiGraphics.method_51448().method_46416(0.0f, 0.0f, 100.0f);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer2)) {
                    RenderSystem.depthFunc((int)516);
                    guiGraphics.method_25294(posX, posY, posX + 88, posY + 20, 0x30FFFFFF);
                    RenderSystem.depthFunc((int)515);
                }
                this.renderAndDecorateCostA(guiGraphics, posX, posY, baseCostA, costA);
                if (!costB.method_7960()) {
                    guiGraphics.method_51445(costB, posX + 35, posY + 1);
                    guiGraphics.method_51431(this.field_22793, costB, posX + 35, posY + 1);
                }
                guiGraphics.method_51445(result, posX + 68, posY + 1);
                guiGraphics.method_51431(this.field_22793, result, posX + 68, posY + 1);
                guiGraphics.method_51448().method_22909();
                posY += 20;
            }
            class_1914 activeOffer = (class_1914)merchantoffers.get(shopItem);
            if (this.getMenu().method_19259()) {
                ((MerchantScreenAccessor)((Object)this)).tradingpost$callRenderProgressBar(guiGraphics, width, height, activeOffer);
            }
            if (activeOffer.method_8255() && this.method_2378(186, 35, 22, 21, mouseX, mouseY) && this.getMenu().method_20701()) {
                guiGraphics.method_51438(this.field_22793, DEPRECATED_TOOLTIP, mouseX, mouseY);
            }
            posY = height + 16 + 2;
            int merchantoffersSize2 = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize2; ++i) {
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                class_1914 merchantoffer3 = (class_1914)merchantoffers.get(i);
                if (!this.getMenu().getTraders().checkOffer(merchantoffer3) && this.method_2378(posX, posY, 88, 19, mouseX + this.field_2776, mouseY + this.field_2800)) {
                    guiGraphics.method_51438(this.field_22793, MERCHANT_GONE, mouseX, mouseY);
                }
                posY += 20;
            }
            RenderSystem.enableDepthTest();
        }
        class_4185[] offerButtons = this.tradeOfferButtons;
        int offerButtonsLength = offerButtons.length;
        for (int i = 0; i < offerButtonsLength; ++i) {
            class_4185 button = offerButtons[i];
            if (button.field_22763 && button.method_25367()) {
                ((TradeOfferButtonAccessor)button).tradingpost$callRenderToolTip(guiGraphics, mouseX, mouseY);
            }
            button.field_22764 = i < this.getMenu().method_17438().size();
        }
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    private void renderAndDecorateCostA(class_332 guiGraphics, int posX, int posY, class_1799 baseCostA, class_1799 costA) {
        guiGraphics.method_51445(costA, posX + 5, posY + 1);
        if (baseCostA.method_7947() == costA.method_7947()) {
            guiGraphics.method_51431(this.field_22793, costA, posX + 5, posY + 1);
        } else {
            guiGraphics.method_51432(this.field_22793, baseCostA, posX + 5, posY + 1, baseCostA.method_7947() == 1 ? "1" : null);
            guiGraphics.method_51432(this.field_22793, costA, posX + 5 + 14, posY + 1, costA.method_7947() == 1 ? "1" : null);
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_51448().method_46416(0.0f, 0.0f, 300.0f);
            guiGraphics.method_25291(VILLAGER_LOCATION, posX + 5 + 7, posY + 1 + 12, 0, 0.0f, 176.0f, 9, 2, 512, 256);
            guiGraphics.method_51448().method_22909();
        }
    }

    private void setButtonsActive(class_1916 merchantoffers) {
        if (!merchantoffers.isEmpty()) {
            int merchantoffersSize = merchantoffers.size();
            for (int i = 0; i < merchantoffersSize; ++i) {
                int scrollOff = ((MerchantScreenAccessor)((Object)this)).tradingpost$getScrollOff();
                if (merchantoffers.size() > 7 && (i < scrollOff || i >= 7 + scrollOff)) continue;
                class_1914 offer = (class_1914)merchantoffers.get(i);
                this.tradeOfferButtons[i - scrollOff].field_22763 = this.getMenu().getTraders().checkOffer(offer);
            }
        }
    }

    private void lock(boolean lockOffers, int newScrollOff, class_1735 newHoveredSlot) {
        this.getMenu().lockOffers(lockOffers);
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setScrollOff(newScrollOff);
        this.field_2787 = newHoveredSlot;
    }

    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        this.renderSearchBox(guiGraphics, partialTicks, mouseX, mouseY);
        class_1058 atlasSprite = (class_1058)this.field_22787.method_1549(class_1723.field_21668).apply(MAGNIFYING_GLASS_LOCATION);
        guiGraphics.method_25298(this.field_2776, this.field_2800 + 4, 0, 16, 16, atlasSprite);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)VILLAGER_LOCATION);
    }

    private void renderSearchBox(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        guiGraphics.method_25291(CREATIVE_INVENTORY_LOCATION, i + 11, j + 4, 0, 80.0f, 4.0f, 90, 12, 256, 256);
        this.searchBox.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseKey) {
        if (this.searchBox.method_25402(mouseX, mouseY, mouseKey)) {
            this.searchBox.method_25365(true);
            return true;
        }
        return super.method_25402(mouseX, mouseY, mouseKey);
    }

    protected void method_37432() {
        this.searchBox.method_1865();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifierKeys) {
        this.ignoreTextInput = false;
        String lastSearch = this.searchBox.method_1882().trim();
        if (this.searchBox.method_25404(keyCode, scanCode, modifierKeys)) {
            if (!Objects.equals(this.searchBox.method_1882().trim(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        if (this.searchBox.method_25370() && this.searchBox.method_1885() && keyCode != 256) {
            return true;
        }
        if (this.field_22787.field_1690.field_1890.method_1417(keyCode, scanCode) && !this.searchBox.method_25370()) {
            this.ignoreTextInput = true;
            this.searchBox.method_25365(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifierKeys);
    }

    public boolean method_25400(char typedChar, int modifierKeys) {
        String lastSearch = this.searchBox.method_1882().trim();
        if (!this.ignoreTextInput && this.searchBox.method_25400(typedChar, modifierKeys)) {
            if (!Objects.equals(this.searchBox.method_1882().trim(), lastSearch)) {
                this.refreshSearchResults();
            }
            return true;
        }
        return super.method_25400(typedChar, modifierKeys);
    }

    public void refreshSearchResults() {
        class_1916 class_19162 = this.getMenu().method_17438();
        if (!(class_19162 instanceof TradingPostOffers)) {
            return;
        }
        TradingPostOffers offers = (TradingPostOffers)class_19162;
        String query = this.searchBox.method_1882().trim();
        if (query.isEmpty()) {
            offers.clearFilter();
        } else {
            class_1129 isearchtree = this.field_22787.method_1484(OFFER_SEARCH_TREE);
            offers.setFilter(isearchtree.method_4810(query.toLowerCase(Locale.ROOT)));
        }
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setScrollOff(0);
        ((MerchantScreenAccessor)((Object)this)).tradingpost$setShopItem(0);
        this.getMenu().method_7650(-1);
        this.getMenu().getTraders().setActiveOffer(null);
        this.getMenu().clearPaymentSlots();
        TradingPost.NETWORK.sendToServer((MessageV2)new C2SClearSlotsMessage());
    }

    public TradingPostMenu getMenu() {
        return (TradingPostMenu)super.method_17577();
    }
}

