/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.tools.template.screen;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.BaseWidget;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.gui.widget.WidgetRenderContext;
import com.supermartijn642.core.gui.widget.premade.TextFieldWidget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.formations.Formations;
import com.supermartijn642.formations.FormationsDev;
import com.supermartijn642.formations.tools.template.Template;
import com.supermartijn642.formations.tools.template.TemplateManager;
import com.supermartijn642.formations.tools.template.TemplateRenderer;
import com.supermartijn642.formations.tools.template.packets.CreateTemplatePacket;
import com.supermartijn642.formations.tools.template.packets.DeleteTemplatePacket;
import com.supermartijn642.formations.tools.template.screen.TemplateEditButton;
import net.minecraft.class_1074;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class TemplateEditingScreen
extends BaseWidget {
    private static final class_2960 SCREEN_BACKGROUND = Formations.location("textures/gui/template_creation_screen.png");
    private final Template template;
    private TemplateEditButton saveButton;

    public TemplateEditingScreen(Template template) {
        super(0, 0, 144, 166);
        this.template = template;
    }

    public class_2561 getNarrationMessage() {
        return this.template == null ? TextComponents.translation((String)"formations.template.edit.new_template").get() : TextComponents.translation((String)"formations.template.edit.edit_template").get();
    }

    public void addWidgets() {
        if (this.template == null) {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, "", 50, t -> {
                this.saveButton.active = Template.isValidName(t) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null;
            });
            nameField.setSuggestion(class_1074.method_4662((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.cancel").get(), TemplateEditButton.LEFT_BUTTON, () -> {
                TemplateRenderer.selectionDimension = null;
                ClientUtils.getMinecraft().method_1507(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.save").get(), TemplateEditButton.GREEN_RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(new class_238(TemplateRenderer.selectionPos1).method_991(new class_238(TemplateRenderer.selectionPos2)), name)));
                    TemplateRenderer.selectionDimension = null;
                    ClientUtils.getMinecraft().method_1507(null);
                }
            });
            this.saveButton.active = false;
            this.addWidget((Widget)this.saveButton);
        } else {
            TextFieldWidget nameField = new TextFieldWidget(8, 32, 128, 12, this.template.getName(), 50, t -> {
                this.saveButton.active = Template.isValidName(t) && (t.trim().equals(this.template.getName()) || TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(t.trim()) == null);
            });
            nameField.setSuggestion(class_1074.method_4662((String)"formations.template.edit.name_hint", (Object[])new Object[0]));
            this.addWidget((Widget)nameField);
            this.addWidget((Widget)new TemplateEditButton(0, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.delete").get(), TemplateEditButton.RED_LEFT_BUTTON, () -> {
                FormationsDev.CHANNEL.sendToServer((BasePacket)new DeleteTemplatePacket(this.template));
                ClientUtils.getMinecraft().method_1507(null);
            }));
            this.saveButton = new TemplateEditButton(72, 151, 72, 15, (class_2561)TextComponents.translation((String)"formations.template.edit.confirm").get(), TemplateEditButton.RIGHT_BUTTON, () -> {
                String name = nameField.getText().trim();
                if (name.equals(this.template.getName())) {
                    ClientUtils.getMinecraft().method_1507(null);
                } else if (Template.isValidName(name) && TemplateManager.get(ClientUtils.getWorld()).getTemplateByName(name) == null) {
                    FormationsDev.CHANNEL.sendToServer((BasePacket)new CreateTemplatePacket(Template.create(this.template.getArea(), name)));
                    ClientUtils.getMinecraft().method_1507(null);
                }
            });
            this.saveButton.active = true;
            this.addWidget((Widget)this.saveButton);
        }
    }

    public void renderBackground(WidgetRenderContext context, int mouseX, int mouseY) {
        ScreenUtils.bindTexture((class_2960)SCREEN_BACKGROUND);
        ScreenUtils.drawTexture((class_4587)context.poseStack(), (float)this.left(), (float)this.top(), (float)this.width, (float)this.height, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        super.renderBackground(context, mouseX, mouseY);
    }

    public void renderForeground(WidgetRenderContext context, int mouseX, int mouseY) {
        super.renderForeground(context, mouseX, mouseY);
        class_238 area = this.template == null ? new class_238(TemplateRenderer.selectionPos1).method_991(new class_238(TemplateRenderer.selectionPos2)) : this.template.getArea();
        class_243 center = area.method_1005();
        ScreenUtils.drawCenteredStringWithShadow((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.new_template").get(), (float)72.0f, (float)3.0f, (int)0xE0E0E0);
        ScreenUtils.drawCenteredString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.name").get(), (float)32.0f, (float)22.0f);
        ScreenUtils.drawCenteredString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.location").get(), (float)32.0f, (float)51.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.location.x").get(), (float)10.0f, (float)63.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.location.y").get(), (float)10.0f, (float)74.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.location.z").get(), (float)10.0f, (float)85.0f);
        class_327 font = ClientUtils.getFontRenderer();
        class_5250 posX = TextComponents.number((double)center.field_1352, (int)1).get();
        class_5250 posY = TextComponents.number((double)center.field_1351, (int)1).get();
        class_5250 posZ = TextComponents.number((double)center.field_1350, (int)1).get();
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)posX, (float)(132 - font.method_27525((class_5348)posX)), (float)63.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)posY, (float)(132 - font.method_27525((class_5348)posY)), (float)74.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)posZ, (float)(132 - font.method_27525((class_5348)posZ)), (float)85.0f);
        ScreenUtils.drawCenteredString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.size").get(), (float)32.0f, (float)101.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.size.x").get(), (float)10.0f, (float)113.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.size.y").get(), (float)10.0f, (float)124.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)TextComponents.translation((String)"formations.template.edit.size.z").get(), (float)10.0f, (float)135.0f);
        class_5250 sizeX = TextComponents.number((int)((int)area.method_17939())).get();
        class_5250 sizeY = TextComponents.number((int)((int)area.method_17940())).get();
        class_5250 sizeZ = TextComponents.number((int)((int)area.method_17941())).get();
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)sizeX, (float)(132 - font.method_27525((class_5348)sizeX)), (float)113.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)sizeY, (float)(132 - font.method_27525((class_5348)sizeY)), (float)124.0f);
        ScreenUtils.drawString((class_4587)context.poseStack(), (class_2561)sizeZ, (float)(132 - font.method_27525((class_5348)sizeZ)), (float)135.0f);
    }
}

