/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.structure.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.formations.FormationsStructures;
import com.supermartijn642.formations.structure.BlockInstance;
import com.supermartijn642.formations.structure.FormationsStructureProcessor;
import com.supermartijn642.formations.structure.processors.EnchantmentHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_7714;
import org.jetbrains.annotations.NotNull;

public class ChiseledBookshelfProcessor
extends class_3491
implements FormationsStructureProcessor {
    public static final Codec<ChiseledBookshelfProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("slotFillChance", (Object)Float.valueOf(0.4f)).forGetter(p -> Float.valueOf(p.slotFillChance)), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("levels").forGetter(p -> p.minLevels != p.maxLevels || p.minLevels == 10 ? Optional.empty() : Optional.of(p.maxLevels)), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("min_levels").forGetter(p -> p.minLevels == p.maxLevels ? Optional.empty() : Optional.of(p.minLevels)), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("max_levels").forGetter(p -> p.minLevels == p.maxLevels ? Optional.empty() : Optional.of(p.maxLevels)), (App)Codec.BOOL.optionalFieldOf("allow_curses", (Object)true).forGetter(p -> p.allowCurses)).apply((Applicative)instance, (slotFillChance, levels, minLevels, maxLevels, allowCurses) -> {
        if (minLevels.isPresent() && maxLevels.isPresent()) {
            return new ChiseledBookshelfProcessor(slotFillChance.floatValue(), (Integer)minLevels.get(), (Integer)maxLevels.get(), (boolean)allowCurses);
        }
        int l = levels.orElse(10);
        return new ChiseledBookshelfProcessor(slotFillChance.floatValue(), l, l, (boolean)allowCurses);
    }));
    private final float slotFillChance;
    private final int minLevels;
    private final int maxLevels;
    private final boolean allowCurses;

    public ChiseledBookshelfProcessor(float slotFillChance, int minLevels, int maxLevels, boolean allowCurses) {
        this.slotFillChance = slotFillChance;
        this.minLevels = minLevels;
        this.maxLevels = maxLevels;
        this.allowCurses = allowCurses;
    }

    public ChiseledBookshelfProcessor(float slotFillChance) {
        this(slotFillChance, 10, 10, true);
    }

    @Override
    @NotNull
    public BlockInstance processBlock(BlockInstance block, class_2338 pos, class_4538 level, class_2338 piecePosition, class_2338 structurePosition, class_3492 placeSettings, Map<class_2338, BlockInstance> pieceBlocks) {
        class_2680 state = block.state();
        if (state != null && state.method_27852(class_2246.field_40276)) {
            class_2371 books = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
            if (block.nbt() != null) {
                class_1262.method_5429((class_2487)block.nbt(), (class_2371)books);
            }
            class_5819 random = placeSettings.method_15115(pos);
            for (int i = 0; i < 6; ++i) {
                if (!((class_1799)books.get(i)).method_7960() || !(random.method_43057() < this.slotFillChance)) continue;
                int levels = random.method_43048(this.maxLevels - this.minLevels + 1) + this.minLevels;
                class_1799 book = EnchantmentHelper.getRandomEnchantedBook(levels, true, this.allowCurses, true, random, level.method_45162());
                books.set(i, (Object)book);
                state = (class_2680)state.method_11657((class_2769)class_7714.field_41308.get(i), (Comparable)Boolean.valueOf(true));
            }
            class_2487 nbt = block.nbt() == null ? new class_2487() : block.nbt().method_10553();
            class_1262.method_5427((class_2487)nbt, (class_2371)books, (boolean)true);
            return new BlockInstance(state, nbt);
        }
        return block;
    }

    protected class_3828<?> method_16772() {
        return FormationsStructures.CHISELED_BOOKSHELF_PROCESSOR;
    }
}

