/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.formations.generators;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3491;
import net.minecraft.class_3785;
import net.minecraft.class_3828;

public abstract class TemplatePoolGenerator
extends ResourceGenerator {
    private final Map<class_2960, TemplatePoolBuilder> builders = new HashMap<class_2960, TemplatePoolBuilder>();

    public TemplatePoolGenerator(String modid, ResourceCache cache) {
        super(modid, cache);
    }

    public void save() {
        for (TemplatePoolBuilder pool : this.builders.values()) {
            List<class_2960> missingStructures = pool.entries.stream().map(entry -> entry.location).collect(Collectors.toSet()).stream().filter(structure -> !this.cache.doesResourceExist(ResourceType.DATA, structure.method_12836(), "structures", structure.method_12832(), ".nbt")).toList();
            if (!missingStructures.isEmpty()) {
                throw new RuntimeException("Template pool '" + String.valueOf(pool.identifier) + "' has missing structure nbt files: " + String.valueOf(missingStructures));
            }
            JsonObject json = new JsonObject();
            json.addProperty("fallback", pool.fallbackPool.toString());
            JsonArray entries = new JsonArray(pool.entries.size());
            for (TemplatePoolEntryBuilder entry2 : pool.entries) {
                JsonObject entryJson = new JsonObject();
                entryJson.addProperty("weight", (Number)entry2.weight);
                JsonObject propertyJson = new JsonObject();
                propertyJson.addProperty("element_type", entry2.type.toString());
                propertyJson.addProperty("location", entry2.location.toString());
                propertyJson.addProperty("projection", entry2.projection.method_15434());
                if (entry2.groundLevel != null) {
                    propertyJson.addProperty("ground_level", (Number)entry2.groundLevel);
                }
                if (entry2.processors.isEmpty()) {
                    propertyJson.addProperty("processors", "minecraft:empty");
                } else {
                    JsonArray processors = new JsonArray(entry2.processors.size());
                    entry2.processors.stream().map(processor -> (JsonElement)class_3828.field_25013.encodeStart((DynamicOps)JsonOps.INSTANCE, processor).getOrThrow(false, s -> {})).forEach(arg_0 -> ((JsonArray)processors).add(arg_0));
                    propertyJson.add("processors", (JsonElement)processors);
                }
                entryJson.add("element", (JsonElement)propertyJson);
                entries.add((JsonElement)entryJson);
            }
            json.add("elements", (JsonElement)entries);
            this.cache.saveJsonResource(ResourceType.DATA, json, pool.identifier.method_12836(), "worldgen/template_pool", pool.identifier.method_12832());
        }
    }

    public TemplatePoolBuilder pool(String namespace, String identifier) {
        return this.builders.computeIfAbsent(new class_2960(namespace, identifier), i -> new TemplatePoolBuilder(this.modid, (class_2960)i));
    }

    public TemplatePoolBuilder pool(String identifier) {
        return this.pool(this.modid, identifier);
    }

    public String getName() {
        return this.modName + " Template Pool Generator";
    }

    public static class TemplatePoolBuilder {
        private final String owningModid;
        private final class_2960 identifier;
        private class_2960 fallbackPool = new class_2960("minecraft", "empty");
        private final List<TemplatePoolEntryBuilder> entries = new ArrayList<TemplatePoolEntryBuilder>();

        private TemplatePoolBuilder(String owningModid, class_2960 identifier) {
            this.owningModid = owningModid;
            this.identifier = identifier;
        }

        public TemplatePoolBuilder fallback(String namespace, String identifier) {
            this.fallbackPool = new class_2960(namespace, identifier);
            return this;
        }

        public TemplatePoolBuilder entry(String template, Consumer<TemplatePoolEntryBuilder> entryBuilder) {
            TemplatePoolEntryBuilder entry = new TemplatePoolEntryBuilder(new class_2960(this.owningModid, template));
            entryBuilder.accept(entry);
            this.entries.add(entry);
            return this;
        }

        public TemplatePoolBuilder commonEntries(BiConsumer<String, TemplatePoolEntryBuilder> entryBuilder, String ... templates) {
            Arrays.stream(templates).forEach(t -> this.entry((String)t, o -> entryBuilder.accept((String)t, (TemplatePoolEntryBuilder)o)));
            return this;
        }

        public TemplatePoolBuilder commonEntries(Consumer<TemplatePoolEntryBuilder> entryBuilder, String ... templates) {
            return this.commonEntries((String template, TemplatePoolEntryBuilder builder) -> entryBuilder.accept((TemplatePoolEntryBuilder)builder), templates);
        }
    }

    public static class TemplatePoolEntryBuilder {
        private final class_2960 location;
        private final List<class_3491> processors = new ArrayList<class_3491>();
        private class_3785.class_3786 projection = class_3785.class_3786.field_16687;
        private Integer groundLevel;
        private class_2960 type = new class_2960("formations", "single_pool_element");
        private int weight = 1;

        private TemplatePoolEntryBuilder(class_2960 location) {
            this.location = location;
        }

        public TemplatePoolEntryBuilder processors(class_3491 ... processors) {
            this.processors.addAll(Arrays.asList(processors));
            return this;
        }

        public TemplatePoolEntryBuilder rigidProjection() {
            this.projection = class_3785.class_3786.field_16687;
            return this;
        }

        public TemplatePoolEntryBuilder terrainMatchingProjection() {
            this.projection = class_3785.class_3786.field_16686;
            return this;
        }

        public TemplatePoolEntryBuilder groundLevel(int level) {
            this.groundLevel = level;
            return this;
        }

        public TemplatePoolEntryBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }
    }
}

