/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.nbtedit;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconWithBorder;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTEditorScreen
extends AbstractThreePanelScreen<NBTPanel> {
    private static final int TOP_PANEL_H = 20;
    public static final Icon NBT_BYTE = NBTEditorScreen.getIcon("byte");
    public static final Icon NBT_SHORT = NBTEditorScreen.getIcon("short");
    public static final Icon NBT_INT = NBTEditorScreen.getIcon("int");
    public static final Icon NBT_LONG = NBTEditorScreen.getIcon("long");
    public static final Icon NBT_FLOAT = NBTEditorScreen.getIcon("float");
    public static final Icon NBT_DOUBLE = NBTEditorScreen.getIcon("double");
    public static final Icon NBT_STRING = NBTEditorScreen.getIcon("string");
    public static final Icon NBT_LIST = NBTEditorScreen.getIcon("list");
    public static final Icon NBT_LIST_CLOSED = NBTEditorScreen.getIcon("list").combineWith(NBTEditorScreen.getIcon("map_closed").withColor(Color4I.rgba(-1056964609)));
    public static final Icon NBT_LIST_OPEN = NBTEditorScreen.getIcon("list");
    public static final Icon NBT_MAP = NBTEditorScreen.getIcon("map");
    public static final Icon NBT_MAP_CLOSED = NBTEditorScreen.getIcon("map").combineWith(NBTEditorScreen.getIcon("map_closed").withColor(Color4I.rgba(-1056964609)));
    public static final Icon NBT_MAP_OPEN = NBTEditorScreen.getIcon("map");
    public static final Icon NBT_BYTE_ARRAY = NBTEditorScreen.getIcon("byte_array");
    public static final Icon NBT_BYTE_ARRAY_CLOSED = NBTEditorScreen.getIcon("byte_array_closed");
    public static final Icon NBT_BYTE_ARRAY_OPEN = NBTEditorScreen.getIcon("byte_array_open");
    public static final Icon NBT_INT_ARRAY = NBTEditorScreen.getIcon("int_array");
    public static final Icon NBT_INT_ARRAY_CLOSED = NBTEditorScreen.getIcon("int_array_closed");
    public static final Icon NBT_INT_ARRAY_OPEN = NBTEditorScreen.getIcon("int_array_open");
    private final class_2487 info;
    private final NBTCallback callback;
    private final ButtonNBTMap buttonNBTRoot;
    private ButtonNBT selected;
    public final Panel panelTopLeft;
    public final Panel panelTopRight;
    private boolean accepted = false;

    public NBTEditorScreen(class_2487 info, class_2487 nbt, NBTCallback callback) {
        this.info = info;
        this.callback = callback;
        this.panelTopLeft = new TopLeftPanel();
        this.panelTopRight = new TopRightPanel();
        this.buttonNBTRoot = new ButtonNBTMap(this.mainPanel, null, this.getInfoTitle(info), nbt);
        this.buttonNBTRoot.updateChildren(true);
        this.buttonNBTRoot.setCollapsedTree(true);
        this.buttonNBTRoot.setCollapsed(false);
        this.setSelected(this.buttonNBTRoot);
    }

    private String getInfoTitle(class_2487 info) {
        if (info.method_10545("title")) {
            class_5250 title = class_2561.class_2562.method_10877((String)info.method_10558("title"));
            if (title != null) {
                return title.getString();
            }
        } else if (info.method_10545("type")) {
            return info.method_10558("type").toUpperCase();
        }
        return "ROOT";
    }

    private void collapseAll(boolean collapse) {
        for (Widget w : ((NBTPanel)this.mainPanel).getWidgets()) {
            if (!(w instanceof ButtonNBTCollection)) continue;
            ButtonNBTCollection collection = (ButtonNBTCollection)w;
            collection.setCollapsedTree(collapse);
        }
        ((NBTPanel)this.mainPanel).refreshWidgets();
    }

    @Override
    protected void doCancel() {
        this.getGui().closeGui();
    }

    @Override
    protected void doAccept() {
        this.accepted = true;
        this.getGui().closeGui();
    }

    @Override
    protected int getTopPanelHeight() {
        return 20;
    }

    @Override
    protected NBTPanel createMainPanel() {
        return new NBTPanel();
    }

    @Override
    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    private void setSelected(@NotNull ButtonNBT newSelected) {
        ButtonNBT prevSelected = this.selected;
        this.selected = newSelected;
        if (prevSelected != null) {
            prevSelected.updateTitle();
        }
        this.selected.updateTitle();
    }

    @Override
    public boolean onInit() {
        return this.setSizeProportional(0.75f, 0.9f);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.callback.handle(this.accepted, this.buttonNBTRoot.map);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if ((key.is(257) || key.is(335)) && key.modifiers.shift()) {
            this.doAccept();
            return true;
        }
        if (key.is(334) || key.is(61)) {
            this.collapseAll(false);
        } else if (key.is(45) || key.is(333)) {
            this.collapseAll(true);
        } else if (key.is(67) && key.modifiers.control()) {
            this.copyToClipboard();
        }
        return false;
    }

    private void copyToClipboard() {
        NBTEditorScreen.setClipboardString(this.selected.toNBT().toString());
        SimpleToast.info((class_2561)class_2561.method_43471((String)"ftblibrary.gui.nbt_copied"), (class_2561)class_2561.method_43470((String)" "));
    }

    private ButtonNBT makeNBTButton(ButtonNBTCollection parent, String key) {
        class_2520 nbt = parent.getTag(key);
        return switch (nbt.method_10711()) {
            case 10 -> new ButtonNBTMap(this.mainPanel, parent, key, (class_2487)nbt);
            case 9 -> new ButtonNBTList(this.mainPanel, parent, key, (class_2499)nbt);
            case 7 -> new ButtonNBTByteArray(this.mainPanel, parent, key, (class_2479)nbt);
            case 11 -> new ButtonNBTIntArray(this.mainPanel, parent, key, (class_2495)nbt);
            default -> new ButtonBasicTag(this.mainPanel, parent, key, nbt);
        };
    }

    public SimpleButton newTag(Panel panel, String title, Icon icon, Supplier<class_2520> supplier) {
        return new SimpleButton(panel, (class_2561)class_2561.method_43470((String)title), icon, (btn, mb) -> {
            if (this.selected instanceof ButtonNBTMap) {
                StringConfig value = new StringConfig(Pattern.compile("^.+$"));
                EditStringConfigOverlay<String> overlay = new EditStringConfigOverlay<String>(this, value, arg_0 -> this.lambda$newTag$0(value, (Supplier)supplier, arg_0));
                overlay.setPos(btn.posX, btn.posY + btn.height + 4);
                this.getGui().pushModalPanel(overlay);
            } else if (this.selected instanceof ButtonNBTCollection) {
                ((ButtonNBTCollection)this.selected).setTag("-1", (class_2520)supplier.get());
                this.selected.updateChildren(false);
                ((NBTPanel)this.mainPanel).refreshWidgets();
            }
        }){

            @Override
            public void drawBackground(class_332 stack, Theme theme, int x, int y, int w, int h) {
                IconWithBorder.BUTTON_ROUND_GRAY.draw(stack, x, y, w, h);
            }
        };
    }

    private static Icon getIcon(String name) {
        return Icon.getIcon("ftblibrary:textures/icons/nbt/" + name + ".png");
    }

    private /* synthetic */ void lambda$newTag$0(StringConfig value, Supplier supplier, boolean accepted) {
        if (accepted && !((String)value.getValue()).isEmpty()) {
            ((ButtonNBTCollection)this.selected).setTag((String)value.getValue(), (class_2520)supplier.get());
            this.selected.updateChildren(false);
            ((NBTPanel)this.mainPanel).refreshWidgets();
        }
        this.openGui();
    }

    public static interface NBTCallback {
        public void handle(boolean var1, class_2487 var2);
    }

    private class TopLeftPanel
    extends Panel {
        public TopLeftPanel() {
            super(NBTEditorScreen.this.topPanel);
        }

        @Override
        public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
        }

        @Override
        public void addWidgets() {
            List<Widget> addBtns;
            this.add(new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"selectServer.delete"), NBTEditorScreen.this.selected == NBTEditorScreen.this.buttonNBTRoot ? Icons.BIN.combineWith((Icon)Color4I.rgba(-1071636448)) : Icons.BIN, (widget, button) -> this.deleteTag()));
            boolean canRename = NBTEditorScreen.this.selected.parent instanceof ButtonNBTMap;
            Icon renameIcon = Icons.NOTES;
            this.add(new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftblibrary.gui.edit_tag_name"), canRename ? renameIcon : renameIcon.combineWith((Icon)Color4I.rgba(-1071636448)), (btn, mb) -> {
                if (canRename) {
                    this.getGui().pushModalPanel(this.makeRenameOverlay(btn));
                }
            }));
            if (NBTEditorScreen.this.selected instanceof ButtonBasicTag) {
                this.add(new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftblibrary.gui.edit_tag_value"), Icons.FEATHER, (widget, button) -> ((ButtonBasicTag)NBTEditorScreen.this.selected).edit()));
            }
            if (!(addBtns = this.buildAddButtons()).isEmpty()) {
                TextField addLabel = new TextField(this).setText((class_2561)class_2561.method_43470((String)"   ").method_10852((class_2561)class_2561.method_43471((String)"gui.add"))).addFlags(32);
                this.add(addLabel);
                this.addAll(addBtns);
            }
        }

        private void deleteTag() {
            if (NBTEditorScreen.this.selected != NBTEditorScreen.this.buttonNBTRoot && NBTEditorScreen.this.selected.parent != null) {
                NBTEditorScreen.this.selected.parent.setTag(NBTEditorScreen.this.selected.key, null);
                NBTEditorScreen.this.selected.parent.updateChildren(false);
                NBTEditorScreen.this.setSelected(NBTEditorScreen.this.selected.parent);
                ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
                NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            }
        }

        @NotNull
        private List<Widget> buildAddButtons() {
            ArrayList<Widget> addBtns = new ArrayList<Widget>();
            if (NBTEditorScreen.this.selected.canCreateNew(10)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Compound", NBT_MAP, class_2487::new));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(9)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "List", NBT_LIST, class_2499::new));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(8)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "String", NBT_STRING, () -> class_2519.method_23256((String)"")));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(1)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Byte", NBT_BYTE, () -> class_2481.method_23233((byte)0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(2)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Short", NBT_SHORT, () -> class_2516.method_23254((short)0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(3)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Int", NBT_INT, () -> class_2497.method_23247((int)0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(4)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Long", NBT_LONG, () -> class_2503.method_23251((long)0L)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(5)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Float", NBT_FLOAT, () -> class_2494.method_23244((float)0.0f)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(6)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Double", NBT_DOUBLE, () -> class_2489.method_23241((double)0.0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(7)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Byte Array", NBT_BYTE_ARRAY, () -> new class_2479(new byte[0])));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(11)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Int Array", NBT_INT_ARRAY, () -> new class_2495(new int[0])));
            }
            return addBtns;
        }

        @NotNull
        private EditStringConfigOverlay<String> makeRenameOverlay(SimpleButton button) {
            StringConfig value = new StringConfig();
            if (NBTEditorScreen.this.selected != null) {
                value.setValue(NBTEditorScreen.this.selected.key);
            }
            EditStringConfigOverlay<String> overlay = new EditStringConfigOverlay<String>(this, value, accepted -> {
                if (accepted && !((String)value.getValue()).isEmpty() && NBTEditorScreen.this.selected.parent != null) {
                    ButtonNBTCollection parent = NBTEditorScreen.this.selected.parent;
                    class_2520 nbt = parent.getTag(NBTEditorScreen.this.selected.key);
                    parent.setTag(NBTEditorScreen.this.selected.key, null);
                    parent.setTag((String)value.getValue(), nbt);
                    parent.updateChildren(false);
                    NBTEditorScreen.this.setSelected(parent.children.get(value.getValue()));
                    ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
                }
                this.getGui().openGui();
            }, (class_2561)class_2561.method_43470((String)"New name"));
            overlay.setPos(button.posX, button.posY + button.height + 4);
            overlay.setExtraZlevel(300);
            return overlay;
        }

        @Override
        public void alignWidgets() {
            this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
            this.widgets.forEach(w -> w.setY((20 - w.height) / 2 - 2));
        }
    }

    private class TopRightPanel
    extends Panel {
        public TopRightPanel() {
            super(NBTEditorScreen.this.topPanel);
        }

        @Override
        public void addWidgets() {
            this.add(new SimpleButton((Panel)this, List.of(class_2561.method_43471((String)"gui.copy"), TextComponentUtils.hotkeyTooltip("Ctrl + C")), ItemIcon.getItemIcon(class_1802.field_8407), (widget, button) -> NBTEditorScreen.this.copyToClipboard()));
            this.add(new SimpleButton((Panel)this, List.of(class_2561.method_43471((String)"gui.collapse_all"), TextComponentUtils.hotkeyTooltip("-")), Icons.DOWN, (widget, button) -> NBTEditorScreen.this.collapseAll(true)));
            this.add(new SimpleButton((Panel)this, List.of(class_2561.method_43471((String)"gui.expand_all"), TextComponentUtils.hotkeyTooltip("="), TextComponentUtils.hotkeyTooltip("+")), Icons.UP, (widget, button) -> NBTEditorScreen.this.collapseAll(false)));
        }

        @Override
        public void alignWidgets() {
            this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
        }
    }

    public class ButtonNBTMap
    extends ButtonNBTCollection {
        private final class_2487 map;
        private Icon hoverIcon;

        public ButtonNBTMap(@Nullable Panel panel, ButtonNBTCollection parent, String key, class_2487 map) {
            super(panel, parent, key, NBT_MAP_OPEN, NBT_MAP_CLOSED);
            this.hoverIcon = Icon.empty();
            this.map = map;
        }

        @Override
        public void updateTitle() {
            this.setTitle((class_2561)class_2561.method_43470((String)this.key).method_27692(this.isSelected() ? class_124.field_1060 : class_124.field_1077));
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            this.map.method_10541().stream().sorted(StringUtils.IGNORE_CASE_COMPARATOR).forEach(key -> {
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, (String)key);
                this.children.put(key, nbt);
                nbt.updateChildren(first);
            });
            this.updateHoverIcon();
            if (first && !this.hoverIcon.isEmpty()) {
                this.setCollapsed(true);
            }
        }

        private void updateHoverIcon() {
            class_1799 stack;
            this.hoverIcon = Icon.empty();
            if (this.map.method_10573("id", 8) && this.map.method_10573("Count", 99) && !(stack = class_1799.method_7915((class_2487)this.map)).method_7960()) {
                this.hoverIcon = ItemIcon.getItemIcon(stack);
            }
            this.setWidth(12 + NBTEditorScreen.this.getTheme().getStringWidth((class_5348)this.getTitle()) + (this.hoverIcon.isEmpty() ? 0 : 10));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            class_2499 infoList;
            if (this == NBTEditorScreen.this.buttonNBTRoot && !(infoList = NBTEditorScreen.this.info.method_10554("text", 8)).isEmpty()) {
                list.add((class_2561)class_2561.method_43471((String)"gui.info").method_27693(":"));
                for (int i = 0; i < infoList.size(); ++i) {
                    class_5250 component = class_2561.class_2562.method_10877((String)infoList.method_10608(i));
                    if (component == null) continue;
                    list.add((class_2561)component);
                }
            }
        }

        @Override
        public void draw(class_332 pose, Theme theme, int x, int y, int w, int h) {
            super.draw(pose, theme, x, y, w, h);
            if (!this.hoverIcon.isEmpty()) {
                this.hoverIcon.draw(pose, x + 12 + theme.getStringWidth((class_5348)this.getTitle()), y + 1, 8, 8);
            }
        }

        @Override
        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of(this.hoverIcon.getIngredient(), this, true);
        }

        @Override
        public class_2520 getTag(String key) {
            return this.map.method_10580(key);
        }

        @Override
        public void setTag(String key, @Nullable class_2520 base) {
            if (base != null) {
                this.map.method_10566(key, base);
            } else {
                this.map.method_10551(key);
            }
            this.updateHoverIcon();
            if (this.parent != null) {
                this.parent.setTag(this.key, (class_2520)this.map);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return true;
        }

        @Override
        public class_2487 toNBT() {
            class_2487 nbt = this.map.method_10553();
            if (this == NBTEditorScreen.this.buttonNBTRoot) {
                class_2499 infoList1 = new class_2499();
                class_2499 infoList0 = NBTEditorScreen.this.info.method_10554("text", 8);
                if (!infoList0.isEmpty()) {
                    for (int i = 0; i < infoList0.size(); ++i) {
                        class_5250 component = class_2561.class_2562.method_10877((String)infoList0.method_10608(i));
                        if (component == null) continue;
                        infoList1.add((Object)class_2519.method_23256((String)component.getString()));
                    }
                    nbt.method_10566("_", (class_2520)infoList1);
                }
            }
            return nbt;
        }
    }

    public abstract class ButtonNBTCollection
    extends ButtonNBT {
        public boolean collapsed;
        public final Map<String, ButtonNBT> children;
        public final Icon iconOpen;
        public final Icon iconClosed;

        public ButtonNBTCollection(@Nullable Panel panel, ButtonNBTCollection parent, String key, Icon open, Icon closed) {
            super(panel, parent, key);
            this.iconOpen = open;
            this.iconClosed = closed;
            this.setCollapsed(false);
            this.setWidth(this.width + 2 + NBTEditorScreen.this.getTheme().getStringWidth(key));
            this.children = new LinkedHashMap<String, ButtonNBT>();
            this.updateTitle();
        }

        @Override
        public void addChildren() {
            if (!this.collapsed) {
                for (ButtonNBT button : this.children.values()) {
                    ((NBTPanel)NBTEditorScreen.this.mainPanel).add(button);
                    button.addChildren();
                }
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseX() <= this.getX() + this.height) {
                this.setCollapsed(!this.collapsed);
                ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
            } else {
                NBTEditorScreen.this.setSelected(this);
                NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            }
        }

        @Override
        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver()) {
                this.setCollapsed(!this.collapsed);
                ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
                return true;
            }
            return false;
        }

        public void setCollapsed(boolean c) {
            this.collapsed = c;
            this.setIcon(this.collapsed ? this.iconClosed : this.iconOpen);
        }

        public void setCollapsedTree(boolean c) {
            this.setCollapsed(c);
            for (ButtonNBT button : this.children.values()) {
                if (!(button instanceof ButtonNBTCollection)) continue;
                ButtonNBTCollection collection = (ButtonNBTCollection)button;
                collection.setCollapsedTree(c);
            }
        }

        public abstract class_2520 getTag(String var1);

        public abstract void setTag(String var1, @Nullable class_2520 var2);
    }

    public abstract class ButtonNBT
    extends Button {
        protected final ButtonNBTCollection parent;
        protected String key;

        public ButtonNBT(@Nullable Panel panel, ButtonNBTCollection parent, String key) {
            super(panel);
            this.parent = parent;
            this.key = key;
            this.setPosAndSize(parent == null ? 0 : parent.posX + 10, 0, 10, 10);
            this.setTitle((class_2561)class_2561.method_43470((String)this.key));
        }

        public abstract class_2487 toNBT();

        public void updateChildren(boolean first) {
        }

        public void addChildren() {
        }

        public boolean canCreateNew(int id) {
            return false;
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }

        @Override
        public void draw(class_332 pose, Theme theme, int x, int y, int w, int h) {
            if (this.isSelected()) {
                Color4I.WHITE.withAlpha(64).draw(pose, x, y, w, h);
            }
            IconWithBorder.BUTTON_ROUND_GRAY.draw(pose, x + 1, y + 1, 8, 8);
            this.drawIcon(pose, theme, x + 1, y + 1, 8, 8);
            theme.drawString(pose, this.getTitle(), x + 11, y + 1);
        }

        public boolean isSelected() {
            return this == NBTEditorScreen.this.selected;
        }

        public void updateTitle() {
        }
    }

    protected class NBTPanel
    extends Panel {
        public NBTPanel() {
            super(NBTEditorScreen.this);
        }

        @Override
        public void addWidgets() {
            this.add(NBTEditorScreen.this.buttonNBTRoot);
            NBTEditorScreen.this.buttonNBTRoot.addChildren();
        }

        @Override
        public void alignWidgets() {
            this.align(WidgetLayout.VERTICAL);
        }
    }

    private class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private CustomTopPanel() {
            super(NBTEditorScreen.this);
        }

        @Override
        public void addWidgets() {
            this.add(NBTEditorScreen.this.panelTopLeft);
            this.add(NBTEditorScreen.this.panelTopRight);
        }

        @Override
        public void alignWidgets() {
            NBTEditorScreen.this.panelTopLeft.setPosAndSize(0, 2, NBTEditorScreen.this.panelTopLeft.width, 20);
            NBTEditorScreen.this.panelTopRight.setPosAndSize(this.width - NBTEditorScreen.this.panelTopRight.width, 2, 0, 20);
            NBTEditorScreen.this.panelTopRight.alignWidgets();
        }
    }

    public class ButtonNBTList
    extends ButtonNBTCollection {
        private final class_2499 list;

        public ButtonNBTList(Panel panel, ButtonNBTCollection p, String key, class_2499 l) {
            super(panel, p, key, NBT_LIST_OPEN, NBT_LIST_CLOSED);
            this.list = l;
        }

        @Override
        public void updateTitle() {
            this.setTitle((class_2561)class_2561.method_43470((String)this.key).method_27692(this.isSelected() ? class_124.field_1054 : class_124.field_1065));
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public class_2520 getTag(String key) {
            return this.list.method_10534(Integer.parseInt(key));
        }

        @Override
        public void setTag(String key, @Nullable class_2520 base) {
            int id = Integer.parseInt(key);
            if (id == -1) {
                if (base != null) {
                    this.list.add((Object)base);
                }
            } else if (base != null) {
                this.list.method_10606(id, base);
            } else {
                this.list.method_10536(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (class_2520)this.list);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return this.list.isEmpty() || this.list.method_10601() == id;
        }

        @Override
        public class_2487 toNBT() {
            return (class_2487)class_156.method_654((Object)new class_2487(), t -> t.method_10566(this.key, (class_2520)this.list));
        }
    }

    public class ButtonNBTByteArray
    extends ButtonNBTCollection {
        private final ByteArrayList list;

        public ButtonNBTByteArray(Panel panel, ButtonNBTCollection p, String key, class_2479 l) {
            super(panel, p, key, NBT_BYTE_ARRAY_OPEN, NBT_BYTE_ARRAY_CLOSED);
            this.list = new ByteArrayList(l.method_10521());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public class_2520 getTag(String key) {
            return class_2481.method_23233((byte)this.list.getByte(Integer.parseInt(key)));
        }

        @Override
        public void setTag(String key, @Nullable class_2520 base) {
            int id = Integer.parseInt(key);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((class_2514)base).method_10698());
                }
            } else if (base != null) {
                this.list.set(id, ((class_2514)base).method_10698());
            } else {
                this.list.removeByte(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (class_2520)new class_2479(this.list.toByteArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 1;
        }

        @Override
        public class_2487 toNBT() {
            return (class_2487)class_156.method_654((Object)new class_2487(), t -> t.method_10566(this.key, (class_2520)new class_2479(this.list.toByteArray())));
        }
    }

    public class ButtonNBTIntArray
    extends ButtonNBTCollection {
        private final IntArrayList list;

        public ButtonNBTIntArray(Panel panel, ButtonNBTCollection parent, String key, class_2495 l) {
            super(panel, parent, key, NBT_INT_ARRAY_OPEN, NBT_INT_ARRAY_CLOSED);
            this.list = new IntArrayList(l.method_10588());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public class_2520 getTag(String key) {
            return class_2497.method_23247((int)this.list.getInt(Integer.parseInt(key)));
        }

        @Override
        public void setTag(String key, @Nullable class_2520 base) {
            int id = Integer.parseInt(key);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((class_2514)base).method_10701());
                }
            } else if (base != null) {
                this.list.set(id, ((class_2514)base).method_10701());
            } else {
                this.list.rem(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (class_2520)new class_2495(this.list.toIntArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 3;
        }

        @Override
        public class_2487 toNBT() {
            return (class_2487)class_156.method_654((Object)new class_2487(), t -> t.method_10566(this.key, (class_2520)new class_2495(this.list.toIntArray())));
        }
    }

    public class ButtonBasicTag
    extends ButtonNBT {
        private class_2520 nbt;

        public ButtonBasicTag(Panel panel, ButtonNBTCollection parent, String key, class_2520 nbt) {
            super(panel, parent, key);
            this.nbt = nbt;
            switch (this.nbt.method_10711()) {
                case 1: {
                    this.setIcon(NBT_BYTE);
                    break;
                }
                case 2: {
                    this.setIcon(NBT_SHORT);
                    break;
                }
                case 3: {
                    this.setIcon(NBT_INT);
                    break;
                }
                case 4: {
                    this.setIcon(NBT_LONG);
                    break;
                }
                case 5: {
                    this.setIcon(NBT_FLOAT);
                    break;
                }
                case 6: 
                case 99: {
                    this.setIcon(NBT_DOUBLE);
                    break;
                }
                case 8: {
                    this.setIcon(NBT_STRING);
                }
            }
            this.parent.setTag(this.key, this.nbt);
            this.updateTitle();
        }

        @Override
        public void updateTitle() {
            String value = switch (this.nbt.method_10711()) {
                case 1, 2, 3 -> ((class_2514)this.nbt).method_10701();
                case 4 -> ((class_2514)this.nbt).method_10699();
                case 5, 6, 99 -> ((class_2514)this.nbt).method_10697();
                case 8 -> this.nbt.method_10714();
                default -> "";
            };
            class_124 k = this.isSelected() ? class_124.field_1068 : class_124.field_1080;
            class_124 v = this.isSelected() ? class_124.field_1075 : class_124.field_1062;
            class_5250 text = class_2561.method_43470((String)this.key).method_27692(k).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)value.toString()).method_27692(v));
            this.setTitle((class_2561)text);
            this.setWidth(12 + NBTEditorScreen.this.getTheme().getStringWidth((class_5348)text));
        }

        @Override
        public void onClicked(MouseButton button) {
            NBTEditorScreen.this.setSelected(this);
            NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            if (button.isRight()) {
                this.edit();
            }
        }

        @Override
        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver()) {
                this.edit();
                return true;
            }
            return false;
        }

        public void edit() {
            switch (this.nbt.method_10711()) {
                case 1: 
                case 2: 
                case 3: {
                    this.openEditOverlay(new IntConfig(Integer.MIN_VALUE, Integer.MAX_VALUE), ((class_2514)this.nbt).method_10701());
                    break;
                }
                case 4: {
                    this.openEditOverlay(new LongConfig(Long.MIN_VALUE, Long.MAX_VALUE), ((class_2514)this.nbt).method_10699());
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    this.openEditOverlay(new DoubleConfig(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), ((class_2514)this.nbt).method_10697());
                    break;
                }
                case 8: {
                    this.openEditOverlay(new StringConfig(), this.nbt.method_10714());
                }
            }
        }

        private <T> void openEditOverlay(ConfigFromString<T> config, T val) {
            config.setValue(val);
            this.getGui().pushModalPanel(new EditStringConfigOverlay<T>(this.getGui(), config, accepted -> this.onCallback(config, accepted)).atMousePosition());
        }

        public void onCallback(ConfigValue<?> value, boolean accepted) {
            if (accepted) {
                switch (this.nbt.method_10711()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.nbt = class_2497.method_23247((int)((Number)value.getValue()).intValue());
                        break;
                    }
                    case 4: {
                        this.nbt = class_2503.method_23251((long)((Number)value.getValue()).longValue());
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 99: {
                        this.nbt = class_2489.method_23241((double)((Number)value.getValue()).doubleValue());
                        break;
                    }
                    case 8: {
                        this.nbt = class_2519.method_23256((String)value.getValue().toString());
                    }
                }
                this.parent.setTag(this.key, this.nbt);
                this.updateTitle();
            }
            NBTEditorScreen.this.openGui();
        }

        @Override
        public class_2487 toNBT() {
            return (class_2487)class_156.method_654((Object)new class_2487(), t -> t.method_10566(this.key, this.nbt));
        }
    }
}

