/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration.stages;

import dev.ftb.mods.ftblibrary.FTBLibrary;
import dev.ftb.mods.ftblibrary.integration.stages.EntityTagStageProvider;
import dev.ftb.mods.ftblibrary.integration.stages.StageProvider;
import java.util.Objects;

public enum StageHelper {
    INSTANCE;

    private static final StageProvider FALLBACK;
    private StageProvider activeImpl = null;

    public static StageHelper getInstance() {
        return INSTANCE;
    }

    public void setProviderImpl(StageProvider newProvider) {
        if (this.activeImpl != null) {
            FTBLibrary.LOGGER.warn("Overriding existing game stages provider: {} -> {}", (Object)this.activeImpl.getName(), (Object)newProvider.getName());
        } else {
            FTBLibrary.LOGGER.info("Setting game stages provider implementation to: {}", (Object)newProvider.getName());
        }
        this.activeImpl = newProvider;
    }

    public StageProvider getProvider() {
        return Objects.requireNonNullElse(this.activeImpl, FALLBACK);
    }

    static {
        FALLBACK = new EntityTagStageProvider();
    }
}

