/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining.logic;

import com.google.common.collect.Sets;
import com.illusivesoulworks.veinmining.VeinMiningMod;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.logic.BlockProcessor;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class VeinMiningLogic {
    private static final class_2350[] CARDINAL_DIRECTIONS = new class_2350[]{class_2350.field_11033, class_2350.field_11036, class_2350.field_11034, class_2350.field_11039, class_2350.field_11043, class_2350.field_11035};

    public static void veinMine(class_3222 playerEntity, class_2338 pos, class_2680 sourceState) {
        boolean tooSlow;
        class_3218 world = playerEntity.method_51469();
        class_1799 stack = playerEntity.method_6047();
        class_2248 source = sourceState.method_26204();
        boolean notCorrect = (Boolean)VeinMiningConfig.SERVER.requireCorrectTool.get() != false && !Services.PLATFORM.canHarvestDrops(playerEntity, sourceState);
        float destroySpeed = stack.method_7924(sourceState);
        boolean bl = tooSlow = destroySpeed > 0.0f && (double)destroySpeed < (Double)VeinMiningConfig.SERVER.requiredDestroySpeed.get();
        if (notCorrect || tooSlow) {
            return;
        }
        int veiningLevels = class_1890.method_8225((class_1887)VeinMiningMod.ENCHANTMENT, (class_1799)stack);
        int maxBlocks = (Integer)VeinMiningConfig.SERVER.maxBlocksBase.get() + (Integer)VeinMiningConfig.SERVER.maxBlocksPerLevel.get() * veiningLevels;
        int maxDistance = 200;
        if (maxBlocks <= 0) {
            return;
        }
        int blocks = 1;
        HashSet visited = Sets.newHashSet((Object[])new class_2338[]{pos});
        LinkedList<class_3545<class_2338, Integer>> candidates = new LinkedList<class_3545<class_2338, Integer>>();
        VeinMiningLogic.addValidNeighbors(candidates, pos, 1);
        while (!candidates.isEmpty() && blocks < maxBlocks) {
            class_3545<class_2338, Integer> candidate = candidates.poll();
            class_2338 blockPos = (class_2338)candidate.method_15442();
            int blockDistance = (Integer)candidate.method_15441();
            if (VeinMiningLogic.stopVeining(stack)) {
                return;
            }
            class_2680 blockState = world.method_8320(blockPos);
            if (!visited.add(blockPos) || !BlockProcessor.isValidTarget(blockState, source) || !Services.PLATFORM.harvest(playerEntity, blockPos, pos)) continue;
            if (blockDistance < maxDistance) {
                VeinMiningLogic.addValidNeighbors(candidates, blockPos, blockDistance + 1);
            }
            ++blocks;
        }
    }

    private static boolean stopVeining(class_1799 stack) {
        return stack.method_7963() && (Boolean)VeinMiningConfig.SERVER.limitedByDurability.get() != false && (stack.method_7919() == stack.method_7936() || (Boolean)VeinMiningConfig.SERVER.preventToolDestruction.get() != false && stack.method_7919() == stack.method_7936() - 1);
    }

    private static void addValidNeighbors(LinkedList<class_3545<class_2338, Integer>> candidates, class_2338 source, int distance) {
        if (((Boolean)VeinMiningConfig.SERVER.diagonalMining.get()).booleanValue()) {
            class_2338[] blockPositions;
            class_2338 up = source.method_10084();
            class_2338 down = source.method_10074();
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)up, (Object)distance));
            candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)down, (Object)distance));
            for (class_2338 blockPos : blockPositions = new class_2338[]{up, down, source}) {
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10067(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10078(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10095(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10072(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10095().method_10067(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10095().method_10078(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10072().method_10067(), (Object)distance));
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)blockPos.method_10072().method_10078(), (Object)distance));
            }
        } else {
            for (class_2350 direction : CARDINAL_DIRECTIONS) {
                candidates.add((class_3545<class_2338, Integer>)new class_3545((Object)source.method_10093(direction), (Object)distance));
            }
        }
    }
}

