/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support.feature;

import com.google.common.collect.Sets;
import com.unascribed.fabrication.EarlyAgnos;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationResourcePack;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.Feature;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.util.HashSet;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_5352;

public abstract class ResourcePackFeature
implements Feature,
class_3285 {
    private final String configKey;
    private final String path;
    public boolean active = false;

    public ResourcePackFeature(String path) {
        this.configKey = "*." + path;
        this.path = path;
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            this.initClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void initClient() {
        HashSet providers = FabRefl.getProviders(class_310.method_1551().method_1520());
        try {
            providers.add((class_3285)this);
        }
        catch (UnsupportedOperationException e) {
            FabLog.info("Injecting mutable resource pack provider set, as no-one else has yet.");
            providers = Sets.newHashSet(providers);
            providers.add(this);
            FabRefl.setProviders(class_310.method_1551().method_1520(), providers);
        }
    }

    public void method_14453(Consumer<class_3288> consumer) {
        if (this.active) {
            consumer.accept(class_3288.method_45275((String)(MixinConfigPlugin.MOD_NAME + " " + this.path), (class_2561)class_2561.method_43470((String)("Internal " + MixinConfigPlugin.MOD_NAME + " resources")), (boolean)true, s -> new FabricationResourcePack(this.path), (class_3264)class_3264.field_14188, (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)class_5352.field_25348));
        }
    }

    @Override
    public void apply() {
        this.active = true;
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            this.reloadClient();
        }
    }

    @Environment(value=EnvType.CLIENT)
    private void reloadClient() {
        if (class_310.method_1551().method_1478() != null) {
            class_310.method_1551().method_1521();
        }
    }

    @Override
    public boolean undo() {
        this.active = false;
        if (EarlyAgnos.getCurrentEnv() == Env.CLIENT) {
            this.reloadClient();
        }
        return true;
    }

    @Override
    public String getConfigKey() {
        return this.configKey;
    }
}

