/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.context.CommandContext;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.FeaturesFile;
import com.unascribed.fabrication.features.FeatureFabricationCommand;
import com.unascribed.fabrication.loaders.LoaderFScript;
import com.unascribed.fabrication.support.ConfigPredicates;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import tf.ssf.sfort.script.Default;
import tf.ssf.sfort.script.PredicateProvider;
import tf.ssf.sfort.script.StitchedPredicateProvider;

public class OptionalFScript {
    public static ImmutableMap<String, PredicateProvider<?>> predicateProviders;

    public static void set(CommandContext<? extends class_2172> c, String configKey, String script) {
        OptionalFScript.set(configKey, script, (Exception e) -> FeatureFabricationCommand.sendFeedback(c, class_2561.method_43470((String)("Failed to set script for " + configKey + "\n" + e.getLocalizedMessage())), true));
    }

    public static boolean set(String configKey, String script, class_3222 spe) {
        Optional<Exception> err = OptionalFScript.setScript(configKey, script);
        err.ifPresent(e -> spe.method_43496((class_2561)class_2561.method_43470((String)("Failed to set script for " + configKey + "\n" + e.getLocalizedMessage()))));
        return !err.isPresent();
    }

    public static void set(String configKey, String script, Consumer<Exception> errReporter) {
        OptionalFScript.setScript(configKey, script).ifPresent(errReporter);
    }

    public static void restoreDefault(String configKey) {
        configKey = FabConf.remap(configKey);
        ConfigPredicates.remove(configKey, 2);
        LoaderFScript.put(configKey, null);
    }

    public static void reload() {
        for (Map.Entry<String, String> entry : LoaderFScript.getMap().entrySet()) {
            OptionalFScript.setScript(entry.getKey(), entry.getValue());
        }
    }

    private static Optional<Exception> setScript(String configKey, String script) {
        configKey = FabConf.remap(configKey);
        try {
            PredicateProvider predicateProvider = (PredicateProvider)predicateProviders.get((Object)configKey);
            if (predicateProvider == null) {
                return Optional.of(new Exception("No predicate provider exists for specified key"));
            }
            Predicate predicate = predicateProvider.parse(script);
            if (predicate == null) {
                return Optional.of(new Exception("FScript returned null, likely because an invalid script was given"));
            }
            ConfigPredicates.put(configKey, predicate, 2);
            LoaderFScript.put(configKey, script);
        }
        catch (Exception e) {
            FabLog.error("Failed to set script for " + configKey, e);
            return Optional.of(e);
        }
        return Optional.empty();
    }

    static {
        HashMap<String, PredicateProvider> providers = new HashMap<String, PredicateProvider>();
        for (Map.Entry entry : FeaturesFile.getAll().entrySet()) {
            FeaturesFile.FeatureEntry f = (FeaturesFile.FeatureEntry)entry.getValue();
            if (f.fscript == null) continue;
            PredicateProvider p = (PredicateProvider)Default.getDefaultMap().get(f.fscript);
            if (!f.extraFscript.isEmpty()) {
                p = new StitchedPredicateProvider(p);
                for (Map.Entry extraEntry : f.extraFscript.entrySet()) {
                    ((StitchedPredicateProvider)p).addEmbed((PredicateProvider)Default.getDefaultMap().get(extraEntry.getKey()), (String)((Map.Entry)extraEntry.getValue()).getKey(), (String)((Map.Entry)extraEntry.getValue()).getValue());
                }
            }
            providers.put((String)entry.getKey(), p);
        }
        predicateProviders = ImmutableMap.copyOf(providers);
    }
}

