/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import java.util.Locale;

public class ConfigValues {

    public static enum ResolvedFeature {
        TRUE(true, Feature.TRUE),
        FALSE(false, Feature.FALSE),
        DEFAULT_TRUE(true, Feature.UNSET),
        DEFAULT_FALSE(false, Feature.UNSET),
        BANNED(false, Feature.BANNED);

        public final boolean value;
        public final Feature feature;

        private ResolvedFeature(boolean value, Feature feature) {
            this.value = value;
            this.feature = feature;
        }
    }

    public static enum Feature {
        UNSET,
        TRUE,
        FALSE,
        BANNED;

        public static final String[] vals_true_false;
        public static final String[] vals_unset_true_false;
        public static final String[] vals_unset_true_false_banned;

        public boolean resolve(boolean def) {
            if (this == TRUE) {
                return true;
            }
            if (this == FALSE || this == BANNED) {
                return false;
            }
            return def;
        }

        public ResolvedFeature resolveSemantically(boolean def) {
            if (this == BANNED) {
                return ResolvedFeature.BANNED;
            }
            if (this == TRUE) {
                return ResolvedFeature.TRUE;
            }
            if (this == FALSE) {
                return ResolvedFeature.FALSE;
            }
            return def ? ResolvedFeature.DEFAULT_TRUE : ResolvedFeature.DEFAULT_FALSE;
        }

        public static Feature parse(String s) {
            return Feature.valueOf(s.toUpperCase(Locale.ROOT));
        }

        static {
            vals_true_false = new String[]{"true", "false"};
            vals_unset_true_false = new String[]{"unset", "true", "false"};
            vals_unset_true_false_banned = new String[]{"unset", "true", "false", "banned"};
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Category {
        GREEN{

            @Override
            public int getColor() {
                return -7617718;
            }

            @Override
            public String displayDesc() {
                return "Enables nothing by default. Build your own.";
            }
        }
        ,
        DARK{

            @Override
            public int getColor() {
                return -11652050;
            }

            @Override
            public String displayDesc() {
                return "Enable all but extra.";
            }
        }
        ,
        ASH{

            @Override
            public int getColor() {
                return -5592406;
            }

            @Override
            public String displayDesc() {
                return "Really enable everything.";
            }
        };

        public static final String[] vals;

        public abstract int getColor();

        public static boolean isCategory(String str) {
            try {
                return Category.parse(str) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public static String[] stringValues() {
            Category[] values = Category.values();
            String[] out = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                out[i] = values[i].name().toLowerCase(Locale.ROOT);
            }
            return out;
        }

        public static Category parse(String s) {
            switch (s = s.toUpperCase(Locale.ROOT)) {
                case "TRUE": {
                    return DARK;
                }
                case "BANNED": 
                case "UNSET": 
                case "FALSE": {
                    return GREEN;
                }
            }
            return Category.valueOf(s);
        }

        public String displayName() {
            return this.name().charAt(0) + this.name().substring(1).toLowerCase(Locale.ROOT);
        }

        public abstract String displayDesc();

        static {
            vals = Category.stringValues();
        }
    }
}

