/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.support;

import com.google.common.collect.ImmutableMap;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_8103;

public class ConfigPredicates {
    private static final Map<String, AtomicReference<Predicate<?>>> active;
    private static final Map<String, Feature> idle;
    public static final ImmutableMap<String, Predicate<?>> defaults;

    public static <T> Predicate<T> getFinalPredicate(String configKey) {
        configKey = FabConf.remap(configKey);
        AtomicReference<Predicate<?>> ref = ConfigPredicates.getOrCreateActive(configKey);
        return test -> {
            Predicate p = (Predicate)ref.get();
            if (p == null) {
                return true;
            }
            try {
                return p.test(test);
            }
            catch (Exception e) {
                FabLog.error("ConfigPredicates failed to cast predicate", e);
                return true;
            }
        };
    }

    public static synchronized AtomicReference<Predicate<?>> getOrCreateActive(String configKey) {
        AtomicReference<Predicate<Object>> ret = active.get(configKey);
        if (ret != null) {
            return ret;
        }
        ret = new AtomicReference();
        active.put(configKey, ret);
        return ret;
    }

    public static void put(String configKey, Predicate<?> predicate) {
        ConfigPredicates.put(configKey, predicate, 0);
    }

    public static void put(String configKey, Predicate<?> predicate, int level) {
        if (!idle.containsKey(configKey = FabConf.remap(configKey))) {
            idle.put(configKey, new Feature());
        }
        if (idle.get(configKey).add(predicate, level)) {
            ConfigPredicates.getOrCreateActive(configKey).set(predicate);
        }
    }

    public static void remove(String configKey) {
        ConfigPredicates.remove(configKey, 0);
    }

    public static void remove(String configKey, int level) {
        if (idle.containsKey(configKey = FabConf.remap(configKey))) {
            AtomicReference<Predicate<?>> ref = ConfigPredicates.getOrCreateActive(configKey);
            Predicate rtrn = idle.get(configKey).remove(level, ref.get());
            ref.set(rtrn == null ? (Predicate)defaults.get((Object)configKey) : rtrn);
        }
    }

    static {
        idle = new HashMap<String, Feature>();
        HashMap defaultsMap = new HashMap();
        defaultsMap.put(FabConf.remap("*.shield_stagger"), l -> ((class_1282)l.get(1)).method_48789(class_8103.field_42249));
        defaultsMap.put(FabConf.remap("*.faulty_shields"), l -> ((class_1282)l.get(1)).method_48789(class_8103.field_42247));
        defaultsMap.put(FabConf.remap("*.brittle_shields"), l -> ((class_1282)l.get(1)).method_48789(class_8103.field_42249));
        defaultsMap.put(FabConf.remap("*.no_sprint"), entity -> !entity.method_5869());
        defaultsMap.put(FabConf.remap("*.swap_conflicting_enchants"), class_1297::method_21751);
        defaultsMap.put(FabConf.remap("*.velocity_based_fall_damage_reset"), entity -> !(entity instanceof class_1309) || !((class_1309)entity).method_6101());
        defaultsMap.put(FabConf.remap("*.cactus_walk_doesnt_hurt_with_boots"), livingEntity -> !livingEntity.method_6118(class_1304.field_6166).method_7960());
        defaultsMap.put(FabConf.remap("*.cactus_brush_doesnt_hurt_with_chest"), livingEntity -> !livingEntity.method_6118(class_1304.field_6174).method_7960());
        defaultsMap.put(FabConf.remap("*.creepers_explode_when_on_fire"), livingEntity -> livingEntity.method_20802() > 0 && !livingEntity.method_6059(class_1294.field_5918));
        defaultsMap.put(FabConf.remap("*.cactus_punching_hurts"), serverPlayerEntity -> serverPlayerEntity.method_6047().method_7960());
        defaultsMap.put(FabConf.remap("*.feather_falling_five"), livingEntity -> class_1890.method_8225((class_1887)class_1893.field_9129, (class_1799)livingEntity.method_6118(class_1304.field_6166)) >= 5);
        defaultsMap.put(FabConf.remap("*.feather_falling_five_damages_boots"), livingEntity -> class_1890.method_8225((class_1887)class_1893.field_9129, (class_1799)livingEntity.method_6118(class_1304.field_6166)) >= 5);
        defaults = ImmutableMap.copyOf(defaultsMap);
        active = defaults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new AtomicReference<Predicate>((Predicate)e.getValue())));
    }

    private static class Feature {
        Integer i = Integer.MIN_VALUE;
        Map<Integer, Predicate<?>> map = new HashMap();

        private Feature() {
        }

        public boolean add(Predicate<?> predicate, int level) {
            this.map.put(level, predicate);
            if (this.i <= level) {
                this.i = level;
                return true;
            }
            return false;
        }

        public Predicate<?> remove(int level, Predicate<?> defaultVal) {
            this.map.remove(level);
            if (this.map.isEmpty()) {
                this.i = Integer.MIN_VALUE;
                return null;
            }
            if (this.i <= level) {
                this.i = this.map.keySet().stream().max(Comparator.comparingInt(i -> i)).get();
                return this.map.get(this.i);
            }
            return defaultVal;
        }
    }
}

