/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.z_combined.note_block_tuning;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.math.IntMath;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.Collection;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2428;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(anyConfigAvailable={"*.exact_note_block_tuning", "*.note_block_notes", "*.reverse_note_block_tuning"})
@Mixin(value={class_2428.class})
public abstract class MixinNoteBlock {
    private static final String FABRICATION$NOTE_COLORS = "aa66cccccdd559999bbbaaaaa";
    private static final ImmutableList<String> FABRICATION$NOTES = ImmutableList.of((Object)"F#", (Object)"G", (Object)"G#", (Object)"A", (Object)"A#", (Object)"B", (Object)"C", (Object)"C#", (Object)"D", (Object)"D#", (Object)"E", (Object)"F", (Object[])new String[0]);
    private static final ImmutableMap<class_2766, String> FABRICATION$INSTRUMENT_NAMES = ImmutableMap.builder().put((Object)class_2766.field_12651, (Object)"String Bass").put((Object)class_2766.field_12643, (Object)"Snare Drum").put((Object)class_2766.field_12645, (Object)"Clicks & Sticks").put((Object)class_2766.field_12653, (Object)"Bass Drum/Kick").put((Object)class_2766.field_12644, (Object)"Bells/Glockenspiel").put((Object)class_2766.field_12650, (Object)"Flute").put((Object)class_2766.field_12647, (Object)"Chimes").put((Object)class_2766.field_12654, (Object)"Guitar").put((Object)class_2766.field_12655, (Object)"Xylophone").put((Object)class_2766.field_18284, (Object)"Vibraphone").put((Object)class_2766.field_18285, (Object)"Cow Bell").put((Object)class_2766.field_18286, (Object)"Didgeridoo").put((Object)class_2766.field_18287, (Object)"Square Wave").put((Object)class_2766.field_18288, (Object)"Banjo").put((Object)class_2766.field_18289, (Object)"Electric Piano").put((Object)class_2766.field_12648, (Object)"Piano").build();
    private static final ImmutableMap<class_2766, Integer> FABRICATION$INSTRUMENT_OCTAVES = ImmutableMap.builder().put((Object)class_2766.field_12643, (Object)3).put((Object)class_2766.field_12645, (Object)5).put((Object)class_2766.field_12653, (Object)-1).put((Object)class_2766.field_12651, (Object)1).put((Object)class_2766.field_12644, (Object)5).put((Object)class_2766.field_12650, (Object)4).put((Object)class_2766.field_12647, (Object)5).put((Object)class_2766.field_12654, (Object)2).put((Object)class_2766.field_12655, (Object)5).put((Object)class_2766.field_18284, (Object)3).put((Object)class_2766.field_18285, (Object)4).put((Object)class_2766.field_18286, (Object)1).put((Object)class_2766.field_18287, (Object)3).put((Object)class_2766.field_18288, (Object)3).put((Object)class_2766.field_18289, (Object)3).put((Object)class_2766.field_12648, (Object)3).build();
    private static final ImmutableMap<class_2766, Integer> FABRICATION$INSTRUMENT_OFFSETS = ImmutableMap.builder().put((Object)class_2766.field_12643, (Object)-2).put((Object)class_2766.field_12645, (Object)-9).build();

    @Shadow
    protected abstract void method_10367(@Nullable class_1297 var1, class_2680 var2, class_1937 var3, class_2338 var4);

    @FabInject(at={@At(value="HEAD")}, method={"onUse(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;"}, cancellable=true)
    public void onUseHead(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, CallbackInfoReturnable<class_1269> ci) {
        if (!world.field_9236) {
            class_1799 stack;
            if (FabConf.isEnabled("*.exact_note_block_tuning") && (stack = player.method_5998(hand)).method_7909() == class_1802.field_8600) {
                int nw;
                int cur = (Integer)state.method_11654((class_2769)class_2428.field_11324);
                if (cur != (nw = Math.min(24, stack.method_7947() - 1))) {
                    int dist = nw > cur ? nw - cur : nw + (24 - cur);
                    state = (class_2680)state.method_11657((class_2769)class_2428.field_11324, (Comparable)Integer.valueOf(nw));
                    world.method_8652(pos, state, 3);
                    player.method_7339(class_3468.field_15393, dist);
                }
                this.method_10367((class_1297)player, state, world, pos);
                this.fabrication$informNote(player, state);
                ci.setReturnValue((Object)class_1269.field_21466);
                return;
            }
            if (FabConf.isEnabled("*.reverse_note_block_tuning") && player.method_5715()) {
                state = MixinNoteBlock.cycleBackward(state, class_2428.field_11324);
                world.method_8652(pos, state, 3);
                this.method_10367((class_1297)player, state, world, pos);
                player.method_7281(class_3468.field_15393);
                this.fabrication$informNote(player, state);
                ci.setReturnValue((Object)class_1269.field_21466);
                return;
            }
        }
    }

    @FabInject(at={@At(value="RETURN")}, method={"onUse(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;Lnet/minecraft/util/hit/BlockHitResult;)Lnet/minecraft/util/ActionResult;"})
    public void onUseReturn(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, CallbackInfoReturnable<class_1269> ci) {
        this.fabrication$informNote(player, world.method_8320(pos));
    }

    @FabInject(at={@At(value="HEAD")}, method={"onBlockBreakStart(Lnet/minecraft/block/BlockState;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/player/PlayerEntity;)V"})
    public void onBlockBreakStart(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, CallbackInfo ci) {
        this.fabrication$informNote(player, state);
    }

    private void fabrication$informNote(class_1657 player, class_2680 state) {
        if (!player.method_37908().field_9236 && FabConf.isEnabled("*.note_block_notes")) {
            Object octaveStr;
            int note = (Integer)state.method_11654((class_2769)class_2428.field_11324);
            class_2766 instrument = (class_2766)state.method_11654((class_2769)class_2428.field_11325);
            char color = FABRICATION$NOTE_COLORS.charAt(note);
            if (FABRICATION$INSTRUMENT_OFFSETS.containsKey((Object)instrument)) {
                note += ((Integer)FABRICATION$INSTRUMENT_OFFSETS.get((Object)instrument)).intValue();
            }
            int baseOctave = (Integer)FABRICATION$INSTRUMENT_OCTAVES.get((Object)instrument);
            if (note < 0) {
                --baseOctave;
                note = 12 + note;
            }
            String noteStr = (String)FABRICATION$NOTES.get(IntMath.mod((int)note, (int)FABRICATION$NOTES.size()));
            if (baseOctave == -1) {
                noteStr = "";
                octaveStr = "";
            } else {
                octaveStr = note / 12 + baseOctave + " ";
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7" + color + noteStr + (String)octaveStr + (String)FABRICATION$INSTRUMENT_NAMES.get((Object)instrument) + " (" + String.valueOf(state.method_11654((class_2769)class_2428.field_11324)) + ")")), true);
        }
    }

    @Unique
    private static <S extends class_2680, T extends Comparable<T>> S cycleBackward(S s, class_2769<T> property) {
        return (S)((class_2680)s.method_11657(property, MixinNoteBlock.getPrev(property.method_11898(), s.method_11654(property))));
    }

    @Unique
    private static <T> T getPrev(Collection<T> values, T value) {
        T prev = null;
        for (T next : values) {
            if (next.equals(value) && prev != null) {
                return prev;
            }
            prev = next;
        }
        return prev;
    }
}

