/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.b_utility.taggable_players;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.features.FeatureTaggablePlayers;
import com.unascribed.fabrication.interfaces.TaggablePlayer;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@EligibleIf(configAvailable="*.taggable_players")
@Mixin(value={class_3222.class})
public abstract class MixinServerPlayerEntity
extends class_1657
implements TaggablePlayer {
    private final Set<String> fabrication$tags = new HashSet<String>();
    private Map<String, Boolean> fabrication$tagsOverride = null;

    public MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public Set<String> fabrication$getTags() {
        return ImmutableSet.copyOf(this.fabrication$tags);
    }

    @Override
    public void fabrication$clearTags() {
        this.fabrication$tags.clear();
    }

    @Override
    public void fabrication$setTag(String tag, boolean enabled) {
        if (enabled) {
            this.fabrication$tags.add(tag);
        } else {
            this.fabrication$tags.remove(tag);
        }
    }

    @Override
    public boolean fabrication$hasTag(String tag) {
        Boolean b;
        if (this.fabrication$tagsOverride != null && (b = this.fabrication$tagsOverride.get(tag)) != null) {
            return b;
        }
        return this.fabrication$tags.contains(tag);
    }

    @Override
    public Boolean fabrication$getTagOverride(String tag) {
        if (this.fabrication$tagsOverride == null) {
            return null;
        }
        return this.fabrication$tagsOverride.get(tag);
    }

    @FabInject(at={@At(value="TAIL")}, method={"<init>(Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/server/world/ServerWorld;Lcom/mojang/authlib/GameProfile;)V"})
    public void fabrication$genOverride(MinecraftServer server, class_3218 world, GameProfile profile, CallbackInfo ci) {
        Map<String, Boolean> mapName = FeatureTaggablePlayers.playerNameOverrideMap.get(profile.getName());
        Map<String, Boolean> mapUuid = FeatureTaggablePlayers.playerUUIDOverrideMap.get(profile.getId());
        if (mapUuid != null || mapName != null) {
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            if (mapName != null) {
                map.putAll(mapName);
            }
            if (mapUuid != null) {
                map.putAll(mapUuid);
            }
            this.fabrication$tagsOverride = map;
        }
    }

    @FabInject(at={@At(value="HEAD")}, method={"copyFrom(Lnet/minecraft/server/network/ServerPlayerEntity;Z)V"})
    public void copyFrom(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        this.fabrication$tags.clear();
        this.fabrication$tags.addAll(((TaggablePlayer)oldPlayer).fabrication$getTags());
    }

    @FabInject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToTag(class_2487 tag, CallbackInfo ci) {
        class_2499 li = new class_2499();
        for (String pt : this.fabrication$tags) {
            li.add((Object)class_2519.method_23256((String)pt));
        }
        if (!li.isEmpty()) {
            tag.method_10566("fabrication:Tags", (class_2520)li);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
        this.fabrication$tags.clear();
        class_2499 li = tag.method_10554("fabrication:Tags", 8);
        for (int i = 0; i < li.size(); ++i) {
            String key = li.method_10608(i);
            String fullKey = FabConf.remap("*." + key.toLowerCase(Locale.ROOT));
            if (!FeatureTaggablePlayers.activeTags.containsKey(fullKey)) {
                FabLog.warn("TaggablePlayers added " + fullKey + " as a valid option because a player was tagged with it");
                FeatureTaggablePlayers.add(fullKey, 0);
            }
            this.fabrication$tags.add(key);
        }
    }
}

