/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.mixin.b_utility.item_despawn;

import com.google.common.primitives.Ints;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.interfaces.ItemDespawn;
import com.unascribed.fabrication.interfaces.SetFromPlayerDeath;
import com.unascribed.fabrication.loaders.LoaderItemDespawn;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.injection.FabInject;
import com.unascribed.fabrication.support.injection.ModifyGetField;
import com.unascribed.fabrication.util.ParsedTime;
import com.unascribed.fabrication.util.Resolvable;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2743;
import net.minecraft.class_2777;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@EligibleIf(configAvailable="*.item_despawn")
@Mixin(value={class_1542.class})
public abstract class MixinItemEntity
extends class_1297
implements SetFromPlayerDeath,
ItemDespawn {
    private long fabrication$trueAge;
    private int fabrication$extraTime;
    private boolean fabrication$invincible;
    private boolean fabrication$fromPlayerDeath;
    @Shadow
    private int field_7204;
    @Shadow
    private UUID field_7200;

    public MixinItemEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract class_1799 method_6983();

    @FabInject(at={@At(value="HEAD")}, method={"tick()V"})
    public void tickHead(CallbackInfo ci) {
        if (this.fabrication$extraTime > 0) {
            --this.fabrication$extraTime;
            --this.field_7204;
        }
        ++this.fabrication$trueAge;
        int worldBottom = this.method_37908().method_31607();
        if (this.method_19538().field_1351 < (double)(worldBottom - 32) && this.fabrication$invincible) {
            this.method_20620(this.method_19538().field_1352, worldBottom + 1, this.method_19538().field_1350);
            this.method_18800(0.0, 0.0, 0.0);
            if (!this.method_37908().field_9236) {
                ((class_3218)this.method_37908()).method_14178().method_18751((class_1297)this, (class_2596)new class_2777((class_1297)this));
                ((class_3218)this.method_37908()).method_14178().method_18751((class_1297)this, (class_2596)new class_2743((class_1297)this));
            }
        }
    }

    @FabInject(at={@At(value="HEAD")}, method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, cancellable=true)
    public void damage(class_1282 source, float amount, CallbackInfoReturnable<Boolean> ci) {
        if (this.fabrication$invincible || FabConf.isEnabled("*.item_despawn") && this.method_37908().field_9236) {
            ci.setReturnValue((Object)false);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"setStack(Lnet/minecraft/item/ItemStack;)V"})
    public void setStack(class_1799 stack, CallbackInfo ci) {
        this.calculateDespawn();
    }

    @FabInject(at={@At(value="TAIL")}, method={"setThrower(Ljava/util/UUID;)V"})
    public void setThrower(UUID id, CallbackInfo ci) {
        this.calculateDespawn();
    }

    @ModifyGetField(target={"net/minecraft/entity/ItemEntity.itemAge:I"}, method={"canMerge()Z"})
    private static int fabrication$modifyIllegalAge(int orig, class_1542 item) {
        return item instanceof ItemDespawn && ((ItemDespawn)item).fabrication$itemDespawn$invinc() ? orig - 1 : orig;
    }

    @Override
    public boolean fabrication$itemDespawn$invinc() {
        return this.fabrication$invincible;
    }

    @Override
    public void fabrication$setFromPlayerDeath(boolean b) {
        this.fabrication$fromPlayerDeath = b;
        this.calculateDespawn();
    }

    @Unique
    private void calculateDespawn() {
        if (this.method_37908().field_9236) {
            return;
        }
        boolean debug = false;
        class_1799 stack = this.method_6983();
        ParsedTime time = LoaderItemDespawn.itemDespawns.get(Resolvable.mapKey(stack.method_7909(), class_7923.field_41178));
        if (time == null) {
            time = ParsedTime.Unset.NORMAL;
        }
        if (!time.priority) {
            for (class_1887 class_18872 : class_1890.method_8222((class_1799)stack).keySet()) {
                ParsedTime enchTime;
                if (class_18872.method_8195()) {
                    if (LoaderItemDespawn.curseDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.curseDespawn;
                    }
                } else {
                    if (LoaderItemDespawn.normalEnchDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.normalEnchDespawn;
                    }
                    if (class_18872.method_8193() && LoaderItemDespawn.treasureDespawn.overshadows(time)) {
                        time = LoaderItemDespawn.treasureDespawn;
                    }
                }
                if ((enchTime = LoaderItemDespawn.enchDespawns.get(Resolvable.mapKey(class_18872, class_7923.field_41176))) == null || !enchTime.overshadows(time)) continue;
                time = enchTime;
            }
            for (Map.Entry entry : LoaderItemDespawn.tagDespawns.entrySet()) {
                class_6862 itemTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)((class_2960)entry.getKey()));
                if (stack.method_31573(itemTag) && ((ParsedTime)entry.getValue()).overshadows(time)) {
                    time = (ParsedTime)entry.getValue();
                }
                if (!(stack.method_7909() instanceof class_1747)) continue;
                class_1747 bi = (class_1747)stack.method_7909();
                class_6862 blockTag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)((class_2960)entry.getKey()));
                if (!bi.method_7711().method_40142().method_40220(blockTag) || !((ParsedTime)entry.getValue()).overshadows(time)) continue;
                time = (ParsedTime)entry.getValue();
            }
            if (stack.method_7985()) {
                if (stack.method_7938() && LoaderItemDespawn.renamedDespawn.overshadows(time)) {
                    time = LoaderItemDespawn.renamedDespawn;
                }
                for (Map.Entry entry : LoaderItemDespawn.nbtBools.entrySet()) {
                    if (!stack.method_7969().method_10577((String)entry.getKey()) || !((ParsedTime)entry.getValue()).overshadows(time)) continue;
                    time = (ParsedTime)entry.getValue();
                }
            }
        }
        if (this.fabrication$fromPlayerDeath && LoaderItemDespawn.playerDeathDespawn.overshadows(time)) {
            time = LoaderItemDespawn.playerDeathDespawn;
        }
        if (time instanceof ParsedTime.Unset) {
            time = this.field_7200 == null ? LoaderItemDespawn.dropsDespawn : LoaderItemDespawn.defaultDespawn;
        }
        this.fabrication$invincible = false;
        if (time instanceof ParsedTime.Forever) {
            this.fabrication$extraTime = 0;
            this.field_7204 = Short.MIN_VALUE;
        } else if (time instanceof ParsedTime.Invincible) {
            this.fabrication$extraTime = 0;
            this.field_7204 = Short.MIN_VALUE;
            this.fabrication$invincible = true;
        } else if (time instanceof ParsedTime.Instant) {
            this.method_31472();
        } else if (time instanceof ParsedTime.Unset) {
            this.fabrication$extraTime = 0;
        } else {
            int extra = time.timeInTicks - 6000;
            if ((extra -= Ints.saturatedCast((long)this.fabrication$trueAge)) < 0) {
                this.field_7204 = -extra;
                this.fabrication$extraTime = 0;
            } else {
                this.field_7204 = 0;
                this.fabrication$extraTime = extra;
            }
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"writeCustomDataToNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void writeCustomDataToTag(class_2487 tag, CallbackInfo ci) {
        if (this.fabrication$extraTime > 0) {
            tag.method_10569("fabrication:ExtraTime", this.fabrication$extraTime);
        }
        tag.method_10544("fabrication:TrueAge", this.fabrication$trueAge);
        if (this.fabrication$fromPlayerDeath) {
            tag.method_10556("fabrication:FromPlayerDeath", true);
        }
        if (this.fabrication$invincible) {
            tag.method_10556("fabrication:Invincible", true);
        }
    }

    @FabInject(at={@At(value="TAIL")}, method={"readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V"})
    public void readCustomDataFromTag(class_2487 tag, CallbackInfo ci) {
        this.fabrication$extraTime = tag.method_10550("fabrication:ExtraTime");
        this.fabrication$trueAge = tag.method_10537("fabrication:TrueAge");
        this.fabrication$fromPlayerDeath = tag.method_10577("fabrication:FromPlayerDeath");
        this.fabrication$invincible = tag.method_10577("fabrication:Invincible");
    }
}

