/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.logic;

import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class PingPrivacyPersistentState
extends class_18 {
    private static final String name = "fabrication_ping_privacy";
    private final Map<InetAddress, Long> knownIps = Maps.newHashMap();
    private final ReadWriteLock rwl = new ReentrantReadWriteLock();

    public static PingPrivacyPersistentState get(class_3218 world) {
        return (PingPrivacyPersistentState)world.method_17983().method_17924(PingPrivacyPersistentState::fromNbt, PingPrivacyPersistentState::new, name);
    }

    public void addKnownIp(InetAddress addr) {
        try {
            this.rwl.writeLock().lock();
            this.knownIps.put(addr, System.currentTimeMillis());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
        this.method_80();
    }

    public boolean isKnownAndRecent(InetAddress addr) {
        try {
            this.rwl.readLock().lock();
            boolean bl = PingPrivacyPersistentState.isRecent(this.knownIps.getOrDefault(addr, 0L));
            return bl;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private static boolean isRecent(long time) {
        return System.currentTimeMillis() - time < TimeUnit.DAYS.toMillis(7L);
    }

    public static PingPrivacyPersistentState fromNbt(class_2487 tag) {
        PingPrivacyPersistentState rtrn = new PingPrivacyPersistentState();
        class_2499 li = tag.method_10554("KnownIPs", 10);
        for (int i = 0; i < li.size(); ++i) {
            InetAddress addr;
            class_2487 c = li.method_10602(i);
            long time = c.method_10537("Time");
            if (!PingPrivacyPersistentState.isRecent(time)) continue;
            try {
                addr = InetAddress.getByAddress(c.method_10547("IP"));
            }
            catch (UnknownHostException e) {
                continue;
            }
            rtrn.knownIps.put(addr, time);
        }
        return rtrn;
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 li = new class_2499();
        for (Map.Entry<InetAddress, Long> en : this.knownIps.entrySet()) {
            class_2487 c = new class_2487();
            c.method_10570("IP", en.getKey().getAddress());
            c.method_10544("Time", en.getValue().longValue());
            li.add((Object)c);
        }
        tag.method_10566("KnownIPs", (class_2520)li);
        return tag;
    }
}

