/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.collect.Lists;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.ConfigValues;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

@EligibleIf(envMatches=Env.CLIENT)
public class LoaderClassicBlockDrops
implements ConfigLoader {
    public static final List<Function<class_2960, ConfigValues.Feature>> rules = Lists.newArrayList();
    public static final Map<String, Optional<Boolean>> literals = new HashMap<String, Optional<Boolean>>();
    public static final Map<String, Optional<Boolean>> heuristics = new HashMap<String, Optional<Boolean>>();
    private static final Map<class_2248, Boolean> cache = new WeakHashMap<class_2248, Boolean>();
    public static final LoaderClassicBlockDrops instance = new LoaderClassicBlockDrops();

    public static boolean isSafe(class_2248 b) {
        if (cache.containsKey(b)) {
            return cache.get(b);
        }
        class_2960 id = class_7923.field_41175.method_10221((Object)b);
        if (id == null) {
            return false;
        }
        for (Function<class_2960, ConfigValues.Feature> rule : rules) {
            ConfigValues.Feature t = rule.apply(id);
            if (t == ConfigValues.Feature.UNSET) continue;
            boolean r = t.resolve(true);
            cache.put(b, r);
            return r;
        }
        cache.put(b, false);
        return false;
    }

    public void reload() {
        rules.clear();
        cache.clear();
        HashMap<String, Boolean> validLiterals = new HashMap<String, Boolean>();
        for (Map.Entry<String, Optional<Boolean>> entry : literals.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            validLiterals.put(entry.getKey(), entry.getValue().get());
        }
        rules.add(id -> {
            Boolean k = (Boolean)validLiterals.get(id.toString());
            if (k == null) {
                return ConfigValues.Feature.UNSET;
            }
            return k != false ? ConfigValues.Feature.TRUE : ConfigValues.Feature.FALSE;
        });
        for (Map.Entry<String, Optional<Boolean>> entry : heuristics.entrySet()) {
            String k = entry.getKey();
            if (k.contains("\\E") || k.contains("\\Q")) {
                throw new IllegalArgumentException("No.");
            }
            StringBuffer buf = new StringBuffer("^\\Q");
            Matcher m = Pattern.compile("*", 16).matcher(k);
            while (m.find()) {
                m.appendReplacement(buf, "\\\\E.*\\\\Q");
            }
            m.appendTail(buf);
            buf.append("\\E$");
            Pattern p = Pattern.compile(buf.toString());
            Optional<Boolean> valueOpt = entry.getValue();
            if (!valueOpt.isPresent()) continue;
            boolean value = valueOpt.get();
            rules.add(id -> {
                if (p.matcher(id.method_12832()).matches()) {
                    return value ? ConfigValues.Feature.TRUE : ConfigValues.Feature.FALSE;
                }
                return ConfigValues.Feature.UNSET;
            });
        }
    }

    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        heuristics.clear();
        literals.clear();
        for (String k : config.keySet()) {
            if (k.startsWith("@heuristics.")) {
                heuristics.put(k.substring(12), config.getBoolean(k));
                continue;
            }
            literals.put(k, config.getBoolean(k));
        }
        this.reload();
    }

    @Override
    public String getConfigName() {
        return "classic_block_drops";
    }
}

