/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.loaders;

import com.google.common.collect.Maps;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.unascribed.fabrication.FabLog;
import com.unascribed.fabrication.QDIni;
import com.unascribed.fabrication.support.ConfigLoader;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Env;
import com.unascribed.fabrication.support.MixinConfigPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_2246;
import net.minecraft.class_2259;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

@EligibleIf(envMatches=Env.CLIENT)
public class LoaderBlockLogo
implements ConfigLoader {
    public static boolean invalidated = true;
    public static boolean unrecoverableLoadError = false;
    public static class_1011 image;
    public static BooleanSupplier getReverse;
    public static Reverse rawReverse;
    public static final Map<Integer, Supplier<class_2680>> colorToState;
    public static boolean sound;
    public static float shadowRed;
    public static float shadowGreen;
    public static float shadowBlue;
    public static float shadowAlpha;
    public static int rawShadowRed;
    public static int rawShadowGreen;
    public static int rawShadowBlue;
    public static int rawShadowAlpha;
    public static final Map<Integer, List<String>> fullColorToState;
    public static final Set<Integer> validColors;
    public static final LoaderBlockLogo instance;
    static Path imageFile;

    @Override
    public void load(Path configDir, QDIni config, boolean loadError) {
        colorToState.clear();
        invalidated = true;
        unrecoverableLoadError = false;
        if (image != null) {
            image.close();
            image = null;
        }
        rawReverse = config.getEnum("general.reverse", Reverse.class).orElse(Reverse.FALSE);
        getReverse = LoaderBlockLogo.rawReverse.sup;
        sound = config.getBoolean("general.sound").orElse(false);
        rawShadowRed = config.getInt("shadow.red").orElse(0);
        rawShadowGreen = config.getInt("shadow.green").orElse(0);
        rawShadowBlue = config.getInt("shadow.blue").orElse(0);
        rawShadowAlpha = config.getInt("shadow.alpha").orElse(0);
        shadowRed = (float)rawShadowRed / 255.0f;
        shadowGreen = (float)rawShadowGreen / 255.0f;
        shadowBlue = (float)rawShadowBlue / 255.0f;
        shadowAlpha = (float)rawShadowAlpha / 255.0f;
        if (loadError) {
            unrecoverableLoadError = true;
            return;
        }
        FabLog.timeAndCountWarnings("Loading of block_logo.png", () -> {
            imageFile = configDir.resolve("block_logo.png");
            if (!Files.exists(imageFile, new LinkOption[0])) {
                try {
                    Resources.asByteSource((URL)MixinConfigPlugin.class.getClassLoader().getResource("default_block_logo.png")).copyTo(MoreFiles.asByteSink((Path)imageFile, (OpenOption[])new OpenOption[0]));
                }
                catch (IOException e) {
                    FabLog.warn("Failed to write default block logo", e);
                    unrecoverableLoadError = true;
                    return;
                }
            }
            LoaderBlockLogo.reloadImage();
        });
        for (String key : config.keySet()) {
            if (!key.startsWith("pixels.")) continue;
            String color = key.substring(7);
            if (color.length() != 6) {
                FabLog.warn(key + " must be a 24-bit hex color like FF0000 (got " + color + ") at " + config.getBlame(key));
                continue;
            }
            int colorInt = Integer.parseInt(color, 16);
            int swapped = colorInt & 0xFF00;
            swapped |= (colorInt & 0xFF0000) >> 16;
            String[] blocks = config.get(key).orElse("").split(" ");
            fullColorToState.put(swapped |= (colorInt & 0xFF) << 16, new ArrayList<String>(Arrays.asList(blocks)));
            colorToState.put(swapped, () -> {
                String block = blocks[ThreadLocalRandom.current().nextInt(blocks.length)];
                try {
                    return class_2259.method_41955((class_7225)class_7923.field_41175.method_46771(), (StringReader)new StringReader(block), (boolean)false).comp_622();
                }
                catch (CommandSyntaxException e) {
                    FabLog.warn(block + " is not a valid identifier at " + config.getBlame(key));
                    return class_2246.field_10124.method_9564();
                }
            });
        }
        if (image != null) {
            for (int x = 0; x < image.method_4307(); ++x) {
                for (int y = 0; y < image.method_4323(); ++y) {
                    int color = image.method_4315(x, y);
                    int alpha = color >> 24 & 0xFF;
                    if (alpha != 255 || colorToState.containsKey(color &= 0xFFFFFF)) continue;
                    FabLog.warn("At " + x + ", " + y + " in block_logo.png: Found a pixel with a color that isn't in the config: " + Integer.toHexString(color | 0xFF000000).substring(2).toUpperCase(Locale.ROOT) + "; ignoring it");
                    image.method_4305(x, y, 0);
                }
            }
        }
    }

    public static void reloadImage() {
        try (InputStream is = Files.newInputStream(imageFile, new OpenOption[0]);){
            image = class_1011.method_4309((InputStream)is);
        }
        catch (IOException e) {
            FabLog.warn("Failed to load block logo", e);
            unrecoverableLoadError = true;
            return;
        }
        validColors.clear();
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                int color = image.method_4315(x, y);
                int alpha = color >> 24 & 0xFF;
                if (alpha == 0) {
                    validColors.add(color);
                }
                if (alpha <= 0 || alpha >= 255) continue;
                FabLog.warn("At " + x + ", " + y + " in block_logo.png: Found a pixel that is not fully transparent or fully opaque; ignoring it");
                image.method_4305(x, y, 0);
            }
        }
    }

    @Override
    public String getConfigName() {
        return "block_logo";
    }

    static {
        getReverse = () -> false;
        rawReverse = Reverse.FALSE;
        colorToState = Maps.newHashMap();
        sound = false;
        shadowRed = 0.0f;
        shadowGreen = 0.0f;
        shadowBlue = 0.0f;
        shadowAlpha = 0.0f;
        rawShadowRed = 0;
        rawShadowGreen = 0;
        rawShadowBlue = 0;
        rawShadowAlpha = 0;
        fullColorToState = new HashMap<Integer, List<String>>();
        validColors = new HashSet<Integer>();
        instance = new LoaderBlockLogo();
    }

    public static enum Reverse {
        FALSE(() -> false),
        TRUE(() -> true),
        RANDOM(() -> ThreadLocalRandom.current().nextBoolean());

        public final BooleanSupplier sup;

        private Reverse(BooleanSupplier sup) {
            this.sup = sup;
        }
    }
}

