/*
 * Decompiled with CFR 0.152.
 */
package com.unascribed.fabrication.features;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.unascribed.fabrication.Agnos;
import com.unascribed.fabrication.FabConf;
import com.unascribed.fabrication.FabRefl;
import com.unascribed.fabrication.FabricationMod;
import com.unascribed.fabrication.support.EligibleIf;
import com.unascribed.fabrication.support.Feature;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.class_1267;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3036;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5268;

@EligibleIf(configAvailable="*.legacy_command_syntax")
public class FeatureLegacyCommandSyntax
implements Feature {
    private boolean applied = false;

    @Override
    public void apply() {
        if (this.applied) {
            return;
        }
        this.applied = true;
        Agnos.runForCommandRegistration((dispatcher, registryAccess, dedi) -> {
            try {
                LiteralArgumentBuilder gmCmd = (LiteralArgumentBuilder)class_2170.method_9247((String)"gamemode").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.method_9259(2));
                for (class_1934 mode : class_1934.values()) {
                    gmCmd.then(((LiteralArgumentBuilder)class_2170.method_9247((String)Integer.toString(mode.method_8379())).executes(c -> FabRefl.gameModeExecute((CommandContext<class_2168>)c, Collections.singleton(((class_2168)c.getSource()).method_9207()), mode))).then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9308()).executes(c -> FabRefl.gameModeExecute((CommandContext<class_2168>)c, class_2186.method_9312((CommandContext)c, (String)"target"), mode))));
                }
                dispatcher.register(gmCmd);
                LiteralArgumentBuilder diffCmd = (LiteralArgumentBuilder)class_2170.method_9247((String)"difficulty").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.method_9259(2));
                for (class_1267 difficulty : class_1267.values()) {
                    diffCmd.then(class_2170.method_9247((String)Integer.toString(difficulty.method_5461())).executes(c -> class_3036.method_13173((class_2168)((class_2168)c.getSource()), (class_1267)difficulty)));
                }
                dispatcher.register(diffCmd);
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"experience").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.method_9259(2))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(c -> FeatureLegacyCommandSyntax.addExperience((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount"), false))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(c -> FeatureLegacyCommandSyntax.addExperience((class_2168)c.getSource(), class_2186.method_9312((CommandContext)c, (String)"targets"), IntegerArgumentType.getInteger((CommandContext)c, (String)"amount"), false))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"lvlAmount", (ArgumentType)StringArgumentType.word()).executes(c -> FeatureLegacyCommandSyntax.addExperience((class_2168)c.getSource(), Collections.singleton(((class_2168)c.getSource()).method_9207()), StringArgumentType.getString((CommandContext)c, (String)"lvlAmount")))).then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(c -> FeatureLegacyCommandSyntax.addExperience((class_2168)c.getSource(), class_2186.method_9312((CommandContext)c, (String)"targets"), StringArgumentType.getString((CommandContext)c, (String)"lvlAmount"))))));
                dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"toggledownfall").requires(scs -> FabConf.isEnabled("*.legacy_command_syntax") && scs.method_9259(2))).executes(c -> {
                    class_3218 world = ((class_2168)c.getSource()).method_9225();
                    class_5268 props = FabRefl.getWorldProperties(world);
                    if (props.method_156()) {
                        world.method_27910(12000, 0, false, props.method_203());
                    } else {
                        world.method_27910(0, 12000, true, props.method_203());
                    }
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Toggled downfall"), true);
                    return 1;
                }));
            }
            catch (Throwable t) {
                FabricationMod.featureError(this, t, "Unknown");
            }
        });
    }

    private static int addExperience(class_2168 source, Collection<? extends class_3222> targets, int amount, boolean areLevels) {
        String string;
        for (class_3222 class_32222 : targets) {
            if (areLevels) {
                class_32222.method_7316(amount);
                continue;
            }
            class_32222.method_7255(amount);
        }
        String string2 = string = areLevels ? "levels" : "points";
        if (targets.size() == 1) {
            source.method_9226(() -> class_2561.method_43469((String)("commands.experience.add." + thing + ".success.single"), (Object[])new Object[]{amount, ((class_3222)Iterables.getOnlyElement((Iterable)targets)).method_5476()}), true);
        } else {
            source.method_9226(() -> class_2561.method_43469((String)("commands.experience.add." + thing + ".success.multiple"), (Object[])new Object[]{amount, targets.size()}), true);
        }
        return targets.size();
    }

    private static int addExperience(class_2168 source, Collection<? extends class_3222> targets, String amount) throws CommandSyntaxException {
        Integer i;
        if ((amount.endsWith("l") || amount.endsWith("L")) && (i = Ints.tryParse((String)amount.substring(0, amount.length() - 1))) != null) {
            return FeatureLegacyCommandSyntax.addExperience(source, targets, i, true);
        }
        throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Invalid XP amount")).create();
    }

    @Override
    public boolean undo() {
        return true;
    }

    @Override
    public String getConfigKey() {
        return "*.legacy_command_syntax";
    }
}

